/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.collect.ImmutableSet;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import java.util.Set;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnVlanCounterStatsRequest;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFStatsRequestFlags;
import org.projectfloodlight.openflow.protocol.OFStatsType;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.ver13.OFStatsRequestFlagsSerializerVer13;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnVlanCounterStatsRequestVer13
implements OFBsnVlanCounterStatsRequest {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnVlanCounterStatsRequestVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 26;
    private static final long DEFAULT_XID = 0L;
    private static final Set<OFStatsRequestFlags> DEFAULT_FLAGS = ImmutableSet.of();
    private static final int DEFAULT_VLAN_VID = 0;
    private final long xid;
    private final Set<OFStatsRequestFlags> flags;
    private final int vlanVid;
    static final OFBsnVlanCounterStatsRequestVer13 DEFAULT = new OFBsnVlanCounterStatsRequestVer13(0L, DEFAULT_FLAGS, 0);
    static final Reader READER = new Reader();
    static final OFBsnVlanCounterStatsRequestVer13Funnel FUNNEL = new OFBsnVlanCounterStatsRequestVer13Funnel();
    static final Writer WRITER = new Writer();

    OFBsnVlanCounterStatsRequestVer13(long xid, Set<OFStatsRequestFlags> flags, int vlanVid) {
        this.xid = xid;
        this.flags = flags;
        this.vlanVid = vlanVid;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFType getType() {
        return OFType.STATS_REQUEST;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public OFStatsType getStatsType() {
        return OFStatsType.EXPERIMENTER;
    }

    @Override
    public Set<OFStatsRequestFlags> getFlags() {
        return this.flags;
    }

    @Override
    public long getExperimenter() {
        return 6035143L;
    }

    @Override
    public long getSubtype() {
        return 9L;
    }

    @Override
    public int getVlanVid() {
        return this.vlanVid;
    }

    @Override
    public OFBsnVlanCounterStatsRequest.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnVlanCounterStatsRequestVer13(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("flags=").append(this.flags);
        b.append(", ");
        b.append("vlanVid=").append(this.vlanVid);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnVlanCounterStatsRequestVer13 other = (OFBsnVlanCounterStatsRequestVer13)obj;
        if (this.xid != other.xid) {
            return false;
        }
        if (this.flags == null ? other.flags != null : !this.flags.equals(other.flags)) {
            return false;
        }
        return this.vlanVid == other.vlanVid;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + (this.flags == null ? 0 : this.flags.hashCode());
        result = 31 * result + this.vlanVid;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnVlanCounterStatsRequestVer13> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFBsnVlanCounterStatsRequestVer13 message) {
            bb.writeByte(4);
            bb.writeByte(18);
            bb.writeShort(26);
            bb.writeInt(U32.t(message.xid));
            bb.writeShort(-1);
            OFStatsRequestFlagsSerializerVer13.writeTo(bb, message.flags);
            bb.writeZero(4);
            bb.writeInt(6035143);
            bb.writeInt(9);
            bb.writeShort((int)U16.t(message.vlanVid));
        }
    }

    static class OFBsnVlanCounterStatsRequestVer13Funnel
    implements Funnel<OFBsnVlanCounterStatsRequestVer13> {
        private static final long serialVersionUID = 1L;

        OFBsnVlanCounterStatsRequestVer13Funnel() {
        }

        public void funnel(OFBsnVlanCounterStatsRequestVer13 message, PrimitiveSink sink) {
            sink.putByte((byte)4);
            sink.putByte((byte)18);
            sink.putShort((short)26);
            sink.putLong(message.xid);
            sink.putShort((short)-1);
            OFStatsRequestFlagsSerializerVer13.putTo(message.flags, sink);
            sink.putInt(6035143);
            sink.putInt(9);
            sink.putInt(message.vlanVid);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnVlanCounterStatsRequest> {
        Reader() {
        }

        @Override
        public OFBsnVlanCounterStatsRequest readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 4) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_13(4), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 18) {
                throw new OFParseError("Wrong type: Expected=OFType.STATS_REQUEST(18), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 26) {
                throw new OFParseError("Wrong length: Expected=26(26), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            short statsType = bb.readShort();
            if (statsType != -1) {
                throw new OFParseError("Wrong statsType: Expected=OFStatsType.EXPERIMENTER(65535), got=" + statsType);
            }
            Set<OFStatsRequestFlags> flags = OFStatsRequestFlagsSerializerVer13.readFrom(bb);
            bb.skipBytes(4);
            int experimenter = bb.readInt();
            if (experimenter != 6035143) {
                throw new OFParseError("Wrong experimenter: Expected=0x5c16c7L(0x5c16c7L), got=" + experimenter);
            }
            int subtype = bb.readInt();
            if (subtype != 9) {
                throw new OFParseError("Wrong subtype: Expected=0x9L(0x9L), got=" + subtype);
            }
            int vlanVid = U16.f(bb.readShort());
            OFBsnVlanCounterStatsRequestVer13 bsnVlanCounterStatsRequestVer13 = new OFBsnVlanCounterStatsRequestVer13(xid, flags, vlanVid);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnVlanCounterStatsRequestVer13);
            }
            return bsnVlanCounterStatsRequestVer13;
        }
    }

    static class Builder
    implements OFBsnVlanCounterStatsRequest.Builder {
        private boolean xidSet;
        private long xid;
        private boolean flagsSet;
        private Set<OFStatsRequestFlags> flags;
        private boolean vlanVidSet;
        private int vlanVid;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFType getType() {
            return OFType.STATS_REQUEST;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnVlanCounterStatsRequest.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFStatsType getStatsType() {
            return OFStatsType.EXPERIMENTER;
        }

        @Override
        public Set<OFStatsRequestFlags> getFlags() {
            return this.flags;
        }

        @Override
        public OFBsnVlanCounterStatsRequest.Builder setFlags(Set<OFStatsRequestFlags> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 9L;
        }

        @Override
        public int getVlanVid() {
            return this.vlanVid;
        }

        @Override
        public OFBsnVlanCounterStatsRequest.Builder setVlanVid(int vlanVid) {
            this.vlanVid = vlanVid;
            this.vlanVidSet = true;
            return this;
        }

        @Override
        public OFBsnVlanCounterStatsRequest build() {
            Set<OFStatsRequestFlags> flags;
            long xid = this.xidSet ? this.xid : 0L;
            Set<OFStatsRequestFlags> set = flags = this.flagsSet ? this.flags : DEFAULT_FLAGS;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            int vlanVid = this.vlanVidSet ? this.vlanVid : 0;
            return new OFBsnVlanCounterStatsRequestVer13(xid, flags, vlanVid);
        }
    }

    static class BuilderWithParent
    implements OFBsnVlanCounterStatsRequest.Builder {
        final OFBsnVlanCounterStatsRequestVer13 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean flagsSet;
        private Set<OFStatsRequestFlags> flags;
        private boolean vlanVidSet;
        private int vlanVid;

        BuilderWithParent(OFBsnVlanCounterStatsRequestVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFType getType() {
            return OFType.STATS_REQUEST;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnVlanCounterStatsRequest.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFStatsType getStatsType() {
            return OFStatsType.EXPERIMENTER;
        }

        @Override
        public Set<OFStatsRequestFlags> getFlags() {
            return this.flags;
        }

        @Override
        public OFBsnVlanCounterStatsRequest.Builder setFlags(Set<OFStatsRequestFlags> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 9L;
        }

        @Override
        public int getVlanVid() {
            return this.vlanVid;
        }

        @Override
        public OFBsnVlanCounterStatsRequest.Builder setVlanVid(int vlanVid) {
            this.vlanVid = vlanVid;
            this.vlanVidSet = true;
            return this;
        }

        @Override
        public OFBsnVlanCounterStatsRequest build() {
            Set flags;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            Set set = flags = this.flagsSet ? this.flags : this.parentMessage.flags;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            int vlanVid = this.vlanVidSet ? this.vlanVid : this.parentMessage.vlanVid;
            return new OFBsnVlanCounterStatsRequestVer13(xid, flags, vlanVid);
        }
    }
}

