/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFExperimenter;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.ver13.OFBsnHeaderVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFCircuitPortStatusVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFNiciraHeaderVer13;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;

abstract class OFExperimenterVer13 {
    static final byte WIRE_VERSION = 4;
    static final int MINIMUM_LENGTH = 16;
    public static final Reader READER = new Reader();

    OFExperimenterVer13() {
    }

    static class Reader
    implements OFMessageReader<OFExperimenter> {
        Reader() {
        }

        @Override
        public OFExperimenter readFrom(ChannelBuffer bb) throws OFParseError {
            if (bb.readableBytes() < 16) {
                return null;
            }
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 4) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_13(4), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 4) {
                throw new OFParseError("Wrong type: Expected=OFType.EXPERIMENTER(4), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 16) {
                throw new OFParseError("Wrong length: Expected to be >= 16, was: " + length);
            }
            U32.f(bb.readInt());
            int experimenter = bb.readInt();
            bb.readerIndex(start);
            switch (experimenter) {
                case 6035143: {
                    return OFBsnHeaderVer13.READER.readFrom(bb);
                }
                case 8992: {
                    return OFNiciraHeaderVer13.READER.readFrom(bb);
                }
                case 7636849: {
                    return OFCircuitPortStatusVer13.READER.readFrom(bb);
                }
            }
            throw new OFParseError("Unknown value for discriminator experimenter of class OFExperimenterVer13: " + experimenter);
        }
    }
}

