/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFFlowRemoved;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.Match;
import org.projectfloodlight.openflow.protocol.ver13.ChannelUtilsVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFFactoryVer13;
import org.projectfloodlight.openflow.types.TableId;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.types.U64;
import org.projectfloodlight.openflow.types.U8;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFFlowRemovedVer13
implements OFFlowRemoved {
    private static final Logger logger = LoggerFactory.getLogger(OFFlowRemovedVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int MINIMUM_LENGTH = 56;
    private static final long DEFAULT_XID = 0L;
    private static final U64 DEFAULT_COOKIE = U64.ZERO;
    private static final int DEFAULT_PRIORITY = 0;
    private static final short DEFAULT_REASON = 0;
    private static final TableId DEFAULT_TABLE_ID = TableId.ALL;
    private static final long DEFAULT_DURATION_SEC = 0L;
    private static final long DEFAULT_DURATION_NSEC = 0L;
    private static final int DEFAULT_IDLE_TIMEOUT = 0;
    private static final int DEFAULT_HARD_TIMEOUT = 0;
    private static final U64 DEFAULT_PACKET_COUNT = U64.ZERO;
    private static final U64 DEFAULT_BYTE_COUNT = U64.ZERO;
    private static final Match DEFAULT_MATCH = OFFactoryVer13.MATCH_WILDCARD_ALL;
    private final long xid;
    private final U64 cookie;
    private final int priority;
    private final short reason;
    private final TableId tableId;
    private final long durationSec;
    private final long durationNsec;
    private final int idleTimeout;
    private final int hardTimeout;
    private final U64 packetCount;
    private final U64 byteCount;
    private final Match match;
    static final OFFlowRemovedVer13 DEFAULT = new OFFlowRemovedVer13(0L, DEFAULT_COOKIE, 0, 0, DEFAULT_TABLE_ID, 0L, 0L, 0, 0, DEFAULT_PACKET_COUNT, DEFAULT_BYTE_COUNT, DEFAULT_MATCH);
    static final Reader READER = new Reader();
    static final OFFlowRemovedVer13Funnel FUNNEL = new OFFlowRemovedVer13Funnel();
    static final Writer WRITER = new Writer();

    OFFlowRemovedVer13(long xid, U64 cookie, int priority, short reason, TableId tableId, long durationSec, long durationNsec, int idleTimeout, int hardTimeout, U64 packetCount, U64 byteCount, Match match) {
        this.xid = xid;
        this.cookie = cookie;
        this.priority = priority;
        this.reason = reason;
        this.tableId = tableId;
        this.durationSec = durationSec;
        this.durationNsec = durationNsec;
        this.idleTimeout = idleTimeout;
        this.hardTimeout = hardTimeout;
        this.packetCount = packetCount;
        this.byteCount = byteCount;
        this.match = match;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFType getType() {
        return OFType.FLOW_REMOVED;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public U64 getCookie() {
        return this.cookie;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public short getReason() {
        return this.reason;
    }

    @Override
    public TableId getTableId() {
        return this.tableId;
    }

    @Override
    public long getDurationSec() {
        return this.durationSec;
    }

    @Override
    public long getDurationNsec() {
        return this.durationNsec;
    }

    @Override
    public int getIdleTimeout() {
        return this.idleTimeout;
    }

    @Override
    public int getHardTimeout() {
        return this.hardTimeout;
    }

    @Override
    public U64 getPacketCount() {
        return this.packetCount;
    }

    @Override
    public U64 getByteCount() {
        return this.byteCount;
    }

    @Override
    public Match getMatch() {
        return this.match;
    }

    @Override
    public OFFlowRemoved.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFFlowRemovedVer13(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("cookie=").append(this.cookie);
        b.append(", ");
        b.append("priority=").append(this.priority);
        b.append(", ");
        b.append("reason=").append(this.reason);
        b.append(", ");
        b.append("tableId=").append(this.tableId);
        b.append(", ");
        b.append("durationSec=").append(this.durationSec);
        b.append(", ");
        b.append("durationNsec=").append(this.durationNsec);
        b.append(", ");
        b.append("idleTimeout=").append(this.idleTimeout);
        b.append(", ");
        b.append("hardTimeout=").append(this.hardTimeout);
        b.append(", ");
        b.append("packetCount=").append(this.packetCount);
        b.append(", ");
        b.append("byteCount=").append(this.byteCount);
        b.append(", ");
        b.append("match=").append(this.match);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFFlowRemovedVer13 other = (OFFlowRemovedVer13)obj;
        if (this.xid != other.xid) {
            return false;
        }
        if (this.cookie == null ? other.cookie != null : !this.cookie.equals(other.cookie)) {
            return false;
        }
        if (this.priority != other.priority) {
            return false;
        }
        if (this.reason != other.reason) {
            return false;
        }
        if (this.tableId == null ? other.tableId != null : !this.tableId.equals(other.tableId)) {
            return false;
        }
        if (this.durationSec != other.durationSec) {
            return false;
        }
        if (this.durationNsec != other.durationNsec) {
            return false;
        }
        if (this.idleTimeout != other.idleTimeout) {
            return false;
        }
        if (this.hardTimeout != other.hardTimeout) {
            return false;
        }
        if (this.packetCount == null ? other.packetCount != null : !this.packetCount.equals(other.packetCount)) {
            return false;
        }
        if (this.byteCount == null ? other.byteCount != null : !this.byteCount.equals(other.byteCount)) {
            return false;
        }
        return !(this.match == null ? other.match != null : !this.match.equals(other.match));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + (this.cookie == null ? 0 : this.cookie.hashCode());
        result = 31 * result + this.priority;
        result = 31 * result + this.reason;
        result = 31 * result + (this.tableId == null ? 0 : this.tableId.hashCode());
        result = 31 * (int)(this.durationSec ^ this.durationSec >>> 32);
        result = 31 * (int)(this.durationNsec ^ this.durationNsec >>> 32);
        result = 31 * result + this.idleTimeout;
        result = 31 * result + this.hardTimeout;
        result = 31 * result + (this.packetCount == null ? 0 : this.packetCount.hashCode());
        result = 31 * result + (this.byteCount == null ? 0 : this.byteCount.hashCode());
        result = 31 * result + (this.match == null ? 0 : this.match.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFFlowRemovedVer13> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFFlowRemovedVer13 message) {
            int startIndex = bb.writerIndex();
            bb.writeByte(4);
            bb.writeByte(11);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            bb.writeInt(U32.t(message.xid));
            bb.writeLong(message.cookie.getValue());
            bb.writeShort((int)U16.t(message.priority));
            bb.writeByte((int)U8.t(message.reason));
            message.tableId.writeByte(bb);
            bb.writeInt(U32.t(message.durationSec));
            bb.writeInt(U32.t(message.durationNsec));
            bb.writeShort((int)U16.t(message.idleTimeout));
            bb.writeShort((int)U16.t(message.hardTimeout));
            bb.writeLong(message.packetCount.getValue());
            bb.writeLong(message.byteCount.getValue());
            message.match.writeTo(bb);
            int length = bb.writerIndex() - startIndex;
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFFlowRemovedVer13Funnel
    implements Funnel<OFFlowRemovedVer13> {
        private static final long serialVersionUID = 1L;

        OFFlowRemovedVer13Funnel() {
        }

        public void funnel(OFFlowRemovedVer13 message, PrimitiveSink sink) {
            sink.putByte((byte)4);
            sink.putByte((byte)11);
            sink.putLong(message.xid);
            message.cookie.putTo(sink);
            sink.putInt(message.priority);
            sink.putShort(message.reason);
            message.tableId.putTo(sink);
            sink.putLong(message.durationSec);
            sink.putLong(message.durationNsec);
            sink.putInt(message.idleTimeout);
            sink.putInt(message.hardTimeout);
            message.packetCount.putTo(sink);
            message.byteCount.putTo(sink);
            message.match.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFFlowRemoved> {
        Reader() {
        }

        @Override
        public OFFlowRemoved readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 4) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_13(4), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 11) {
                throw new OFParseError("Wrong type: Expected=OFType.FLOW_REMOVED(11), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 56) {
                throw new OFParseError("Wrong length: Expected to be >= 56, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            U64 cookie = U64.ofRaw(bb.readLong());
            int priority = U16.f(bb.readShort());
            short reason = U8.f(bb.readByte());
            TableId tableId = TableId.readByte(bb);
            long durationSec = U32.f(bb.readInt());
            long durationNsec = U32.f(bb.readInt());
            int idleTimeout = U16.f(bb.readShort());
            int hardTimeout = U16.f(bb.readShort());
            U64 packetCount = U64.ofRaw(bb.readLong());
            U64 byteCount = U64.ofRaw(bb.readLong());
            Match match = ChannelUtilsVer13.readOFMatch(bb);
            OFFlowRemovedVer13 flowRemovedVer13 = new OFFlowRemovedVer13(xid, cookie, priority, reason, tableId, durationSec, durationNsec, idleTimeout, hardTimeout, packetCount, byteCount, match);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)flowRemovedVer13);
            }
            return flowRemovedVer13;
        }
    }

    static class Builder
    implements OFFlowRemoved.Builder {
        private boolean xidSet;
        private long xid;
        private boolean cookieSet;
        private U64 cookie;
        private boolean prioritySet;
        private int priority;
        private boolean reasonSet;
        private short reason;
        private boolean tableIdSet;
        private TableId tableId;
        private boolean durationSecSet;
        private long durationSec;
        private boolean durationNsecSet;
        private long durationNsec;
        private boolean idleTimeoutSet;
        private int idleTimeout;
        private boolean hardTimeoutSet;
        private int hardTimeout;
        private boolean packetCountSet;
        private U64 packetCount;
        private boolean byteCountSet;
        private U64 byteCount;
        private boolean matchSet;
        private Match match;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFType getType() {
            return OFType.FLOW_REMOVED;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFFlowRemoved.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public U64 getCookie() {
            return this.cookie;
        }

        @Override
        public OFFlowRemoved.Builder setCookie(U64 cookie) {
            this.cookie = cookie;
            this.cookieSet = true;
            return this;
        }

        @Override
        public int getPriority() {
            return this.priority;
        }

        @Override
        public OFFlowRemoved.Builder setPriority(int priority) {
            this.priority = priority;
            this.prioritySet = true;
            return this;
        }

        @Override
        public short getReason() {
            return this.reason;
        }

        @Override
        public OFFlowRemoved.Builder setReason(short reason) {
            this.reason = reason;
            this.reasonSet = true;
            return this;
        }

        @Override
        public TableId getTableId() {
            return this.tableId;
        }

        @Override
        public OFFlowRemoved.Builder setTableId(TableId tableId) {
            this.tableId = tableId;
            this.tableIdSet = true;
            return this;
        }

        @Override
        public long getDurationSec() {
            return this.durationSec;
        }

        @Override
        public OFFlowRemoved.Builder setDurationSec(long durationSec) {
            this.durationSec = durationSec;
            this.durationSecSet = true;
            return this;
        }

        @Override
        public long getDurationNsec() {
            return this.durationNsec;
        }

        @Override
        public OFFlowRemoved.Builder setDurationNsec(long durationNsec) {
            this.durationNsec = durationNsec;
            this.durationNsecSet = true;
            return this;
        }

        @Override
        public int getIdleTimeout() {
            return this.idleTimeout;
        }

        @Override
        public OFFlowRemoved.Builder setIdleTimeout(int idleTimeout) {
            this.idleTimeout = idleTimeout;
            this.idleTimeoutSet = true;
            return this;
        }

        @Override
        public int getHardTimeout() {
            return this.hardTimeout;
        }

        @Override
        public OFFlowRemoved.Builder setHardTimeout(int hardTimeout) {
            this.hardTimeout = hardTimeout;
            this.hardTimeoutSet = true;
            return this;
        }

        @Override
        public U64 getPacketCount() {
            return this.packetCount;
        }

        @Override
        public OFFlowRemoved.Builder setPacketCount(U64 packetCount) {
            this.packetCount = packetCount;
            this.packetCountSet = true;
            return this;
        }

        @Override
        public U64 getByteCount() {
            return this.byteCount;
        }

        @Override
        public OFFlowRemoved.Builder setByteCount(U64 byteCount) {
            this.byteCount = byteCount;
            this.byteCountSet = true;
            return this;
        }

        @Override
        public Match getMatch() {
            return this.match;
        }

        @Override
        public OFFlowRemoved.Builder setMatch(Match match) {
            this.match = match;
            this.matchSet = true;
            return this;
        }

        @Override
        public OFFlowRemoved build() {
            Match match;
            U64 byteCount;
            U64 packetCount;
            TableId tableId;
            U64 cookie;
            long xid = this.xidSet ? this.xid : 0L;
            U64 u64 = cookie = this.cookieSet ? this.cookie : DEFAULT_COOKIE;
            if (cookie == null) {
                throw new NullPointerException("Property cookie must not be null");
            }
            int priority = this.prioritySet ? this.priority : 0;
            short reason = this.reasonSet ? this.reason : (short)0;
            TableId tableId2 = tableId = this.tableIdSet ? this.tableId : DEFAULT_TABLE_ID;
            if (tableId == null) {
                throw new NullPointerException("Property tableId must not be null");
            }
            long durationSec = this.durationSecSet ? this.durationSec : 0L;
            long durationNsec = this.durationNsecSet ? this.durationNsec : 0L;
            int idleTimeout = this.idleTimeoutSet ? this.idleTimeout : 0;
            int hardTimeout = this.hardTimeoutSet ? this.hardTimeout : 0;
            U64 u642 = packetCount = this.packetCountSet ? this.packetCount : DEFAULT_PACKET_COUNT;
            if (packetCount == null) {
                throw new NullPointerException("Property packetCount must not be null");
            }
            U64 u643 = byteCount = this.byteCountSet ? this.byteCount : DEFAULT_BYTE_COUNT;
            if (byteCount == null) {
                throw new NullPointerException("Property byteCount must not be null");
            }
            Match match2 = match = this.matchSet ? this.match : DEFAULT_MATCH;
            if (match == null) {
                throw new NullPointerException("Property match must not be null");
            }
            return new OFFlowRemovedVer13(xid, cookie, priority, reason, tableId, durationSec, durationNsec, idleTimeout, hardTimeout, packetCount, byteCount, match);
        }
    }

    static class BuilderWithParent
    implements OFFlowRemoved.Builder {
        final OFFlowRemovedVer13 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean cookieSet;
        private U64 cookie;
        private boolean prioritySet;
        private int priority;
        private boolean reasonSet;
        private short reason;
        private boolean tableIdSet;
        private TableId tableId;
        private boolean durationSecSet;
        private long durationSec;
        private boolean durationNsecSet;
        private long durationNsec;
        private boolean idleTimeoutSet;
        private int idleTimeout;
        private boolean hardTimeoutSet;
        private int hardTimeout;
        private boolean packetCountSet;
        private U64 packetCount;
        private boolean byteCountSet;
        private U64 byteCount;
        private boolean matchSet;
        private Match match;

        BuilderWithParent(OFFlowRemovedVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFType getType() {
            return OFType.FLOW_REMOVED;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFFlowRemoved.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public U64 getCookie() {
            return this.cookie;
        }

        @Override
        public OFFlowRemoved.Builder setCookie(U64 cookie) {
            this.cookie = cookie;
            this.cookieSet = true;
            return this;
        }

        @Override
        public int getPriority() {
            return this.priority;
        }

        @Override
        public OFFlowRemoved.Builder setPriority(int priority) {
            this.priority = priority;
            this.prioritySet = true;
            return this;
        }

        @Override
        public short getReason() {
            return this.reason;
        }

        @Override
        public OFFlowRemoved.Builder setReason(short reason) {
            this.reason = reason;
            this.reasonSet = true;
            return this;
        }

        @Override
        public TableId getTableId() {
            return this.tableId;
        }

        @Override
        public OFFlowRemoved.Builder setTableId(TableId tableId) {
            this.tableId = tableId;
            this.tableIdSet = true;
            return this;
        }

        @Override
        public long getDurationSec() {
            return this.durationSec;
        }

        @Override
        public OFFlowRemoved.Builder setDurationSec(long durationSec) {
            this.durationSec = durationSec;
            this.durationSecSet = true;
            return this;
        }

        @Override
        public long getDurationNsec() {
            return this.durationNsec;
        }

        @Override
        public OFFlowRemoved.Builder setDurationNsec(long durationNsec) {
            this.durationNsec = durationNsec;
            this.durationNsecSet = true;
            return this;
        }

        @Override
        public int getIdleTimeout() {
            return this.idleTimeout;
        }

        @Override
        public OFFlowRemoved.Builder setIdleTimeout(int idleTimeout) {
            this.idleTimeout = idleTimeout;
            this.idleTimeoutSet = true;
            return this;
        }

        @Override
        public int getHardTimeout() {
            return this.hardTimeout;
        }

        @Override
        public OFFlowRemoved.Builder setHardTimeout(int hardTimeout) {
            this.hardTimeout = hardTimeout;
            this.hardTimeoutSet = true;
            return this;
        }

        @Override
        public U64 getPacketCount() {
            return this.packetCount;
        }

        @Override
        public OFFlowRemoved.Builder setPacketCount(U64 packetCount) {
            this.packetCount = packetCount;
            this.packetCountSet = true;
            return this;
        }

        @Override
        public U64 getByteCount() {
            return this.byteCount;
        }

        @Override
        public OFFlowRemoved.Builder setByteCount(U64 byteCount) {
            this.byteCount = byteCount;
            this.byteCountSet = true;
            return this;
        }

        @Override
        public Match getMatch() {
            return this.match;
        }

        @Override
        public OFFlowRemoved.Builder setMatch(Match match) {
            this.match = match;
            this.matchSet = true;
            return this;
        }

        @Override
        public OFFlowRemoved build() {
            Match match;
            U64 byteCount;
            U64 packetCount;
            TableId tableId;
            U64 cookie;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            U64 u64 = cookie = this.cookieSet ? this.cookie : this.parentMessage.cookie;
            if (cookie == null) {
                throw new NullPointerException("Property cookie must not be null");
            }
            int priority = this.prioritySet ? this.priority : this.parentMessage.priority;
            short reason = this.reasonSet ? this.reason : this.parentMessage.reason;
            TableId tableId2 = tableId = this.tableIdSet ? this.tableId : this.parentMessage.tableId;
            if (tableId == null) {
                throw new NullPointerException("Property tableId must not be null");
            }
            long durationSec = this.durationSecSet ? this.durationSec : this.parentMessage.durationSec;
            long durationNsec = this.durationNsecSet ? this.durationNsec : this.parentMessage.durationNsec;
            int idleTimeout = this.idleTimeoutSet ? this.idleTimeout : this.parentMessage.idleTimeout;
            int hardTimeout = this.hardTimeoutSet ? this.hardTimeout : this.parentMessage.hardTimeout;
            U64 u642 = packetCount = this.packetCountSet ? this.packetCount : this.parentMessage.packetCount;
            if (packetCount == null) {
                throw new NullPointerException("Property packetCount must not be null");
            }
            U64 u643 = byteCount = this.byteCountSet ? this.byteCount : this.parentMessage.byteCount;
            if (byteCount == null) {
                throw new NullPointerException("Property byteCount must not be null");
            }
            Match match2 = match = this.matchSet ? this.match : this.parentMessage.match;
            if (match == null) {
                throw new NullPointerException("Property match must not be null");
            }
            return new OFFlowRemovedVer13(xid, cookie, priority, reason, tableId, durationSec, durationNsec, idleTimeout, hardTimeout, packetCount, byteCount, match);
        }
    }
}

