/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.collect.ImmutableList;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import java.util.List;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBucketCounter;
import org.projectfloodlight.openflow.protocol.OFGroupStatsEntry;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.ver13.OFBucketCounterVer13;
import org.projectfloodlight.openflow.types.OFGroup;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.types.U64;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.projectfloodlight.openflow.util.FunnelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFGroupStatsEntryVer13
implements OFGroupStatsEntry {
    private static final Logger logger = LoggerFactory.getLogger(OFGroupStatsEntryVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int MINIMUM_LENGTH = 40;
    private static final OFGroup DEFAULT_GROUP_ID = OFGroup.ALL;
    private static final long DEFAULT_REF_COUNT = 0L;
    private static final U64 DEFAULT_PACKET_COUNT = U64.ZERO;
    private static final U64 DEFAULT_BYTE_COUNT = U64.ZERO;
    private static final long DEFAULT_DURATION_SEC = 0L;
    private static final long DEFAULT_DURATION_NSEC = 0L;
    private static final List<OFBucketCounter> DEFAULT_BUCKET_STATS = ImmutableList.of();
    private final OFGroup group;
    private final long refCount;
    private final U64 packetCount;
    private final U64 byteCount;
    private final long durationSec;
    private final long durationNsec;
    private final List<OFBucketCounter> bucketStats;
    static final OFGroupStatsEntryVer13 DEFAULT = new OFGroupStatsEntryVer13(DEFAULT_GROUP_ID, 0L, DEFAULT_PACKET_COUNT, DEFAULT_BYTE_COUNT, 0L, 0L, DEFAULT_BUCKET_STATS);
    static final Reader READER = new Reader();
    static final OFGroupStatsEntryVer13Funnel FUNNEL = new OFGroupStatsEntryVer13Funnel();
    static final Writer WRITER = new Writer();

    OFGroupStatsEntryVer13(OFGroup group, long refCount, U64 packetCount, U64 byteCount, long durationSec, long durationNsec, List<OFBucketCounter> bucketStats) {
        this.group = group;
        this.refCount = refCount;
        this.packetCount = packetCount;
        this.byteCount = byteCount;
        this.durationSec = durationSec;
        this.durationNsec = durationNsec;
        this.bucketStats = bucketStats;
    }

    @Override
    public OFGroup getGroup() {
        return this.group;
    }

    @Override
    public long getRefCount() {
        return this.refCount;
    }

    @Override
    public U64 getPacketCount() {
        return this.packetCount;
    }

    @Override
    public U64 getByteCount() {
        return this.byteCount;
    }

    @Override
    public List<OFBucketCounter> getBucketStats() {
        return this.bucketStats;
    }

    @Override
    public long getDurationSec() {
        return this.durationSec;
    }

    @Override
    public long getDurationNsec() {
        return this.durationNsec;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFGroupStatsEntry.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFGroupStatsEntryVer13(");
        b.append("group=").append(this.group);
        b.append(", ");
        b.append("refCount=").append(this.refCount);
        b.append(", ");
        b.append("packetCount=").append(this.packetCount);
        b.append(", ");
        b.append("byteCount=").append(this.byteCount);
        b.append(", ");
        b.append("durationSec=").append(this.durationSec);
        b.append(", ");
        b.append("durationNsec=").append(this.durationNsec);
        b.append(", ");
        b.append("bucketStats=").append(this.bucketStats);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFGroupStatsEntryVer13 other = (OFGroupStatsEntryVer13)obj;
        if (this.group == null ? other.group != null : !this.group.equals(other.group)) {
            return false;
        }
        if (this.refCount != other.refCount) {
            return false;
        }
        if (this.packetCount == null ? other.packetCount != null : !this.packetCount.equals(other.packetCount)) {
            return false;
        }
        if (this.byteCount == null ? other.byteCount != null : !this.byteCount.equals(other.byteCount)) {
            return false;
        }
        if (this.durationSec != other.durationSec) {
            return false;
        }
        if (this.durationNsec != other.durationNsec) {
            return false;
        }
        return !(this.bucketStats == null ? other.bucketStats != null : !this.bucketStats.equals(other.bucketStats));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.group == null ? 0 : this.group.hashCode());
        result = 31 * (int)(this.refCount ^ this.refCount >>> 32);
        result = 31 * result + (this.packetCount == null ? 0 : this.packetCount.hashCode());
        result = 31 * result + (this.byteCount == null ? 0 : this.byteCount.hashCode());
        result = 31 * (int)(this.durationSec ^ this.durationSec >>> 32);
        result = 31 * (int)(this.durationNsec ^ this.durationNsec >>> 32);
        result = 31 * result + (this.bucketStats == null ? 0 : this.bucketStats.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFGroupStatsEntryVer13> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFGroupStatsEntryVer13 message) {
            int startIndex = bb.writerIndex();
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            bb.writeZero(2);
            message.group.write4Bytes(bb);
            bb.writeInt(U32.t(message.refCount));
            bb.writeZero(4);
            bb.writeLong(message.packetCount.getValue());
            bb.writeLong(message.byteCount.getValue());
            bb.writeInt(U32.t(message.durationSec));
            bb.writeInt(U32.t(message.durationNsec));
            ChannelUtils.writeList(bb, message.bucketStats);
            int length = bb.writerIndex() - startIndex;
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFGroupStatsEntryVer13Funnel
    implements Funnel<OFGroupStatsEntryVer13> {
        private static final long serialVersionUID = 1L;

        OFGroupStatsEntryVer13Funnel() {
        }

        public void funnel(OFGroupStatsEntryVer13 message, PrimitiveSink sink) {
            message.group.putTo(sink);
            sink.putLong(message.refCount);
            message.packetCount.putTo(sink);
            message.byteCount.putTo(sink);
            sink.putLong(message.durationSec);
            sink.putLong(message.durationNsec);
            FunnelUtils.putList(message.bucketStats, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFGroupStatsEntry> {
        Reader() {
        }

        @Override
        public OFGroupStatsEntry readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            int length = U16.f(bb.readShort());
            if (length < 40) {
                throw new OFParseError("Wrong length: Expected to be >= 40, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            bb.skipBytes(2);
            OFGroup group = OFGroup.read4Bytes(bb);
            long refCount = U32.f(bb.readInt());
            bb.skipBytes(4);
            U64 packetCount = U64.ofRaw(bb.readLong());
            U64 byteCount = U64.ofRaw(bb.readLong());
            long durationSec = U32.f(bb.readInt());
            long durationNsec = U32.f(bb.readInt());
            List<OFBucketCounter> bucketStats = ChannelUtils.readList(bb, length - (bb.readerIndex() - start), OFBucketCounterVer13.READER);
            OFGroupStatsEntryVer13 groupStatsEntryVer13 = new OFGroupStatsEntryVer13(group, refCount, packetCount, byteCount, durationSec, durationNsec, bucketStats);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)groupStatsEntryVer13);
            }
            return groupStatsEntryVer13;
        }
    }

    static class Builder
    implements OFGroupStatsEntry.Builder {
        private boolean groupSet;
        private OFGroup group;
        private boolean refCountSet;
        private long refCount;
        private boolean packetCountSet;
        private U64 packetCount;
        private boolean byteCountSet;
        private U64 byteCount;
        private boolean durationSecSet;
        private long durationSec;
        private boolean durationNsecSet;
        private long durationNsec;
        private boolean bucketStatsSet;
        private List<OFBucketCounter> bucketStats;

        Builder() {
        }

        @Override
        public OFGroup getGroup() {
            return this.group;
        }

        @Override
        public OFGroupStatsEntry.Builder setGroup(OFGroup group) {
            this.group = group;
            this.groupSet = true;
            return this;
        }

        @Override
        public long getRefCount() {
            return this.refCount;
        }

        @Override
        public OFGroupStatsEntry.Builder setRefCount(long refCount) {
            this.refCount = refCount;
            this.refCountSet = true;
            return this;
        }

        @Override
        public U64 getPacketCount() {
            return this.packetCount;
        }

        @Override
        public OFGroupStatsEntry.Builder setPacketCount(U64 packetCount) {
            this.packetCount = packetCount;
            this.packetCountSet = true;
            return this;
        }

        @Override
        public U64 getByteCount() {
            return this.byteCount;
        }

        @Override
        public OFGroupStatsEntry.Builder setByteCount(U64 byteCount) {
            this.byteCount = byteCount;
            this.byteCountSet = true;
            return this;
        }

        @Override
        public List<OFBucketCounter> getBucketStats() {
            return this.bucketStats;
        }

        @Override
        public OFGroupStatsEntry.Builder setBucketStats(List<OFBucketCounter> bucketStats) {
            this.bucketStats = bucketStats;
            this.bucketStatsSet = true;
            return this;
        }

        @Override
        public long getDurationSec() {
            return this.durationSec;
        }

        @Override
        public OFGroupStatsEntry.Builder setDurationSec(long durationSec) {
            this.durationSec = durationSec;
            this.durationSecSet = true;
            return this;
        }

        @Override
        public long getDurationNsec() {
            return this.durationNsec;
        }

        @Override
        public OFGroupStatsEntry.Builder setDurationNsec(long durationNsec) {
            this.durationNsec = durationNsec;
            this.durationNsecSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFGroupStatsEntry build() {
            List<OFBucketCounter> bucketStats;
            U64 byteCount;
            U64 packetCount;
            OFGroup group;
            OFGroup oFGroup = group = this.groupSet ? this.group : DEFAULT_GROUP_ID;
            if (group == null) {
                throw new NullPointerException("Property group must not be null");
            }
            long refCount = this.refCountSet ? this.refCount : 0L;
            U64 u64 = packetCount = this.packetCountSet ? this.packetCount : DEFAULT_PACKET_COUNT;
            if (packetCount == null) {
                throw new NullPointerException("Property packetCount must not be null");
            }
            U64 u642 = byteCount = this.byteCountSet ? this.byteCount : DEFAULT_BYTE_COUNT;
            if (byteCount == null) {
                throw new NullPointerException("Property byteCount must not be null");
            }
            long durationSec = this.durationSecSet ? this.durationSec : 0L;
            long durationNsec = this.durationNsecSet ? this.durationNsec : 0L;
            List<OFBucketCounter> list = bucketStats = this.bucketStatsSet ? this.bucketStats : DEFAULT_BUCKET_STATS;
            if (bucketStats == null) {
                throw new NullPointerException("Property bucketStats must not be null");
            }
            return new OFGroupStatsEntryVer13(group, refCount, packetCount, byteCount, durationSec, durationNsec, bucketStats);
        }
    }

    static class BuilderWithParent
    implements OFGroupStatsEntry.Builder {
        final OFGroupStatsEntryVer13 parentMessage;
        private boolean groupSet;
        private OFGroup group;
        private boolean refCountSet;
        private long refCount;
        private boolean packetCountSet;
        private U64 packetCount;
        private boolean byteCountSet;
        private U64 byteCount;
        private boolean durationSecSet;
        private long durationSec;
        private boolean durationNsecSet;
        private long durationNsec;
        private boolean bucketStatsSet;
        private List<OFBucketCounter> bucketStats;

        BuilderWithParent(OFGroupStatsEntryVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFGroup getGroup() {
            return this.group;
        }

        @Override
        public OFGroupStatsEntry.Builder setGroup(OFGroup group) {
            this.group = group;
            this.groupSet = true;
            return this;
        }

        @Override
        public long getRefCount() {
            return this.refCount;
        }

        @Override
        public OFGroupStatsEntry.Builder setRefCount(long refCount) {
            this.refCount = refCount;
            this.refCountSet = true;
            return this;
        }

        @Override
        public U64 getPacketCount() {
            return this.packetCount;
        }

        @Override
        public OFGroupStatsEntry.Builder setPacketCount(U64 packetCount) {
            this.packetCount = packetCount;
            this.packetCountSet = true;
            return this;
        }

        @Override
        public U64 getByteCount() {
            return this.byteCount;
        }

        @Override
        public OFGroupStatsEntry.Builder setByteCount(U64 byteCount) {
            this.byteCount = byteCount;
            this.byteCountSet = true;
            return this;
        }

        @Override
        public List<OFBucketCounter> getBucketStats() {
            return this.bucketStats;
        }

        @Override
        public OFGroupStatsEntry.Builder setBucketStats(List<OFBucketCounter> bucketStats) {
            this.bucketStats = bucketStats;
            this.bucketStatsSet = true;
            return this;
        }

        @Override
        public long getDurationSec() {
            return this.durationSec;
        }

        @Override
        public OFGroupStatsEntry.Builder setDurationSec(long durationSec) {
            this.durationSec = durationSec;
            this.durationSecSet = true;
            return this;
        }

        @Override
        public long getDurationNsec() {
            return this.durationNsec;
        }

        @Override
        public OFGroupStatsEntry.Builder setDurationNsec(long durationNsec) {
            this.durationNsec = durationNsec;
            this.durationNsecSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFGroupStatsEntry build() {
            List bucketStats;
            U64 byteCount;
            U64 packetCount;
            OFGroup group;
            OFGroup oFGroup = group = this.groupSet ? this.group : this.parentMessage.group;
            if (group == null) {
                throw new NullPointerException("Property group must not be null");
            }
            long refCount = this.refCountSet ? this.refCount : this.parentMessage.refCount;
            U64 u64 = packetCount = this.packetCountSet ? this.packetCount : this.parentMessage.packetCount;
            if (packetCount == null) {
                throw new NullPointerException("Property packetCount must not be null");
            }
            U64 u642 = byteCount = this.byteCountSet ? this.byteCount : this.parentMessage.byteCount;
            if (byteCount == null) {
                throw new NullPointerException("Property byteCount must not be null");
            }
            long durationSec = this.durationSecSet ? this.durationSec : this.parentMessage.durationSec;
            long durationNsec = this.durationNsecSet ? this.durationNsec : this.parentMessage.durationNsec;
            List list = bucketStats = this.bucketStatsSet ? this.bucketStats : this.parentMessage.bucketStats;
            if (bucketStats == null) {
                throw new NullPointerException("Property bucketStats must not be null");
            }
            return new OFGroupStatsEntryVer13(group, refCount, packetCount, byteCount, durationSec, durationNsec, bucketStats);
        }
    }
}

