/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFInstructionType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.instruction.OFInstructionGotoTable;
import org.projectfloodlight.openflow.types.TableId;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFInstructionGotoTableVer13
implements OFInstructionGotoTable {
    private static final Logger logger = LoggerFactory.getLogger(OFInstructionGotoTableVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 8;
    private static final TableId DEFAULT_TABLE_ID = TableId.ALL;
    private final TableId tableId;
    static final OFInstructionGotoTableVer13 DEFAULT = new OFInstructionGotoTableVer13(DEFAULT_TABLE_ID);
    static final Reader READER = new Reader();
    static final OFInstructionGotoTableVer13Funnel FUNNEL = new OFInstructionGotoTableVer13Funnel();
    static final Writer WRITER = new Writer();

    OFInstructionGotoTableVer13(TableId tableId) {
        this.tableId = tableId;
    }

    @Override
    public OFInstructionType getType() {
        return OFInstructionType.GOTO_TABLE;
    }

    @Override
    public TableId getTableId() {
        return this.tableId;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFInstructionGotoTable.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFInstructionGotoTableVer13(");
        b.append("tableId=").append(this.tableId);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFInstructionGotoTableVer13 other = (OFInstructionGotoTableVer13)obj;
        return !(this.tableId == null ? other.tableId != null : !this.tableId.equals(other.tableId));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.tableId == null ? 0 : this.tableId.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFInstructionGotoTableVer13> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFInstructionGotoTableVer13 message) {
            bb.writeShort(1);
            bb.writeShort(8);
            message.tableId.writeByte(bb);
            bb.writeZero(3);
        }
    }

    static class OFInstructionGotoTableVer13Funnel
    implements Funnel<OFInstructionGotoTableVer13> {
        private static final long serialVersionUID = 1L;

        OFInstructionGotoTableVer13Funnel() {
        }

        public void funnel(OFInstructionGotoTableVer13 message, PrimitiveSink sink) {
            sink.putShort((short)1);
            sink.putShort((short)8);
            message.tableId.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFInstructionGotoTable> {
        Reader() {
        }

        @Override
        public OFInstructionGotoTable readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 1) {
                throw new OFParseError("Wrong type: Expected=OFInstructionType.GOTO_TABLE(1), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            TableId tableId = TableId.readByte(bb);
            bb.skipBytes(3);
            OFInstructionGotoTableVer13 instructionGotoTableVer13 = new OFInstructionGotoTableVer13(tableId);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)instructionGotoTableVer13);
            }
            return instructionGotoTableVer13;
        }
    }

    static class Builder
    implements OFInstructionGotoTable.Builder {
        private boolean tableIdSet;
        private TableId tableId;

        Builder() {
        }

        @Override
        public OFInstructionType getType() {
            return OFInstructionType.GOTO_TABLE;
        }

        @Override
        public TableId getTableId() {
            return this.tableId;
        }

        @Override
        public OFInstructionGotoTable.Builder setTableId(TableId tableId) {
            this.tableId = tableId;
            this.tableIdSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFInstructionGotoTable build() {
            TableId tableId;
            TableId tableId2 = tableId = this.tableIdSet ? this.tableId : DEFAULT_TABLE_ID;
            if (tableId == null) {
                throw new NullPointerException("Property tableId must not be null");
            }
            return new OFInstructionGotoTableVer13(tableId);
        }
    }

    static class BuilderWithParent
    implements OFInstructionGotoTable.Builder {
        final OFInstructionGotoTableVer13 parentMessage;
        private boolean tableIdSet;
        private TableId tableId;

        BuilderWithParent(OFInstructionGotoTableVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFInstructionType getType() {
            return OFInstructionType.GOTO_TABLE;
        }

        @Override
        public TableId getTableId() {
            return this.tableId;
        }

        @Override
        public OFInstructionGotoTable.Builder setTableId(TableId tableId) {
            this.tableId = tableId;
            this.tableIdSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFInstructionGotoTable build() {
            TableId tableId;
            TableId tableId2 = tableId = this.tableIdSet ? this.tableId : this.parentMessage.tableId;
            if (tableId == null) {
                throw new NullPointerException("Property tableId must not be null");
            }
            return new OFInstructionGotoTableVer13(tableId);
        }
    }
}

