/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.collect.ImmutableList;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import java.util.List;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFInstructionType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.action.OFAction;
import org.projectfloodlight.openflow.protocol.instruction.OFInstructionWriteActions;
import org.projectfloodlight.openflow.protocol.ver13.OFActionVer13;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.projectfloodlight.openflow.util.FunnelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFInstructionWriteActionsVer13
implements OFInstructionWriteActions {
    private static final Logger logger = LoggerFactory.getLogger(OFInstructionWriteActionsVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int MINIMUM_LENGTH = 8;
    private static final List<OFAction> DEFAULT_ACTIONS = ImmutableList.of();
    private final List<OFAction> actions;
    static final OFInstructionWriteActionsVer13 DEFAULT = new OFInstructionWriteActionsVer13(DEFAULT_ACTIONS);
    static final Reader READER = new Reader();
    static final OFInstructionWriteActionsVer13Funnel FUNNEL = new OFInstructionWriteActionsVer13Funnel();
    static final Writer WRITER = new Writer();

    OFInstructionWriteActionsVer13(List<OFAction> actions) {
        this.actions = actions;
    }

    @Override
    public OFInstructionType getType() {
        return OFInstructionType.WRITE_ACTIONS;
    }

    @Override
    public List<OFAction> getActions() {
        return this.actions;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFInstructionWriteActions.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFInstructionWriteActionsVer13(");
        b.append("actions=").append(this.actions);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFInstructionWriteActionsVer13 other = (OFInstructionWriteActionsVer13)obj;
        return !(this.actions == null ? other.actions != null : !this.actions.equals(other.actions));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.actions == null ? 0 : this.actions.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFInstructionWriteActionsVer13> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFInstructionWriteActionsVer13 message) {
            int startIndex = bb.writerIndex();
            bb.writeShort(3);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            bb.writeZero(4);
            ChannelUtils.writeList(bb, message.actions);
            int length = bb.writerIndex() - startIndex;
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFInstructionWriteActionsVer13Funnel
    implements Funnel<OFInstructionWriteActionsVer13> {
        private static final long serialVersionUID = 1L;

        OFInstructionWriteActionsVer13Funnel() {
        }

        public void funnel(OFInstructionWriteActionsVer13 message, PrimitiveSink sink) {
            sink.putShort((short)3);
            FunnelUtils.putList(message.actions, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFInstructionWriteActions> {
        Reader() {
        }

        @Override
        public OFInstructionWriteActions readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 3) {
                throw new OFParseError("Wrong type: Expected=OFInstructionType.WRITE_ACTIONS(3), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 8) {
                throw new OFParseError("Wrong length: Expected to be >= 8, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            bb.skipBytes(4);
            List<OFAction> actions = ChannelUtils.readList(bb, length - (bb.readerIndex() - start), OFActionVer13.READER);
            OFInstructionWriteActionsVer13 instructionWriteActionsVer13 = new OFInstructionWriteActionsVer13(actions);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)instructionWriteActionsVer13);
            }
            return instructionWriteActionsVer13;
        }
    }

    static class Builder
    implements OFInstructionWriteActions.Builder {
        private boolean actionsSet;
        private List<OFAction> actions;

        Builder() {
        }

        @Override
        public OFInstructionType getType() {
            return OFInstructionType.WRITE_ACTIONS;
        }

        @Override
        public List<OFAction> getActions() {
            return this.actions;
        }

        @Override
        public OFInstructionWriteActions.Builder setActions(List<OFAction> actions) {
            this.actions = actions;
            this.actionsSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFInstructionWriteActions build() {
            List<OFAction> actions;
            List<OFAction> list = actions = this.actionsSet ? this.actions : DEFAULT_ACTIONS;
            if (actions == null) {
                throw new NullPointerException("Property actions must not be null");
            }
            return new OFInstructionWriteActionsVer13(actions);
        }
    }

    static class BuilderWithParent
    implements OFInstructionWriteActions.Builder {
        final OFInstructionWriteActionsVer13 parentMessage;
        private boolean actionsSet;
        private List<OFAction> actions;

        BuilderWithParent(OFInstructionWriteActionsVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFInstructionType getType() {
            return OFInstructionType.WRITE_ACTIONS;
        }

        @Override
        public List<OFAction> getActions() {
            return this.actions;
        }

        @Override
        public OFInstructionWriteActions.Builder setActions(List<OFAction> actions) {
            this.actions = actions;
            this.actionsSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFInstructionWriteActions build() {
            List actions;
            List list = actions = this.actionsSet ? this.actions : this.parentMessage.actions;
            if (actions == null) {
                throw new NullPointerException("Property actions must not be null");
            }
            return new OFInstructionWriteActionsVer13(actions);
        }
    }
}

