/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmBsnVrf;
import org.projectfloodlight.openflow.types.VRF;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmBsnVrfVer13
implements OFOxmBsnVrf {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmBsnVrfVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 8;
    private static final VRF DEFAULT_VALUE = VRF.ZERO;
    private final VRF value;
    static final OFOxmBsnVrfVer13 DEFAULT = new OFOxmBsnVrfVer13(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFOxmBsnVrfVer13Funnel FUNNEL = new OFOxmBsnVrfVer13Funnel();
    static final Writer WRITER = new Writer();

    OFOxmBsnVrfVer13(VRF value) {
        this.value = value;
    }

    @Override
    public long getTypeLen() {
        return 197636L;
    }

    @Override
    public VRF getValue() {
        return this.value;
    }

    @Override
    public MatchField<VRF> getMatchField() {
        return MatchField.BSN_VRF;
    }

    @Override
    public boolean isMasked() {
        return false;
    }

    @Override
    public OFOxm<VRF> getCanonical() {
        return this;
    }

    @Override
    public VRF getMask() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property mask not supported in version 1.3");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFOxmBsnVrf.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmBsnVrfVer13(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmBsnVrfVer13 other = (OFOxmBsnVrfVer13)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmBsnVrfVer13> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFOxmBsnVrfVer13 message) {
            bb.writeInt(197636);
            message.value.write4Bytes(bb);
        }
    }

    static class OFOxmBsnVrfVer13Funnel
    implements Funnel<OFOxmBsnVrfVer13> {
        private static final long serialVersionUID = 1L;

        OFOxmBsnVrfVer13Funnel() {
        }

        public void funnel(OFOxmBsnVrfVer13 message, PrimitiveSink sink) {
            sink.putInt(197636);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmBsnVrf> {
        Reader() {
        }

        @Override
        public OFOxmBsnVrf readFrom(ChannelBuffer bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != 197636) {
                throw new OFParseError("Wrong typeLen: Expected=0x30404L(0x30404L), got=" + typeLen);
            }
            VRF value = VRF.read4Bytes(bb);
            OFOxmBsnVrfVer13 oxmBsnVrfVer13 = new OFOxmBsnVrfVer13(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmBsnVrfVer13);
            }
            return oxmBsnVrfVer13;
        }
    }

    static class Builder
    implements OFOxmBsnVrf.Builder {
        private boolean valueSet;
        private VRF value;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 197636L;
        }

        @Override
        public VRF getValue() {
            return this.value;
        }

        @Override
        public OFOxmBsnVrf.Builder setValue(VRF value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<VRF> getMatchField() {
            return MatchField.BSN_VRF;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<VRF> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.3");
        }

        @Override
        public VRF getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.3");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFOxmBsnVrf build() {
            VRF value;
            VRF vRF = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmBsnVrfVer13(value);
        }
    }

    static class BuilderWithParent
    implements OFOxmBsnVrf.Builder {
        final OFOxmBsnVrfVer13 parentMessage;
        private boolean valueSet;
        private VRF value;

        BuilderWithParent(OFOxmBsnVrfVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 197636L;
        }

        @Override
        public VRF getValue() {
            return this.value;
        }

        @Override
        public OFOxmBsnVrf.Builder setValue(VRF value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<VRF> getMatchField() {
            return MatchField.BSN_VRF;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<VRF> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.3");
        }

        @Override
        public VRF getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.3");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFOxmBsnVrf build() {
            VRF value;
            VRF vRF = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmBsnVrfVer13(value);
        }
    }
}

