/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmEthSrc;
import org.projectfloodlight.openflow.types.MacAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmEthSrcVer13
implements OFOxmEthSrc {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmEthSrcVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 10;
    private static final MacAddress DEFAULT_VALUE = MacAddress.NONE;
    private final MacAddress value;
    static final OFOxmEthSrcVer13 DEFAULT = new OFOxmEthSrcVer13(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFOxmEthSrcVer13Funnel FUNNEL = new OFOxmEthSrcVer13Funnel();
    static final Writer WRITER = new Writer();

    OFOxmEthSrcVer13(MacAddress value) {
        this.value = value;
    }

    @Override
    public long getTypeLen() {
        return 0x80000806L;
    }

    @Override
    public MacAddress getValue() {
        return this.value;
    }

    @Override
    public MatchField<MacAddress> getMatchField() {
        return MatchField.ETH_SRC;
    }

    @Override
    public boolean isMasked() {
        return false;
    }

    @Override
    public OFOxm<MacAddress> getCanonical() {
        return this;
    }

    @Override
    public MacAddress getMask() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property mask not supported in version 1.3");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFOxmEthSrc.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmEthSrcVer13(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmEthSrcVer13 other = (OFOxmEthSrcVer13)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmEthSrcVer13> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFOxmEthSrcVer13 message) {
            bb.writeInt(-2147481594);
            message.value.write6Bytes(bb);
        }
    }

    static class OFOxmEthSrcVer13Funnel
    implements Funnel<OFOxmEthSrcVer13> {
        private static final long serialVersionUID = 1L;

        OFOxmEthSrcVer13Funnel() {
        }

        public void funnel(OFOxmEthSrcVer13 message, PrimitiveSink sink) {
            sink.putInt(-2147481594);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmEthSrc> {
        Reader() {
        }

        @Override
        public OFOxmEthSrc readFrom(ChannelBuffer bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != -2147481594) {
                throw new OFParseError("Wrong typeLen: Expected=0x80000806L(0x80000806L), got=" + typeLen);
            }
            MacAddress value = MacAddress.read6Bytes(bb);
            OFOxmEthSrcVer13 oxmEthSrcVer13 = new OFOxmEthSrcVer13(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmEthSrcVer13);
            }
            return oxmEthSrcVer13;
        }
    }

    static class Builder
    implements OFOxmEthSrc.Builder {
        private boolean valueSet;
        private MacAddress value;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 0x80000806L;
        }

        @Override
        public MacAddress getValue() {
            return this.value;
        }

        @Override
        public OFOxmEthSrc.Builder setValue(MacAddress value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<MacAddress> getMatchField() {
            return MatchField.ETH_SRC;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<MacAddress> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.3");
        }

        @Override
        public MacAddress getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.3");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFOxmEthSrc build() {
            MacAddress value;
            MacAddress macAddress = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmEthSrcVer13(value);
        }
    }

    static class BuilderWithParent
    implements OFOxmEthSrc.Builder {
        final OFOxmEthSrcVer13 parentMessage;
        private boolean valueSet;
        private MacAddress value;

        BuilderWithParent(OFOxmEthSrcVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 0x80000806L;
        }

        @Override
        public MacAddress getValue() {
            return this.value;
        }

        @Override
        public OFOxmEthSrc.Builder setValue(MacAddress value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<MacAddress> getMatchField() {
            return MatchField.ETH_SRC;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<MacAddress> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.3");
        }

        @Override
        public MacAddress getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.3");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFOxmEthSrc build() {
            MacAddress value;
            MacAddress macAddress = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmEthSrcVer13(value);
        }
    }
}

