/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmIcmpv4TypeMasked;
import org.projectfloodlight.openflow.protocol.ver13.OFOxmIcmpv4TypeVer13;
import org.projectfloodlight.openflow.types.ICMPv4Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmIcmpv4TypeMaskedVer13
implements OFOxmIcmpv4TypeMasked {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmIcmpv4TypeMaskedVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 6;
    private static final ICMPv4Type DEFAULT_VALUE = ICMPv4Type.NONE;
    private static final ICMPv4Type DEFAULT_VALUE_MASK = ICMPv4Type.NONE;
    private final ICMPv4Type value;
    private final ICMPv4Type mask;
    static final OFOxmIcmpv4TypeMaskedVer13 DEFAULT = new OFOxmIcmpv4TypeMaskedVer13(DEFAULT_VALUE, DEFAULT_VALUE_MASK);
    static final Reader READER = new Reader();
    static final OFOxmIcmpv4TypeMaskedVer13Funnel FUNNEL = new OFOxmIcmpv4TypeMaskedVer13Funnel();
    static final Writer WRITER = new Writer();

    OFOxmIcmpv4TypeMaskedVer13(ICMPv4Type value, ICMPv4Type mask) {
        this.value = value;
        this.mask = mask;
    }

    @Override
    public long getTypeLen() {
        return 2147493634L;
    }

    @Override
    public ICMPv4Type getValue() {
        return this.value;
    }

    @Override
    public ICMPv4Type getMask() {
        return this.mask;
    }

    @Override
    public MatchField<ICMPv4Type> getMatchField() {
        return MatchField.ICMPV4_TYPE;
    }

    @Override
    public boolean isMasked() {
        return true;
    }

    @Override
    public OFOxm<ICMPv4Type> getCanonical() {
        if (ICMPv4Type.NO_MASK.equals(this.mask)) {
            return new OFOxmIcmpv4TypeVer13(this.value);
        }
        if (ICMPv4Type.FULL_MASK.equals(this.mask)) {
            return null;
        }
        return this;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFOxmIcmpv4TypeMasked.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmIcmpv4TypeMaskedVer13(");
        b.append("value=").append(this.value);
        b.append(", ");
        b.append("mask=").append(this.mask);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmIcmpv4TypeMaskedVer13 other = (OFOxmIcmpv4TypeMaskedVer13)obj;
        if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
            return false;
        }
        return !(this.mask == null ? other.mask != null : !this.mask.equals(other.mask));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        result = 31 * result + (this.mask == null ? 0 : this.mask.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmIcmpv4TypeMaskedVer13> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFOxmIcmpv4TypeMaskedVer13 message) {
            bb.writeInt(-2147473662);
            message.value.writeByte(bb);
            message.mask.writeByte(bb);
        }
    }

    static class OFOxmIcmpv4TypeMaskedVer13Funnel
    implements Funnel<OFOxmIcmpv4TypeMaskedVer13> {
        private static final long serialVersionUID = 1L;

        OFOxmIcmpv4TypeMaskedVer13Funnel() {
        }

        public void funnel(OFOxmIcmpv4TypeMaskedVer13 message, PrimitiveSink sink) {
            sink.putInt(-2147473662);
            message.value.putTo(sink);
            message.mask.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmIcmpv4TypeMasked> {
        Reader() {
        }

        @Override
        public OFOxmIcmpv4TypeMasked readFrom(ChannelBuffer bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != -2147473662) {
                throw new OFParseError("Wrong typeLen: Expected=0x80002702L(0x80002702L), got=" + typeLen);
            }
            ICMPv4Type value = ICMPv4Type.readByte(bb);
            ICMPv4Type mask = ICMPv4Type.readByte(bb);
            OFOxmIcmpv4TypeMaskedVer13 oxmIcmpv4TypeMaskedVer13 = new OFOxmIcmpv4TypeMaskedVer13(value, mask);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmIcmpv4TypeMaskedVer13);
            }
            return oxmIcmpv4TypeMaskedVer13;
        }
    }

    static class Builder
    implements OFOxmIcmpv4TypeMasked.Builder {
        private boolean valueSet;
        private ICMPv4Type value;
        private boolean maskSet;
        private ICMPv4Type mask;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 2147493634L;
        }

        @Override
        public ICMPv4Type getValue() {
            return this.value;
        }

        @Override
        public OFOxmIcmpv4TypeMasked.Builder setValue(ICMPv4Type value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public ICMPv4Type getMask() {
            return this.mask;
        }

        @Override
        public OFOxmIcmpv4TypeMasked.Builder setMask(ICMPv4Type mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public MatchField<ICMPv4Type> getMatchField() {
            return MatchField.ICMPV4_TYPE;
        }

        @Override
        public boolean isMasked() {
            return true;
        }

        @Override
        public OFOxm<ICMPv4Type> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.3");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFOxmIcmpv4TypeMasked build() {
            ICMPv4Type mask;
            ICMPv4Type value;
            ICMPv4Type iCMPv4Type = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            ICMPv4Type iCMPv4Type2 = mask = this.maskSet ? this.mask : DEFAULT_VALUE_MASK;
            if (mask == null) {
                throw new NullPointerException("Property mask must not be null");
            }
            return new OFOxmIcmpv4TypeMaskedVer13(value, mask);
        }
    }

    static class BuilderWithParent
    implements OFOxmIcmpv4TypeMasked.Builder {
        final OFOxmIcmpv4TypeMaskedVer13 parentMessage;
        private boolean valueSet;
        private ICMPv4Type value;
        private boolean maskSet;
        private ICMPv4Type mask;

        BuilderWithParent(OFOxmIcmpv4TypeMaskedVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 2147493634L;
        }

        @Override
        public ICMPv4Type getValue() {
            return this.value;
        }

        @Override
        public OFOxmIcmpv4TypeMasked.Builder setValue(ICMPv4Type value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public ICMPv4Type getMask() {
            return this.mask;
        }

        @Override
        public OFOxmIcmpv4TypeMasked.Builder setMask(ICMPv4Type mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public MatchField<ICMPv4Type> getMatchField() {
            return MatchField.ICMPV4_TYPE;
        }

        @Override
        public boolean isMasked() {
            return true;
        }

        @Override
        public OFOxm<ICMPv4Type> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.3");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFOxmIcmpv4TypeMasked build() {
            ICMPv4Type mask;
            ICMPv4Type value;
            ICMPv4Type iCMPv4Type = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            ICMPv4Type iCMPv4Type2 = mask = this.maskSet ? this.mask : this.parentMessage.mask;
            if (mask == null) {
                throw new NullPointerException("Property mask must not be null");
            }
            return new OFOxmIcmpv4TypeMaskedVer13(value, mask);
        }
    }
}

