/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmOchSigtype;
import org.projectfloodlight.openflow.types.U8;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmOchSigtypeVer13
implements OFOxmOchSigtype {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmOchSigtypeVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 5;
    private static final U8 DEFAULT_VALUE = U8.ZERO;
    private final U8 value;
    static final OFOxmOchSigtypeVer13 DEFAULT = new OFOxmOchSigtypeVer13(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFOxmOchSigtypeVer13Funnel FUNNEL = new OFOxmOchSigtypeVer13Funnel();
    static final Writer WRITER = new Writer();

    OFOxmOchSigtypeVer13(U8 value) {
        this.value = value;
    }

    @Override
    public long getTypeLen() {
        return 546817L;
    }

    @Override
    public U8 getValue() {
        return this.value;
    }

    @Override
    public MatchField<U8> getMatchField() {
        return MatchField.OCH_SIGTYPE;
    }

    @Override
    public boolean isMasked() {
        return false;
    }

    @Override
    public OFOxm<U8> getCanonical() {
        return this;
    }

    @Override
    public U8 getMask() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property mask not supported in version 1.3");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFOxmOchSigtype.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmOchSigtypeVer13(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmOchSigtypeVer13 other = (OFOxmOchSigtypeVer13)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmOchSigtypeVer13> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFOxmOchSigtypeVer13 message) {
            bb.writeInt(546817);
            bb.writeByte((int)message.value.getRaw());
        }
    }

    static class OFOxmOchSigtypeVer13Funnel
    implements Funnel<OFOxmOchSigtypeVer13> {
        private static final long serialVersionUID = 1L;

        OFOxmOchSigtypeVer13Funnel() {
        }

        public void funnel(OFOxmOchSigtypeVer13 message, PrimitiveSink sink) {
            sink.putInt(546817);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmOchSigtype> {
        Reader() {
        }

        @Override
        public OFOxmOchSigtype readFrom(ChannelBuffer bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != 546817) {
                throw new OFParseError("Wrong typeLen: Expected=0x85801L(0x85801L), got=" + typeLen);
            }
            U8 value = U8.of(bb.readByte());
            OFOxmOchSigtypeVer13 oxmOchSigtypeVer13 = new OFOxmOchSigtypeVer13(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmOchSigtypeVer13);
            }
            return oxmOchSigtypeVer13;
        }
    }

    static class Builder
    implements OFOxmOchSigtype.Builder {
        private boolean valueSet;
        private U8 value;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 546817L;
        }

        @Override
        public U8 getValue() {
            return this.value;
        }

        @Override
        public OFOxmOchSigtype.Builder setValue(U8 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<U8> getMatchField() {
            return MatchField.OCH_SIGTYPE;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<U8> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.3");
        }

        @Override
        public U8 getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.3");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFOxmOchSigtype build() {
            U8 value;
            U8 u8 = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmOchSigtypeVer13(value);
        }
    }

    static class BuilderWithParent
    implements OFOxmOchSigtype.Builder {
        final OFOxmOchSigtypeVer13 parentMessage;
        private boolean valueSet;
        private U8 value;

        BuilderWithParent(OFOxmOchSigtypeVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 546817L;
        }

        @Override
        public U8 getValue() {
            return this.value;
        }

        @Override
        public OFOxmOchSigtype.Builder setValue(U8 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<U8> getMatchField() {
            return MatchField.OCH_SIGTYPE;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<U8> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.3");
        }

        @Override
        public U8 getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.3");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFOxmOchSigtype build() {
            U8 value;
            U8 u8 = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmOchSigtypeVer13(value);
        }
    }
}

