/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmTcpDstMasked;
import org.projectfloodlight.openflow.protocol.ver13.OFOxmTcpDstVer13;
import org.projectfloodlight.openflow.types.TransportPort;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmTcpDstMaskedVer13
implements OFOxmTcpDstMasked {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmTcpDstMaskedVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 8;
    private static final TransportPort DEFAULT_VALUE = TransportPort.NONE;
    private static final TransportPort DEFAULT_VALUE_MASK = TransportPort.NONE;
    private final TransportPort value;
    private final TransportPort mask;
    static final OFOxmTcpDstMaskedVer13 DEFAULT = new OFOxmTcpDstMaskedVer13(DEFAULT_VALUE, DEFAULT_VALUE_MASK);
    static final Reader READER = new Reader();
    static final OFOxmTcpDstMaskedVer13Funnel FUNNEL = new OFOxmTcpDstMaskedVer13Funnel();
    static final Writer WRITER = new Writer();

    OFOxmTcpDstMaskedVer13(TransportPort value, TransportPort mask) {
        this.value = value;
        this.mask = mask;
    }

    @Override
    public long getTypeLen() {
        return 2147491076L;
    }

    @Override
    public TransportPort getValue() {
        return this.value;
    }

    @Override
    public TransportPort getMask() {
        return this.mask;
    }

    @Override
    public MatchField<TransportPort> getMatchField() {
        return MatchField.TCP_DST;
    }

    @Override
    public boolean isMasked() {
        return true;
    }

    @Override
    public OFOxm<TransportPort> getCanonical() {
        if (TransportPort.NO_MASK.equals(this.mask)) {
            return new OFOxmTcpDstVer13(this.value);
        }
        if (TransportPort.FULL_MASK.equals(this.mask)) {
            return null;
        }
        return this;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFOxmTcpDstMasked.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmTcpDstMaskedVer13(");
        b.append("value=").append(this.value);
        b.append(", ");
        b.append("mask=").append(this.mask);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmTcpDstMaskedVer13 other = (OFOxmTcpDstMaskedVer13)obj;
        if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
            return false;
        }
        return !(this.mask == null ? other.mask != null : !this.mask.equals(other.mask));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        result = 31 * result + (this.mask == null ? 0 : this.mask.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmTcpDstMaskedVer13> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFOxmTcpDstMaskedVer13 message) {
            bb.writeInt(-2147476220);
            message.value.write2Bytes(bb);
            message.mask.write2Bytes(bb);
        }
    }

    static class OFOxmTcpDstMaskedVer13Funnel
    implements Funnel<OFOxmTcpDstMaskedVer13> {
        private static final long serialVersionUID = 1L;

        OFOxmTcpDstMaskedVer13Funnel() {
        }

        public void funnel(OFOxmTcpDstMaskedVer13 message, PrimitiveSink sink) {
            sink.putInt(-2147476220);
            message.value.putTo(sink);
            message.mask.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmTcpDstMasked> {
        Reader() {
        }

        @Override
        public OFOxmTcpDstMasked readFrom(ChannelBuffer bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != -2147476220) {
                throw new OFParseError("Wrong typeLen: Expected=0x80001d04L(0x80001d04L), got=" + typeLen);
            }
            TransportPort value = TransportPort.read2Bytes(bb);
            TransportPort mask = TransportPort.read2Bytes(bb);
            OFOxmTcpDstMaskedVer13 oxmTcpDstMaskedVer13 = new OFOxmTcpDstMaskedVer13(value, mask);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmTcpDstMaskedVer13);
            }
            return oxmTcpDstMaskedVer13;
        }
    }

    static class Builder
    implements OFOxmTcpDstMasked.Builder {
        private boolean valueSet;
        private TransportPort value;
        private boolean maskSet;
        private TransportPort mask;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 2147491076L;
        }

        @Override
        public TransportPort getValue() {
            return this.value;
        }

        @Override
        public OFOxmTcpDstMasked.Builder setValue(TransportPort value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public TransportPort getMask() {
            return this.mask;
        }

        @Override
        public OFOxmTcpDstMasked.Builder setMask(TransportPort mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public MatchField<TransportPort> getMatchField() {
            return MatchField.TCP_DST;
        }

        @Override
        public boolean isMasked() {
            return true;
        }

        @Override
        public OFOxm<TransportPort> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.3");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFOxmTcpDstMasked build() {
            TransportPort mask;
            TransportPort value;
            TransportPort transportPort = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            TransportPort transportPort2 = mask = this.maskSet ? this.mask : DEFAULT_VALUE_MASK;
            if (mask == null) {
                throw new NullPointerException("Property mask must not be null");
            }
            return new OFOxmTcpDstMaskedVer13(value, mask);
        }
    }

    static class BuilderWithParent
    implements OFOxmTcpDstMasked.Builder {
        final OFOxmTcpDstMaskedVer13 parentMessage;
        private boolean valueSet;
        private TransportPort value;
        private boolean maskSet;
        private TransportPort mask;

        BuilderWithParent(OFOxmTcpDstMaskedVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 2147491076L;
        }

        @Override
        public TransportPort getValue() {
            return this.value;
        }

        @Override
        public OFOxmTcpDstMasked.Builder setValue(TransportPort value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public TransportPort getMask() {
            return this.mask;
        }

        @Override
        public OFOxmTcpDstMasked.Builder setMask(TransportPort mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public MatchField<TransportPort> getMatchField() {
            return MatchField.TCP_DST;
        }

        @Override
        public boolean isMasked() {
            return true;
        }

        @Override
        public OFOxm<TransportPort> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.3");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFOxmTcpDstMasked build() {
            TransportPort mask;
            TransportPort value;
            TransportPort transportPort = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            TransportPort transportPort2 = mask = this.maskSet ? this.mask : this.parentMessage.mask;
            if (mask == null) {
                throw new NullPointerException("Property mask must not be null");
            }
            return new OFOxmTcpDstMaskedVer13(value, mask);
        }
    }
}

