/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmTunnelId;
import org.projectfloodlight.openflow.types.U64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmTunnelIdVer13
implements OFOxmTunnelId {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmTunnelIdVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 12;
    private static final U64 DEFAULT_VALUE = U64.ZERO;
    private final U64 value;
    static final OFOxmTunnelIdVer13 DEFAULT = new OFOxmTunnelIdVer13(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFOxmTunnelIdVer13Funnel FUNNEL = new OFOxmTunnelIdVer13Funnel();
    static final Writer WRITER = new Writer();

    OFOxmTunnelIdVer13(U64 value) {
        this.value = value;
    }

    @Override
    public long getTypeLen() {
        return 2147503112L;
    }

    @Override
    public U64 getValue() {
        return this.value;
    }

    @Override
    public MatchField<U64> getMatchField() {
        return MatchField.TUNNEL_ID;
    }

    @Override
    public boolean isMasked() {
        return false;
    }

    @Override
    public OFOxm<U64> getCanonical() {
        return this;
    }

    @Override
    public U64 getMask() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property mask not supported in version 1.3");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFOxmTunnelId.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmTunnelIdVer13(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmTunnelIdVer13 other = (OFOxmTunnelIdVer13)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmTunnelIdVer13> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFOxmTunnelIdVer13 message) {
            bb.writeInt(-2147464184);
            bb.writeLong(message.value.getValue());
        }
    }

    static class OFOxmTunnelIdVer13Funnel
    implements Funnel<OFOxmTunnelIdVer13> {
        private static final long serialVersionUID = 1L;

        OFOxmTunnelIdVer13Funnel() {
        }

        public void funnel(OFOxmTunnelIdVer13 message, PrimitiveSink sink) {
            sink.putInt(-2147464184);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmTunnelId> {
        Reader() {
        }

        @Override
        public OFOxmTunnelId readFrom(ChannelBuffer bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != -2147464184) {
                throw new OFParseError("Wrong typeLen: Expected=0x80004c08L(0x80004c08L), got=" + typeLen);
            }
            U64 value = U64.ofRaw(bb.readLong());
            OFOxmTunnelIdVer13 oxmTunnelIdVer13 = new OFOxmTunnelIdVer13(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmTunnelIdVer13);
            }
            return oxmTunnelIdVer13;
        }
    }

    static class Builder
    implements OFOxmTunnelId.Builder {
        private boolean valueSet;
        private U64 value;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 2147503112L;
        }

        @Override
        public U64 getValue() {
            return this.value;
        }

        @Override
        public OFOxmTunnelId.Builder setValue(U64 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<U64> getMatchField() {
            return MatchField.TUNNEL_ID;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<U64> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.3");
        }

        @Override
        public U64 getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.3");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFOxmTunnelId build() {
            U64 value;
            U64 u64 = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmTunnelIdVer13(value);
        }
    }

    static class BuilderWithParent
    implements OFOxmTunnelId.Builder {
        final OFOxmTunnelIdVer13 parentMessage;
        private boolean valueSet;
        private U64 value;

        BuilderWithParent(OFOxmTunnelIdVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 2147503112L;
        }

        @Override
        public U64 getValue() {
            return this.value;
        }

        @Override
        public OFOxmTunnelId.Builder setValue(U64 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<U64> getMatchField() {
            return MatchField.TUNNEL_ID;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<U64> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.3");
        }

        @Override
        public U64 getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.3");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFOxmTunnelId build() {
            U64 value;
            U64 u64 = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmTunnelIdVer13(value);
        }
    }
}

