/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmUdpDst;
import org.projectfloodlight.openflow.types.TransportPort;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmUdpDstVer13
implements OFOxmUdpDst {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmUdpDstVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 6;
    private static final TransportPort DEFAULT_VALUE = TransportPort.NONE;
    private final TransportPort value;
    static final OFOxmUdpDstVer13 DEFAULT = new OFOxmUdpDstVer13(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFOxmUdpDstVer13Funnel FUNNEL = new OFOxmUdpDstVer13Funnel();
    static final Writer WRITER = new Writer();

    OFOxmUdpDstVer13(TransportPort value) {
        this.value = value;
    }

    @Override
    public long getTypeLen() {
        return 0x80002002L;
    }

    @Override
    public TransportPort getValue() {
        return this.value;
    }

    @Override
    public MatchField<TransportPort> getMatchField() {
        return MatchField.UDP_DST;
    }

    @Override
    public boolean isMasked() {
        return false;
    }

    @Override
    public OFOxm<TransportPort> getCanonical() {
        return this;
    }

    @Override
    public TransportPort getMask() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property mask not supported in version 1.3");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFOxmUdpDst.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmUdpDstVer13(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmUdpDstVer13 other = (OFOxmUdpDstVer13)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmUdpDstVer13> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFOxmUdpDstVer13 message) {
            bb.writeInt(-2147475454);
            message.value.write2Bytes(bb);
        }
    }

    static class OFOxmUdpDstVer13Funnel
    implements Funnel<OFOxmUdpDstVer13> {
        private static final long serialVersionUID = 1L;

        OFOxmUdpDstVer13Funnel() {
        }

        public void funnel(OFOxmUdpDstVer13 message, PrimitiveSink sink) {
            sink.putInt(-2147475454);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmUdpDst> {
        Reader() {
        }

        @Override
        public OFOxmUdpDst readFrom(ChannelBuffer bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != -2147475454) {
                throw new OFParseError("Wrong typeLen: Expected=0x80002002L(0x80002002L), got=" + typeLen);
            }
            TransportPort value = TransportPort.read2Bytes(bb);
            OFOxmUdpDstVer13 oxmUdpDstVer13 = new OFOxmUdpDstVer13(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmUdpDstVer13);
            }
            return oxmUdpDstVer13;
        }
    }

    static class Builder
    implements OFOxmUdpDst.Builder {
        private boolean valueSet;
        private TransportPort value;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 0x80002002L;
        }

        @Override
        public TransportPort getValue() {
            return this.value;
        }

        @Override
        public OFOxmUdpDst.Builder setValue(TransportPort value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<TransportPort> getMatchField() {
            return MatchField.UDP_DST;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<TransportPort> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.3");
        }

        @Override
        public TransportPort getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.3");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFOxmUdpDst build() {
            TransportPort value;
            TransportPort transportPort = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmUdpDstVer13(value);
        }
    }

    static class BuilderWithParent
    implements OFOxmUdpDst.Builder {
        final OFOxmUdpDstVer13 parentMessage;
        private boolean valueSet;
        private TransportPort value;

        BuilderWithParent(OFOxmUdpDstVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 0x80002002L;
        }

        @Override
        public TransportPort getValue() {
            return this.value;
        }

        @Override
        public OFOxmUdpDst.Builder setValue(TransportPort value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<TransportPort> getMatchField() {
            return MatchField.UDP_DST;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<TransportPort> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.3");
        }

        @Override
        public TransportPort getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.3");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFOxmUdpDst build() {
            TransportPort value;
            TransportPort transportPort = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmUdpDstVer13(value);
        }
    }
}

