/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.PrimitiveSink;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFPortFeatures;

public class OFPortFeaturesSerializerVer13 {
    public static final int PF_10MB_HD_VAL = 1;
    public static final int PF_10MB_FD_VAL = 2;
    public static final int PF_100MB_HD_VAL = 4;
    public static final int PF_100MB_FD_VAL = 8;
    public static final int PF_1GB_HD_VAL = 16;
    public static final int PF_1GB_FD_VAL = 32;
    public static final int PF_10GB_FD_VAL = 64;
    public static final int PF_COPPER_VAL = 2048;
    public static final int PF_FIBER_VAL = 4096;
    public static final int PF_AUTONEG_VAL = 8192;
    public static final int PF_PAUSE_VAL = 16384;
    public static final int PF_PAUSE_ASYM_VAL = 32768;
    public static final int PF_40GB_FD_VAL = 128;
    public static final int PF_100GB_FD_VAL = 256;
    public static final int PF_1TB_FD_VAL = 512;
    public static final int PF_OTHER_VAL = 1024;

    public static Set<OFPortFeatures> readFrom(ChannelBuffer bb) throws OFParseError {
        try {
            return OFPortFeaturesSerializerVer13.ofWireValue(bb.readInt());
        }
        catch (IllegalArgumentException e) {
            throw new OFParseError(e);
        }
    }

    public static void writeTo(ChannelBuffer bb, Set<OFPortFeatures> set) {
        bb.writeInt(OFPortFeaturesSerializerVer13.toWireValue(set));
    }

    public static void putTo(Set<OFPortFeatures> set, PrimitiveSink sink) {
        sink.putInt(OFPortFeaturesSerializerVer13.toWireValue(set));
    }

    public static Set<OFPortFeatures> ofWireValue(int val) {
        EnumSet<OFPortFeatures> set = EnumSet.noneOf(OFPortFeatures.class);
        if ((val & 1) != 0) {
            set.add(OFPortFeatures.PF_10MB_HD);
        }
        if ((val & 2) != 0) {
            set.add(OFPortFeatures.PF_10MB_FD);
        }
        if ((val & 4) != 0) {
            set.add(OFPortFeatures.PF_100MB_HD);
        }
        if ((val & 8) != 0) {
            set.add(OFPortFeatures.PF_100MB_FD);
        }
        if ((val & 0x10) != 0) {
            set.add(OFPortFeatures.PF_1GB_HD);
        }
        if ((val & 0x20) != 0) {
            set.add(OFPortFeatures.PF_1GB_FD);
        }
        if ((val & 0x40) != 0) {
            set.add(OFPortFeatures.PF_10GB_FD);
        }
        if ((val & 0x800) != 0) {
            set.add(OFPortFeatures.PF_COPPER);
        }
        if ((val & 0x1000) != 0) {
            set.add(OFPortFeatures.PF_FIBER);
        }
        if ((val & 0x2000) != 0) {
            set.add(OFPortFeatures.PF_AUTONEG);
        }
        if ((val & 0x4000) != 0) {
            set.add(OFPortFeatures.PF_PAUSE);
        }
        if ((val & 0x8000) != 0) {
            set.add(OFPortFeatures.PF_PAUSE_ASYM);
        }
        if ((val & 0x80) != 0) {
            set.add(OFPortFeatures.PF_40GB_FD);
        }
        if ((val & 0x100) != 0) {
            set.add(OFPortFeatures.PF_100GB_FD);
        }
        if ((val & 0x200) != 0) {
            set.add(OFPortFeatures.PF_1TB_FD);
        }
        if ((val & 0x400) != 0) {
            set.add(OFPortFeatures.PF_OTHER);
        }
        return Collections.unmodifiableSet(set);
    }

    public static int toWireValue(Set<OFPortFeatures> set) {
        int wireValue = 0;
        block18: for (OFPortFeatures e : set) {
            switch (e) {
                case PF_10MB_HD: {
                    wireValue |= 1;
                    continue block18;
                }
                case PF_10MB_FD: {
                    wireValue |= 2;
                    continue block18;
                }
                case PF_100MB_HD: {
                    wireValue |= 4;
                    continue block18;
                }
                case PF_100MB_FD: {
                    wireValue |= 8;
                    continue block18;
                }
                case PF_1GB_HD: {
                    wireValue |= 0x10;
                    continue block18;
                }
                case PF_1GB_FD: {
                    wireValue |= 0x20;
                    continue block18;
                }
                case PF_10GB_FD: {
                    wireValue |= 0x40;
                    continue block18;
                }
                case PF_COPPER: {
                    wireValue |= 0x800;
                    continue block18;
                }
                case PF_FIBER: {
                    wireValue |= 0x1000;
                    continue block18;
                }
                case PF_AUTONEG: {
                    wireValue |= 0x2000;
                    continue block18;
                }
                case PF_PAUSE: {
                    wireValue |= 0x4000;
                    continue block18;
                }
                case PF_PAUSE_ASYM: {
                    wireValue |= 0x8000;
                    continue block18;
                }
                case PF_40GB_FD: {
                    wireValue |= 0x80;
                    continue block18;
                }
                case PF_100GB_FD: {
                    wireValue |= 0x100;
                    continue block18;
                }
                case PF_1TB_FD: {
                    wireValue |= 0x200;
                    continue block18;
                }
                case PF_OTHER: {
                    wireValue |= 0x400;
                    continue block18;
                }
            }
            throw new IllegalArgumentException("Illegal enum value for type OFPortFeatures in version 1.3: " + (Object)((Object)e));
        }
        return wireValue;
    }
}

