/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFPortOpticalTransportLayerEntry;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U8;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFPortOpticalTransportLayerEntryVer13
implements OFPortOpticalTransportLayerEntry {
    private static final Logger logger = LoggerFactory.getLogger(OFPortOpticalTransportLayerEntryVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 8;
    private static final short DEFAULT_LAYER_CLASS = 0;
    private static final short DEFAULT_SIGNAL_TYPE = 0;
    private static final short DEFAULT_ADAPTATION = 0;
    private final short layerClass;
    private final short signalType;
    private final short adaptation;
    static final OFPortOpticalTransportLayerEntryVer13 DEFAULT = new OFPortOpticalTransportLayerEntryVer13(0, 0, 0);
    static final Reader READER = new Reader();
    static final OFPortOpticalTransportLayerEntryVer13Funnel FUNNEL = new OFPortOpticalTransportLayerEntryVer13Funnel();
    static final Writer WRITER = new Writer();

    OFPortOpticalTransportLayerEntryVer13(short layerClass, short signalType, short adaptation) {
        this.layerClass = layerClass;
        this.signalType = signalType;
        this.adaptation = adaptation;
    }

    @Override
    public short getLayerClass() {
        return this.layerClass;
    }

    @Override
    public short getSignalType() {
        return this.signalType;
    }

    @Override
    public short getAdaptation() {
        return this.adaptation;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFPortOpticalTransportLayerEntry.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFPortOpticalTransportLayerEntryVer13(");
        b.append("layerClass=").append(this.layerClass);
        b.append(", ");
        b.append("signalType=").append(this.signalType);
        b.append(", ");
        b.append("adaptation=").append(this.adaptation);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFPortOpticalTransportLayerEntryVer13 other = (OFPortOpticalTransportLayerEntryVer13)obj;
        if (this.layerClass != other.layerClass) {
            return false;
        }
        if (this.signalType != other.signalType) {
            return false;
        }
        return this.adaptation == other.adaptation;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.layerClass;
        result = 31 * result + this.signalType;
        result = 31 * result + this.adaptation;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFPortOpticalTransportLayerEntryVer13> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFPortOpticalTransportLayerEntryVer13 message) {
            bb.writeByte((int)U8.t(message.layerClass));
            bb.writeByte((int)U8.t(message.signalType));
            bb.writeByte((int)U8.t(message.adaptation));
            bb.writeZero(5);
        }
    }

    static class OFPortOpticalTransportLayerEntryVer13Funnel
    implements Funnel<OFPortOpticalTransportLayerEntryVer13> {
        private static final long serialVersionUID = 1L;

        OFPortOpticalTransportLayerEntryVer13Funnel() {
        }

        public void funnel(OFPortOpticalTransportLayerEntryVer13 message, PrimitiveSink sink) {
            sink.putShort(message.layerClass);
            sink.putShort(message.signalType);
            sink.putShort(message.adaptation);
        }
    }

    static class Reader
    implements OFMessageReader<OFPortOpticalTransportLayerEntry> {
        Reader() {
        }

        @Override
        public OFPortOpticalTransportLayerEntry readFrom(ChannelBuffer bb) throws OFParseError {
            short layerClass = U8.f(bb.readByte());
            short signalType = U8.f(bb.readByte());
            short adaptation = U8.f(bb.readByte());
            bb.skipBytes(5);
            OFPortOpticalTransportLayerEntryVer13 portOpticalTransportLayerEntryVer13 = new OFPortOpticalTransportLayerEntryVer13(layerClass, signalType, adaptation);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)portOpticalTransportLayerEntryVer13);
            }
            return portOpticalTransportLayerEntryVer13;
        }
    }

    static class Builder
    implements OFPortOpticalTransportLayerEntry.Builder {
        private boolean layerClassSet;
        private short layerClass;
        private boolean signalTypeSet;
        private short signalType;
        private boolean adaptationSet;
        private short adaptation;

        Builder() {
        }

        @Override
        public short getLayerClass() {
            return this.layerClass;
        }

        @Override
        public OFPortOpticalTransportLayerEntry.Builder setLayerClass(short layerClass) {
            this.layerClass = layerClass;
            this.layerClassSet = true;
            return this;
        }

        @Override
        public short getSignalType() {
            return this.signalType;
        }

        @Override
        public OFPortOpticalTransportLayerEntry.Builder setSignalType(short signalType) {
            this.signalType = signalType;
            this.signalTypeSet = true;
            return this;
        }

        @Override
        public short getAdaptation() {
            return this.adaptation;
        }

        @Override
        public OFPortOpticalTransportLayerEntry.Builder setAdaptation(short adaptation) {
            this.adaptation = adaptation;
            this.adaptationSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFPortOpticalTransportLayerEntry build() {
            short layerClass = this.layerClassSet ? this.layerClass : (short)0;
            short signalType = this.signalTypeSet ? this.signalType : (short)0;
            short adaptation = this.adaptationSet ? this.adaptation : (short)0;
            return new OFPortOpticalTransportLayerEntryVer13(layerClass, signalType, adaptation);
        }
    }

    static class BuilderWithParent
    implements OFPortOpticalTransportLayerEntry.Builder {
        final OFPortOpticalTransportLayerEntryVer13 parentMessage;
        private boolean layerClassSet;
        private short layerClass;
        private boolean signalTypeSet;
        private short signalType;
        private boolean adaptationSet;
        private short adaptation;

        BuilderWithParent(OFPortOpticalTransportLayerEntryVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public short getLayerClass() {
            return this.layerClass;
        }

        @Override
        public OFPortOpticalTransportLayerEntry.Builder setLayerClass(short layerClass) {
            this.layerClass = layerClass;
            this.layerClassSet = true;
            return this;
        }

        @Override
        public short getSignalType() {
            return this.signalType;
        }

        @Override
        public OFPortOpticalTransportLayerEntry.Builder setSignalType(short signalType) {
            this.signalType = signalType;
            this.signalTypeSet = true;
            return this;
        }

        @Override
        public short getAdaptation() {
            return this.adaptation;
        }

        @Override
        public OFPortOpticalTransportLayerEntry.Builder setAdaptation(short adaptation) {
            this.adaptation = adaptation;
            this.adaptationSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFPortOpticalTransportLayerEntry build() {
            short layerClass = this.layerClassSet ? this.layerClass : this.parentMessage.layerClass;
            short signalType = this.signalTypeSet ? this.signalType : this.parentMessage.signalType;
            short adaptation = this.adaptationSet ? this.adaptation : this.parentMessage.adaptation;
            return new OFPortOpticalTransportLayerEntryVer13(layerClass, signalType, adaptation);
        }
    }
}

