/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.collect.ImmutableList;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import java.util.List;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFTableFeaturePropApplyActionsMiss;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.actionid.OFActionId;
import org.projectfloodlight.openflow.protocol.ver13.OFActionIdVer13;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.projectfloodlight.openflow.util.FunnelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFTableFeaturePropApplyActionsMissVer13
implements OFTableFeaturePropApplyActionsMiss {
    private static final Logger logger = LoggerFactory.getLogger(OFTableFeaturePropApplyActionsMissVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int MINIMUM_LENGTH = 4;
    private static final List<OFActionId> DEFAULT_ACTION_IDS = ImmutableList.of();
    private final List<OFActionId> actionIds;
    static final OFTableFeaturePropApplyActionsMissVer13 DEFAULT = new OFTableFeaturePropApplyActionsMissVer13(DEFAULT_ACTION_IDS);
    static final Reader READER = new Reader();
    static final OFTableFeaturePropApplyActionsMissVer13Funnel FUNNEL = new OFTableFeaturePropApplyActionsMissVer13Funnel();
    static final Writer WRITER = new Writer();

    OFTableFeaturePropApplyActionsMissVer13(List<OFActionId> actionIds) {
        this.actionIds = actionIds;
    }

    @Override
    public int getType() {
        return 7;
    }

    @Override
    public List<OFActionId> getActionIds() {
        return this.actionIds;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFTableFeaturePropApplyActionsMiss.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFTableFeaturePropApplyActionsMissVer13(");
        b.append("actionIds=").append(this.actionIds);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFTableFeaturePropApplyActionsMissVer13 other = (OFTableFeaturePropApplyActionsMissVer13)obj;
        return !(this.actionIds == null ? other.actionIds != null : !this.actionIds.equals(other.actionIds));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.actionIds == null ? 0 : this.actionIds.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFTableFeaturePropApplyActionsMissVer13> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFTableFeaturePropApplyActionsMissVer13 message) {
            int startIndex = bb.writerIndex();
            bb.writeShort(7);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            ChannelUtils.writeList(bb, message.actionIds);
            int length = bb.writerIndex() - startIndex;
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFTableFeaturePropApplyActionsMissVer13Funnel
    implements Funnel<OFTableFeaturePropApplyActionsMissVer13> {
        private static final long serialVersionUID = 1L;

        OFTableFeaturePropApplyActionsMissVer13Funnel() {
        }

        public void funnel(OFTableFeaturePropApplyActionsMissVer13 message, PrimitiveSink sink) {
            sink.putShort((short)7);
            FunnelUtils.putList(message.actionIds, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFTableFeaturePropApplyActionsMiss> {
        Reader() {
        }

        @Override
        public OFTableFeaturePropApplyActionsMiss readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 7) {
                throw new OFParseError("Wrong type: Expected=0x7(0x7), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 4) {
                throw new OFParseError("Wrong length: Expected to be >= 4, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            List<OFActionId> actionIds = ChannelUtils.readList(bb, length - (bb.readerIndex() - start), OFActionIdVer13.READER);
            OFTableFeaturePropApplyActionsMissVer13 tableFeaturePropApplyActionsMissVer13 = new OFTableFeaturePropApplyActionsMissVer13(actionIds);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)tableFeaturePropApplyActionsMissVer13);
            }
            return tableFeaturePropApplyActionsMissVer13;
        }
    }

    static class Builder
    implements OFTableFeaturePropApplyActionsMiss.Builder {
        private boolean actionIdsSet;
        private List<OFActionId> actionIds;

        Builder() {
        }

        @Override
        public int getType() {
            return 7;
        }

        @Override
        public List<OFActionId> getActionIds() {
            return this.actionIds;
        }

        @Override
        public OFTableFeaturePropApplyActionsMiss.Builder setActionIds(List<OFActionId> actionIds) {
            this.actionIds = actionIds;
            this.actionIdsSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFTableFeaturePropApplyActionsMiss build() {
            List<OFActionId> actionIds;
            List<OFActionId> list = actionIds = this.actionIdsSet ? this.actionIds : DEFAULT_ACTION_IDS;
            if (actionIds == null) {
                throw new NullPointerException("Property actionIds must not be null");
            }
            return new OFTableFeaturePropApplyActionsMissVer13(actionIds);
        }
    }

    static class BuilderWithParent
    implements OFTableFeaturePropApplyActionsMiss.Builder {
        final OFTableFeaturePropApplyActionsMissVer13 parentMessage;
        private boolean actionIdsSet;
        private List<OFActionId> actionIds;

        BuilderWithParent(OFTableFeaturePropApplyActionsMissVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 7;
        }

        @Override
        public List<OFActionId> getActionIds() {
            return this.actionIds;
        }

        @Override
        public OFTableFeaturePropApplyActionsMiss.Builder setActionIds(List<OFActionId> actionIds) {
            this.actionIds = actionIds;
            this.actionIdsSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFTableFeaturePropApplyActionsMiss build() {
            List actionIds;
            List list = actionIds = this.actionIdsSet ? this.actionIds : this.parentMessage.actionIds;
            if (actionIds == null) {
                throw new NullPointerException("Property actionIds must not be null");
            }
            return new OFTableFeaturePropApplyActionsMissVer13(actionIds);
        }
    }
}

