/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import java.util.Arrays;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFTableFeaturePropExperimenter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFTableFeaturePropExperimenterVer13
implements OFTableFeaturePropExperimenter {
    private static final Logger logger = LoggerFactory.getLogger(OFTableFeaturePropExperimenterVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int MINIMUM_LENGTH = 12;
    private static final long DEFAULT_EXPERIMENTER = 0L;
    private static final long DEFAULT_SUBTYPE = 0L;
    private static final byte[] DEFAULT_EXPERIMENTER_DATA = new byte[0];
    private final long experimenter;
    private final long subtype;
    private final byte[] experimenterData;
    static final OFTableFeaturePropExperimenterVer13 DEFAULT = new OFTableFeaturePropExperimenterVer13(0L, 0L, DEFAULT_EXPERIMENTER_DATA);
    static final Reader READER = new Reader();
    static final OFTableFeaturePropExperimenterVer13Funnel FUNNEL = new OFTableFeaturePropExperimenterVer13Funnel();
    static final Writer WRITER = new Writer();

    OFTableFeaturePropExperimenterVer13(long experimenter, long subtype, byte[] experimenterData) {
        this.experimenter = experimenter;
        this.subtype = subtype;
        this.experimenterData = experimenterData;
    }

    @Override
    public int getType() {
        return 65534;
    }

    @Override
    public long getExperimenter() {
        return this.experimenter;
    }

    @Override
    public long getSubtype() {
        return this.subtype;
    }

    @Override
    public byte[] getExperimenterData() {
        return this.experimenterData;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFTableFeaturePropExperimenter.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFTableFeaturePropExperimenterVer13(");
        b.append("experimenter=").append(this.experimenter);
        b.append(", ");
        b.append("subtype=").append(this.subtype);
        b.append(", ");
        b.append("experimenterData=").append(Arrays.toString(this.experimenterData));
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFTableFeaturePropExperimenterVer13 other = (OFTableFeaturePropExperimenterVer13)obj;
        if (this.experimenter != other.experimenter) {
            return false;
        }
        if (this.subtype != other.subtype) {
            return false;
        }
        return Arrays.equals(this.experimenterData, other.experimenterData);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.experimenter ^ this.experimenter >>> 32);
        result = 31 * (int)(this.subtype ^ this.subtype >>> 32);
        result = 31 * result + Arrays.hashCode(this.experimenterData);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFTableFeaturePropExperimenterVer13> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFTableFeaturePropExperimenterVer13 message) {
            int startIndex = bb.writerIndex();
            bb.writeShort(-2);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            bb.writeInt(U32.t(message.experimenter));
            bb.writeInt(U32.t(message.subtype));
            bb.writeBytes(message.experimenterData);
            int length = bb.writerIndex() - startIndex;
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFTableFeaturePropExperimenterVer13Funnel
    implements Funnel<OFTableFeaturePropExperimenterVer13> {
        private static final long serialVersionUID = 1L;

        OFTableFeaturePropExperimenterVer13Funnel() {
        }

        public void funnel(OFTableFeaturePropExperimenterVer13 message, PrimitiveSink sink) {
            sink.putShort((short)-2);
            sink.putLong(message.experimenter);
            sink.putLong(message.subtype);
            sink.putBytes(message.experimenterData);
        }
    }

    static class Reader
    implements OFMessageReader<OFTableFeaturePropExperimenter> {
        Reader() {
        }

        @Override
        public OFTableFeaturePropExperimenter readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != -2) {
                throw new OFParseError("Wrong type: Expected=0xfffe(0xfffe), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 12) {
                throw new OFParseError("Wrong length: Expected to be >= 12, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long experimenter = U32.f(bb.readInt());
            long subtype = U32.f(bb.readInt());
            byte[] experimenterData = ChannelUtils.readBytes(bb, length - (bb.readerIndex() - start));
            OFTableFeaturePropExperimenterVer13 tableFeaturePropExperimenterVer13 = new OFTableFeaturePropExperimenterVer13(experimenter, subtype, experimenterData);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)tableFeaturePropExperimenterVer13);
            }
            return tableFeaturePropExperimenterVer13;
        }
    }

    static class Builder
    implements OFTableFeaturePropExperimenter.Builder {
        private boolean experimenterSet;
        private long experimenter;
        private boolean subtypeSet;
        private long subtype;
        private boolean experimenterDataSet;
        private byte[] experimenterData;

        Builder() {
        }

        @Override
        public int getType() {
            return 65534;
        }

        @Override
        public long getExperimenter() {
            return this.experimenter;
        }

        @Override
        public OFTableFeaturePropExperimenter.Builder setExperimenter(long experimenter) {
            this.experimenter = experimenter;
            this.experimenterSet = true;
            return this;
        }

        @Override
        public long getSubtype() {
            return this.subtype;
        }

        @Override
        public OFTableFeaturePropExperimenter.Builder setSubtype(long subtype) {
            this.subtype = subtype;
            this.subtypeSet = true;
            return this;
        }

        @Override
        public byte[] getExperimenterData() {
            return this.experimenterData;
        }

        @Override
        public OFTableFeaturePropExperimenter.Builder setExperimenterData(byte[] experimenterData) {
            this.experimenterData = experimenterData;
            this.experimenterDataSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFTableFeaturePropExperimenter build() {
            byte[] experimenterData;
            long experimenter = this.experimenterSet ? this.experimenter : 0L;
            long subtype = this.subtypeSet ? this.subtype : 0L;
            byte[] byArray = experimenterData = this.experimenterDataSet ? this.experimenterData : DEFAULT_EXPERIMENTER_DATA;
            if (experimenterData == null) {
                throw new NullPointerException("Property experimenterData must not be null");
            }
            return new OFTableFeaturePropExperimenterVer13(experimenter, subtype, experimenterData);
        }
    }

    static class BuilderWithParent
    implements OFTableFeaturePropExperimenter.Builder {
        final OFTableFeaturePropExperimenterVer13 parentMessage;
        private boolean experimenterSet;
        private long experimenter;
        private boolean subtypeSet;
        private long subtype;
        private boolean experimenterDataSet;
        private byte[] experimenterData;

        BuilderWithParent(OFTableFeaturePropExperimenterVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 65534;
        }

        @Override
        public long getExperimenter() {
            return this.experimenter;
        }

        @Override
        public OFTableFeaturePropExperimenter.Builder setExperimenter(long experimenter) {
            this.experimenter = experimenter;
            this.experimenterSet = true;
            return this;
        }

        @Override
        public long getSubtype() {
            return this.subtype;
        }

        @Override
        public OFTableFeaturePropExperimenter.Builder setSubtype(long subtype) {
            this.subtype = subtype;
            this.subtypeSet = true;
            return this;
        }

        @Override
        public byte[] getExperimenterData() {
            return this.experimenterData;
        }

        @Override
        public OFTableFeaturePropExperimenter.Builder setExperimenterData(byte[] experimenterData) {
            this.experimenterData = experimenterData;
            this.experimenterDataSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFTableFeaturePropExperimenter build() {
            byte[] experimenterData;
            long experimenter = this.experimenterSet ? this.experimenter : this.parentMessage.experimenter;
            long subtype = this.subtypeSet ? this.subtype : this.parentMessage.subtype;
            byte[] byArray = experimenterData = this.experimenterDataSet ? this.experimenterData : this.parentMessage.experimenterData;
            if (experimenterData == null) {
                throw new NullPointerException("Property experimenterData must not be null");
            }
            return new OFTableFeaturePropExperimenterVer13(experimenter, subtype, experimenterData);
        }
    }
}

