/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.types;

import com.google.common.hash.PrimitiveSink;
import com.google.common.primitives.UnsignedInts;
import javax.annotation.concurrent.Immutable;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.types.OFValueType;

@Immutable
public class ClassId
implements OFValueType<ClassId> {
    static final int LENGTH = 4;
    private static final int NONE_VAL = 0;
    public static final ClassId NONE = new ClassId(0);
    private static final int NO_MASK_VAL = -1;
    public static final ClassId NO_MASK = new ClassId(-1);
    public static final ClassId FULL_MASK = NONE;
    private final int rawValue;

    private ClassId(int rawValue) {
        this.rawValue = rawValue;
    }

    public static ClassId of(int raw) {
        if (raw == 0) {
            return NONE;
        }
        if (raw == -1) {
            return NO_MASK;
        }
        return new ClassId(raw);
    }

    public int getInt() {
        return this.rawValue;
    }

    @Override
    public int getLength() {
        return 4;
    }

    public String toString() {
        return Integer.toString(this.rawValue);
    }

    @Override
    public ClassId applyMask(ClassId mask) {
        return ClassId.of(this.rawValue & mask.rawValue);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.rawValue;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClassId other = (ClassId)obj;
        return this.rawValue == other.rawValue;
    }

    public void write4Bytes(ChannelBuffer c) {
        c.writeInt(this.rawValue);
    }

    public static ClassId read4Bytes(ChannelBuffer c) {
        return ClassId.of(c.readInt());
    }

    @Override
    public int compareTo(ClassId o) {
        return UnsignedInts.compare((int)this.rawValue, (int)this.rawValue);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        sink.putInt(this.rawValue);
    }
}

