/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.types;

import com.google.common.hash.PrimitiveSink;
import com.google.common.primitives.Longs;
import com.google.common.primitives.UnsignedLongs;
import org.projectfloodlight.openflow.annotations.Immutable;
import org.projectfloodlight.openflow.types.PrimitiveSinkable;
import org.projectfloodlight.openflow.types.U64;
import org.projectfloodlight.openflow.util.HexString;

@Immutable
public class DatapathId
implements PrimitiveSinkable,
Comparable<DatapathId> {
    public static final DatapathId NONE = new DatapathId(0L);
    private final long rawValue;

    private DatapathId(long rawValue) {
        this.rawValue = rawValue;
    }

    public static DatapathId of(long rawValue) {
        return new DatapathId(rawValue);
    }

    public static DatapathId of(String s) {
        return new DatapathId(HexString.toLong(s));
    }

    public static DatapathId of(byte[] bytes) {
        return new DatapathId(Longs.fromByteArray((byte[])bytes));
    }

    public long getLong() {
        return this.rawValue;
    }

    public U64 getUnsignedLong() {
        return U64.of(this.rawValue);
    }

    public byte[] getBytes() {
        return Longs.toByteArray((long)this.rawValue);
    }

    public String toString() {
        return HexString.toHexString(this.rawValue);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.rawValue ^ this.rawValue >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DatapathId other = (DatapathId)obj;
        return this.rawValue == other.rawValue;
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        sink.putLong(this.rawValue);
    }

    @Override
    public int compareTo(DatapathId o) {
        return UnsignedLongs.compare((long)this.rawValue, (long)o.rawValue);
    }
}

