/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.types;

import com.google.common.hash.PrimitiveSink;
import com.google.common.primitives.UnsignedInts;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.types.OFValueType;

public class EthType
implements OFValueType<EthType> {
    static final int LENGTH = 2;
    private final int rawValue;
    static final int VAL_IPv4 = 2048;
    static final int VAL_ARP = 2054;
    static final int VAL_WAKE_ON_LAN = 2114;
    static final int VAL_TRILL = 8947;
    static final int VAL_DECNET_IV = 24579;
    static final int VAL_REV_ARP = 32821;
    static final int VAL_APPLE_TALK = 32923;
    static final int VAL_APPLE_TALK_ARP = 33011;
    static final int VAL_VLAN_FRAME = 33024;
    static final int VAL_IPX_8137 = 33079;
    static final int VAL_IPX_8138 = 33080;
    static final int VAL_QNX = 33284;
    static final int VAL_IPv6 = 34525;
    static final int VAL_ETH_FLOW = 34824;
    static final int VAL_SLOW_PROTOCOLS = 34825;
    static final int VAL_COBRANET = 34841;
    static final int VAL_MPLS_UNICAST = 34887;
    static final int VAL_MPLS_MULTICAST = 34888;
    static final int VAL_PPPoE_DISCOVERY = 34915;
    static final int VAL_PPPoE_SESSION = 34916;
    static final int VAL_JUMBO_FRAMES = 34928;
    static final int VAL_HOMEPLUG_10 = 34939;
    static final int VAL_EAP_OVER_LAN = 34958;
    static final int VAL_PROFINET = 34962;
    static final int VAL_HYPERSCSI = 34970;
    static final int VAL_ATA_OVER_ETH = 34978;
    static final int VAL_ETHERCAT = 34980;
    static final int VAL_BRIDGING = 34984;
    static final int VAL_POWERLINK = 34987;
    static final int VAL_LLDP = 35020;
    static final int VAL_SERCOS = 35021;
    static final int VAL_HOMEPLUG_AV = 35041;
    static final int VAL_MRP = 35043;
    static final int VAL_MAC_SEC = 35045;
    static final int VAL_PTP = 35063;
    static final int VAL_CFM = 35074;
    static final int VAL_FCoE = 35078;
    static final int VAL_FCoE_INIT = 35092;
    static final int VAL_RoCE = 35093;
    static final int VAL_HSR = 35119;
    static final int VAL_CONF_TEST = 36864;
    static final int VAL_Q_IN_Q = 37120;
    static final int VAL_LLT = 51966;
    public static final EthType IPv4 = new EthType(2048);
    public static final EthType ARP = new EthType(2054);
    public static final EthType WAKE_ON_LAN = new EthType(2114);
    public static final EthType TRILL = new EthType(8947);
    public static final EthType DECNET_IV = new EthType(24579);
    public static final EthType REV_ARP = new EthType(32821);
    public static final EthType APPLE_TALK = new EthType(32923);
    public static final EthType APPLE_TALK_ARP = new EthType(33011);
    public static final EthType VLAN_FRAME = new EthType(33024);
    public static final EthType IPX_8137 = new EthType(33079);
    public static final EthType IPX_8138 = new EthType(33080);
    public static final EthType QNX = new EthType(33284);
    public static final EthType IPv6 = new EthType(34525);
    public static final EthType ETH_FLOW = new EthType(34824);
    public static final EthType SLOW_PROTOCOLS = new EthType(34825);
    public static final EthType COBRANET = new EthType(34841);
    public static final EthType MPLS_UNICAST = new EthType(34887);
    public static final EthType MPLS_MULTICAST = new EthType(34888);
    public static final EthType PPPoE_DISCOVERY = new EthType(34915);
    public static final EthType PPPoE_SESSION = new EthType(34916);
    public static final EthType JUMBO_FRAMES = new EthType(34928);
    public static final EthType HOMEPLUG_10 = new EthType(34939);
    public static final EthType EAP_OVER_LAN = new EthType(34958);
    public static final EthType PROFINET = new EthType(34962);
    public static final EthType HYPERSCSI = new EthType(34970);
    public static final EthType ATA_OVER_ETH = new EthType(34978);
    public static final EthType ETHERCAT = new EthType(34980);
    public static final EthType BRIDGING = new EthType(34984);
    public static final EthType POWERLINK = new EthType(34987);
    public static final EthType LLDP = new EthType(35020);
    public static final EthType SERCOS = new EthType(35021);
    public static final EthType HOMEPLUG_AV = new EthType(35041);
    public static final EthType MRP = new EthType(35043);
    public static final EthType MAC_SEC = new EthType(35045);
    public static final EthType PTP = new EthType(35063);
    public static final EthType CFM = new EthType(35074);
    public static final EthType FCoE = new EthType(35078);
    public static final EthType FCoE_INIT = new EthType(35092);
    public static final EthType RoCE = new EthType(35093);
    public static final EthType HSR = new EthType(35119);
    public static final EthType CONF_TEST = new EthType(36864);
    public static final EthType Q_IN_Q = new EthType(37120);
    public static final EthType LLT = new EthType(51966);
    private static final int NONE_VAL = 0;
    public static final EthType NONE = new EthType(0);
    public static final EthType NO_MASK = new EthType(-1);
    public static final EthType FULL_MASK = new EthType(0);

    private EthType(int type) {
        this.rawValue = type;
    }

    @Override
    public int getLength() {
        return 2;
    }

    public static EthType of(int type) {
        switch (type) {
            case 0: {
                return NONE;
            }
            case 2048: {
                return IPv4;
            }
            case 2054: {
                return ARP;
            }
            case 2114: {
                return WAKE_ON_LAN;
            }
            case 8947: {
                return TRILL;
            }
            case 24579: {
                return DECNET_IV;
            }
            case 32821: {
                return REV_ARP;
            }
            case 32923: {
                return APPLE_TALK;
            }
            case 33011: {
                return APPLE_TALK_ARP;
            }
            case 33024: {
                return VLAN_FRAME;
            }
            case 33079: {
                return IPX_8137;
            }
            case 33080: {
                return IPX_8138;
            }
            case 33284: {
                return QNX;
            }
            case 34525: {
                return IPv6;
            }
            case 34824: {
                return ETH_FLOW;
            }
            case 34825: {
                return SLOW_PROTOCOLS;
            }
            case 34841: {
                return COBRANET;
            }
            case 34887: {
                return MPLS_UNICAST;
            }
            case 34888: {
                return MPLS_MULTICAST;
            }
            case 34915: {
                return PPPoE_DISCOVERY;
            }
            case 34916: {
                return PPPoE_SESSION;
            }
            case 34928: {
                return JUMBO_FRAMES;
            }
            case 34939: {
                return HOMEPLUG_10;
            }
            case 34958: {
                return EAP_OVER_LAN;
            }
            case 34962: {
                return PROFINET;
            }
            case 34970: {
                return HYPERSCSI;
            }
            case 34978: {
                return ATA_OVER_ETH;
            }
            case 34980: {
                return ETHERCAT;
            }
            case 34984: {
                return BRIDGING;
            }
            case 34987: {
                return POWERLINK;
            }
            case 35020: {
                return LLDP;
            }
            case 35021: {
                return SERCOS;
            }
            case 35041: {
                return HOMEPLUG_AV;
            }
            case 35043: {
                return MRP;
            }
            case 35045: {
                return MAC_SEC;
            }
            case 35063: {
                return PTP;
            }
            case 35074: {
                return CFM;
            }
            case 35078: {
                return FCoE;
            }
            case 35092: {
                return FCoE_INIT;
            }
            case 35093: {
                return RoCE;
            }
            case 35119: {
                return HSR;
            }
            case 36864: {
                return CONF_TEST;
            }
            case 37120: {
                return Q_IN_Q;
            }
            case 51966: {
                return LLT;
            }
        }
        return new EthType(type);
    }

    public String toString() {
        return Integer.toHexString(this.rawValue);
    }

    public void write2Bytes(ChannelBuffer c) {
        c.writeShort(this.rawValue);
    }

    public static EthType read2Bytes(ChannelBuffer c) {
        return EthType.of(c.readUnsignedShort());
    }

    @Override
    public EthType applyMask(EthType mask) {
        return EthType.of(this.rawValue & mask.rawValue);
    }

    public int getValue() {
        return this.rawValue;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof EthType)) {
            return false;
        }
        EthType o = (EthType)obj;
        return o.rawValue == this.rawValue;
    }

    public int hashCode() {
        int prime = 37;
        int result = 1;
        result = 37 * result + this.rawValue;
        return result;
    }

    @Override
    public int compareTo(EthType o) {
        return UnsignedInts.compare((int)this.rawValue, (int)o.rawValue);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        sink.putInt(this.rawValue);
    }
}

