/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.types;

import com.google.common.base.Preconditions;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import javax.annotation.Nonnull;
import org.projectfloodlight.openflow.types.IPAddressWithMask;
import org.projectfloodlight.openflow.types.IPVersion;
import org.projectfloodlight.openflow.types.IPv4Address;
import org.projectfloodlight.openflow.types.IPv6Address;
import org.projectfloodlight.openflow.types.OFValueType;

public abstract class IPAddress<F extends IPAddress<F>>
implements OFValueType<F> {
    public abstract IPVersion getIpVersion();

    public abstract boolean isCidrMask();

    public abstract int asCidrMaskLength();

    public abstract boolean isBroadcast();

    public abstract F and(F var1);

    public abstract F or(F var1);

    public abstract F not();

    @Nonnull
    public abstract IPAddressWithMask<F> withMask(@Nonnull F var1);

    @Nonnull
    public abstract IPAddressWithMask<F> withMaskOfLength(int var1);

    public abstract byte[] getBytes();

    public abstract String toString();

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    @Nonnull
    public static IPAddress<?> of(@Nonnull String ip) {
        Preconditions.checkNotNull((Object)ip, (Object)"ip must not be null");
        if (ip.indexOf(46) != -1) {
            return IPv4Address.of(ip);
        }
        if (ip.indexOf(58) != -1) {
            return IPv6Address.of(ip);
        }
        throw new IllegalArgumentException("IP Address not well formed: " + ip);
    }

    @Nonnull
    public static IPAddress<?> of(@Nonnull InetAddress address) {
        Preconditions.checkNotNull((Object)address, (Object)"address must not be null");
        if (address instanceof Inet4Address) {
            return IPv4Address.of((Inet4Address)address);
        }
        if (address instanceof Inet6Address) {
            return IPv6Address.of((Inet6Address)address);
        }
        return IPAddress.of(address.getHostAddress());
    }

    @Deprecated
    @Nonnull
    public static IPAddress<?> fromInetAddress(@Nonnull InetAddress address) {
        return IPAddress.of(address);
    }
}

