/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.types;

import com.google.common.base.Preconditions;
import com.google.common.hash.PrimitiveSink;
import com.google.common.primitives.UnsignedInts;
import java.net.Inet4Address;
import java.util.Arrays;
import javax.annotation.Nonnull;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.types.IPAddress;
import org.projectfloodlight.openflow.types.IPVersion;
import org.projectfloodlight.openflow.types.IPv4AddressWithMask;

public class IPv4Address
extends IPAddress<IPv4Address> {
    static final int LENGTH = 4;
    private final int rawValue;
    private static final int NOT_A_CIDR_MASK = -1;
    private static final int CIDR_MASK_CACHE_UNSET = -2;
    private volatile int cidrMaskLengthCache = -2;
    private static final int NONE_VAL = 0;
    public static final IPv4Address NONE = new IPv4Address(0);
    public static final IPv4Address NO_MASK = IPv4Address.of(-1);
    public static final IPv4Address FULL_MASK = IPv4Address.of(0);
    private volatile byte[] bytesCache = null;

    private IPv4Address(int rawValue) {
        this.rawValue = rawValue;
    }

    @Override
    public IPVersion getIpVersion() {
        return IPVersion.IPv4;
    }

    private int asCidrMaskLengthInternal() {
        if (this.cidrMaskLengthCache == -2) {
            int maskint = this.getInt();
            this.cidrMaskLengthCache = maskint == 0 ? 0 : (Integer.bitCount(~maskint + 1) == 1 ? Integer.bitCount(maskint) : -1);
        }
        return this.cidrMaskLengthCache;
    }

    @Override
    public boolean isCidrMask() {
        return this.asCidrMaskLengthInternal() != -1;
    }

    @Override
    public int asCidrMaskLength() {
        if (!this.isCidrMask()) {
            throw new IllegalStateException("IP is not a valid CIDR prefix mask " + this.toString());
        }
        return this.asCidrMaskLengthInternal();
    }

    @Override
    public boolean isBroadcast() {
        return this.equals(NO_MASK);
    }

    @Override
    public IPv4Address and(IPv4Address other) {
        Preconditions.checkNotNull((Object)other, (Object)"other must not be null");
        IPv4Address otherIp = other;
        return IPv4Address.of(this.rawValue & otherIp.rawValue);
    }

    @Override
    public IPv4Address or(IPv4Address other) {
        Preconditions.checkNotNull((Object)other, (Object)"other must not be null");
        IPv4Address otherIp = other;
        return IPv4Address.of(this.rawValue | otherIp.rawValue);
    }

    @Override
    public IPv4Address not() {
        return IPv4Address.of(~this.rawValue);
    }

    @Nonnull
    public static IPv4Address of(@Nonnull byte[] address) {
        Preconditions.checkNotNull((Object)address, (Object)"address must not be null");
        if (address.length != 4) {
            throw new IllegalArgumentException("Invalid byte array length for IPv4 address: " + address.length);
        }
        int raw = (address[0] & 0xFF) << 24 | (address[1] & 0xFF) << 16 | (address[2] & 0xFF) << 8 | (address[3] & 0xFF) << 0;
        return IPv4Address.of(raw);
    }

    @Nonnull
    public static IPv4Address of(int raw) {
        if (raw == 0) {
            return NONE;
        }
        return new IPv4Address(raw);
    }

    @Nonnull
    public static IPv4Address of(@Nonnull String string) throws IllegalArgumentException {
        Preconditions.checkNotNull((Object)string, (Object)"string must not be null");
        int start = 0;
        int raw = 0;
        for (int shift = 24; shift >= 0; shift -= 8) {
            int end = string.indexOf(46, start);
            if (end == start || !(shift > 0 ^ end < 0)) {
                throw new IllegalArgumentException("IP Address not well formed: " + string);
            }
            String substr = end > 0 ? string.substring(start, end) : string.substring(start);
            int val = Integer.parseInt(substr);
            if (val < 0 || val > 255) {
                throw new IllegalArgumentException("IP Address not well formed: " + string);
            }
            raw |= val << shift;
            start = end + 1;
        }
        return IPv4Address.of(raw);
    }

    @Nonnull
    public static IPv4Address of(@Nonnull Inet4Address address) {
        Preconditions.checkNotNull((Object)address, (Object)"address must not be null");
        return IPv4Address.of(address.getAddress());
    }

    @Nonnull
    public static IPv4Address ofCidrMaskLength(int cidrMaskLength) {
        Preconditions.checkArgument((cidrMaskLength >= 0 && cidrMaskLength <= 32 ? 1 : 0) != 0, (String)"Invalid IPv4 CIDR mask length: %s", (Object[])new Object[]{cidrMaskLength});
        if (cidrMaskLength == 32) {
            return NO_MASK;
        }
        if (cidrMaskLength == 0) {
            return FULL_MASK;
        }
        int mask = -1 << 32 - cidrMaskLength;
        return IPv4Address.of(mask);
    }

    @Nonnull
    public IPv4AddressWithMask withMask(@Nonnull IPv4Address mask) {
        return IPv4AddressWithMask.of(this, mask);
    }

    @Nonnull
    public IPv4AddressWithMask withMaskOfLength(int cidrMaskLength) {
        return this.withMask(IPv4Address.ofCidrMaskLength(cidrMaskLength));
    }

    public int getInt() {
        return this.rawValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getBytes() {
        if (this.bytesCache == null) {
            IPv4Address iPv4Address = this;
            synchronized (iPv4Address) {
                if (this.bytesCache == null) {
                    this.bytesCache = new byte[]{(byte)(this.rawValue >>> 24 & 0xFF), (byte)(this.rawValue >>> 16 & 0xFF), (byte)(this.rawValue >>> 8 & 0xFF), (byte)(this.rawValue >>> 0 & 0xFF)};
                }
            }
        }
        return Arrays.copyOf(this.bytesCache, this.bytesCache.length);
    }

    @Override
    public int getLength() {
        return 4;
    }

    @Override
    public String toString() {
        StringBuilder res = new StringBuilder();
        res.append(this.rawValue >> 24 & 0xFF).append('.');
        res.append(this.rawValue >> 16 & 0xFF).append('.');
        res.append(this.rawValue >> 8 & 0xFF).append('.');
        res.append(this.rawValue >> 0 & 0xFF);
        return res.toString();
    }

    public void write4Bytes(ChannelBuffer c) {
        c.writeInt(this.rawValue);
    }

    public static IPv4Address read4Bytes(ChannelBuffer c) {
        return IPv4Address.of(c.readInt());
    }

    @Override
    public IPv4Address applyMask(IPv4Address mask) {
        return this.and(mask);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.rawValue;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IPv4Address other = (IPv4Address)obj;
        return this.rawValue == other.rawValue;
    }

    @Override
    public int compareTo(IPv4Address o) {
        return UnsignedInts.compare((int)this.rawValue, (int)o.rawValue);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        sink.putInt(this.rawValue);
    }
}

