/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.types;

import com.google.common.base.Preconditions;
import com.google.common.hash.PrimitiveSink;
import com.google.common.primitives.Longs;
import java.net.Inet6Address;
import java.util.Arrays;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.types.IPAddress;
import org.projectfloodlight.openflow.types.IPVersion;
import org.projectfloodlight.openflow.types.IPv6AddressWithMask;

public class IPv6Address
extends IPAddress<IPv6Address> {
    static final int LENGTH = 16;
    private final long raw1;
    private final long raw2;
    private static final int NOT_A_CIDR_MASK = -1;
    private static final int CIDR_MASK_CACHE_UNSET = -2;
    private volatile int cidrMaskLengthCache = -2;
    private static final long NONE_VAL1 = 0L;
    private static final long NONE_VAL2 = 0L;
    public static final IPv6Address NONE = new IPv6Address(0L, 0L);
    public static final IPv6Address NO_MASK = IPv6Address.of(-1L, -1L);
    public static final IPv6Address FULL_MASK = IPv6Address.of(0L, 0L);
    private static final Pattern colonPattern = Pattern.compile(":");
    private volatile byte[] bytesCache = null;

    private IPv6Address(long raw1, long raw2) {
        this.raw1 = raw1;
        this.raw2 = raw2;
    }

    @Override
    public IPVersion getIpVersion() {
        return IPVersion.IPv6;
    }

    private int computeCidrMask64(long raw) {
        long mask = raw;
        if (raw == 0L) {
            return 0;
        }
        if (Long.bitCount((mask ^ 0xFFFFFFFFFFFFFFFFL) + 1L) == 1) {
            return Long.bitCount(mask);
        }
        return -1;
    }

    private int asCidrMaskLengthInternal() {
        if (this.cidrMaskLengthCache == -2) {
            if (this.raw1 == 0L && this.raw2 == 0L) {
                this.cidrMaskLengthCache = 0;
            } else if (this.raw1 == -1L) {
                int tmpLength = this.computeCidrMask64(this.raw2);
                if (tmpLength != -1) {
                    tmpLength += 64;
                }
                this.cidrMaskLengthCache = tmpLength;
            } else {
                this.cidrMaskLengthCache = this.raw2 == 0L ? this.computeCidrMask64(this.raw1) : -1;
            }
        }
        return this.cidrMaskLengthCache;
    }

    @Override
    public boolean isCidrMask() {
        return this.asCidrMaskLengthInternal() != -1;
    }

    @Override
    public int asCidrMaskLength() {
        if (!this.isCidrMask()) {
            throw new IllegalStateException("IP is not a valid CIDR prefix mask " + this.toString());
        }
        return this.asCidrMaskLengthInternal();
    }

    @Override
    public boolean isBroadcast() {
        return this.equals(NO_MASK);
    }

    @Override
    public IPv6Address and(IPv6Address other) {
        Preconditions.checkNotNull((Object)other, (Object)"other must not be null");
        IPv6Address otherIp = other;
        return IPv6Address.of(this.raw1 & otherIp.raw1, this.raw2 & otherIp.raw2);
    }

    @Override
    public IPv6Address or(IPv6Address other) {
        Preconditions.checkNotNull((Object)other, (Object)"other must not be null");
        IPv6Address otherIp = other;
        return IPv6Address.of(this.raw1 | otherIp.raw1, this.raw2 | otherIp.raw2);
    }

    @Override
    public IPv6Address not() {
        return IPv6Address.of(this.raw1 ^ 0xFFFFFFFFFFFFFFFFL, this.raw2 ^ 0xFFFFFFFFFFFFFFFFL);
    }

    @Nonnull
    public static IPv6Address of(@Nonnull byte[] address) {
        Preconditions.checkNotNull((Object)address, (Object)"address must not be null");
        if (address.length != 16) {
            throw new IllegalArgumentException("Invalid byte array length for IPv6 address: " + address.length);
        }
        long raw1 = ((long)address[0] & 0xFFL) << 56 | ((long)address[1] & 0xFFL) << 48 | ((long)address[2] & 0xFFL) << 40 | ((long)address[3] & 0xFFL) << 32 | ((long)address[4] & 0xFFL) << 24 | ((long)address[5] & 0xFFL) << 16 | ((long)address[6] & 0xFFL) << 8 | (long)address[7];
        long raw2 = ((long)address[8] & 0xFFL) << 56 | ((long)address[9] & 0xFFL) << 48 | ((long)address[10] & 0xFFL) << 40 | ((long)address[11] & 0xFFL) << 32 | ((long)address[12] & 0xFFL) << 24 | ((long)address[13] & 0xFFL) << 16 | ((long)address[14] & 0xFFL) << 8 | (long)address[15];
        return IPv6Address.of(raw1, raw2);
    }

    @Nonnull
    public static IPv6Address of(@Nonnull String string) throws IllegalArgumentException {
        Preconditions.checkNotNull((Object)string, (Object)"string must not be null");
        IPv6Builder builder = new IPv6Builder();
        String[] parts = colonPattern.split(string, -1);
        int leftWord = 0;
        int leftIndex = 0;
        boolean hitZeroCompression = false;
        for (leftIndex = 0; leftIndex < parts.length; ++leftIndex) {
            String part = parts[leftIndex];
            if (part.length() == 0) {
                hitZeroCompression = true;
                break;
            }
            builder.setUnsignedShortWord(leftWord++, Integer.parseInt(part, 16));
        }
        if (hitZeroCompression) {
            String part;
            int rightIndex;
            if (leftIndex == 0) {
                leftIndex = 1;
                if (parts.length < 2 || parts[1].length() > 0) {
                    throw new IllegalArgumentException("Malformed IPv6 address: " + string);
                }
            }
            int rightWord = 7;
            for (rightIndex = parts.length - 1; rightIndex > leftIndex && (part = parts[rightIndex]).length() != 0; --rightIndex) {
                builder.setUnsignedShortWord(rightWord--, Integer.parseInt(part, 16));
            }
            if (rightIndex == parts.length - 1) {
                if (rightIndex < 1 || parts[rightIndex - 1].length() > 0) {
                    throw new IllegalArgumentException("Malformed IPv6 address: " + string);
                }
                --rightIndex;
            }
            if (leftIndex != rightIndex) {
                throw new IllegalArgumentException("Malformed IPv6 address: " + string);
            }
        } else if (leftIndex != 8) {
            throw new IllegalArgumentException("Malformed IPv6 address: " + string);
        }
        return builder.getIPv6();
    }

    @Nonnull
    public static IPv6Address of(long raw1, long raw2) {
        if (raw1 == 0L && raw2 == 0L) {
            return NONE;
        }
        return new IPv6Address(raw1, raw2);
    }

    @Nonnull
    public static IPv6Address of(@Nonnull Inet6Address address) {
        Preconditions.checkNotNull((Object)address, (Object)"address must not be null");
        return IPv6Address.of(address.getAddress());
    }

    @Nonnull
    public static IPv6Address ofCidrMaskLength(int cidrMaskLength) {
        Preconditions.checkArgument((cidrMaskLength >= 0 && cidrMaskLength <= 128 ? 1 : 0) != 0, (String)"Invalid IPv6 CIDR mask length: %s", (Object[])new Object[]{cidrMaskLength});
        if (cidrMaskLength == 128) {
            return NO_MASK;
        }
        if (cidrMaskLength == 0) {
            return FULL_MASK;
        }
        int shift1 = Math.min(cidrMaskLength, 64);
        long raw1 = shift1 == 0 ? 0L : -1L << 64 - shift1;
        int shift2 = Math.max(cidrMaskLength - 64, 0);
        long raw2 = shift2 == 0 ? 0L : -1L << 64 - shift2;
        return IPv6Address.of(raw1, raw2);
    }

    @Nonnull
    public IPv6AddressWithMask withMask(@Nonnull IPv6Address mask) {
        return IPv6AddressWithMask.of(this, mask);
    }

    @Nonnull
    public IPv6AddressWithMask withMaskOfLength(int cidrMaskLength) {
        return this.withMask(IPv6Address.ofCidrMaskLength(cidrMaskLength));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getBytes() {
        if (this.bytesCache == null) {
            IPv6Address iPv6Address = this;
            synchronized (iPv6Address) {
                if (this.bytesCache == null) {
                    this.bytesCache = new byte[]{(byte)(this.raw1 >> 56 & 0xFFL), (byte)(this.raw1 >> 48 & 0xFFL), (byte)(this.raw1 >> 40 & 0xFFL), (byte)(this.raw1 >> 32 & 0xFFL), (byte)(this.raw1 >> 24 & 0xFFL), (byte)(this.raw1 >> 16 & 0xFFL), (byte)(this.raw1 >> 8 & 0xFFL), (byte)(this.raw1 >> 0 & 0xFFL), (byte)(this.raw2 >> 56 & 0xFFL), (byte)(this.raw2 >> 48 & 0xFFL), (byte)(this.raw2 >> 40 & 0xFFL), (byte)(this.raw2 >> 32 & 0xFFL), (byte)(this.raw2 >> 24 & 0xFFL), (byte)(this.raw2 >> 16 & 0xFFL), (byte)(this.raw2 >> 8 & 0xFFL), (byte)(this.raw2 >> 0 & 0xFFL)};
                }
            }
        }
        return Arrays.copyOf(this.bytesCache, this.bytesCache.length);
    }

    @Override
    public int getLength() {
        return 16;
    }

    @Override
    public String toString() {
        return this.toString(true, false);
    }

    public int getUnsignedShortWord(int i) {
        if (i >= 0 && i < 4) {
            return (int)(this.raw1 >>> 48 - i * 16 & 0xFFFFL);
        }
        if (i >= 4 && i < 8) {
            return (int)(this.raw2 >>> 48 - (i - 4) * 16 & 0xFFFFL);
        }
        throw new IllegalArgumentException("16 bit word index must be in [0,7]");
    }

    public int getZeroCompressStart() {
        int candidateLength;
        int start = Integer.MAX_VALUE;
        int maxLength = -1;
        int candidateStart = -1;
        for (int i = 0; i < 8; ++i) {
            if (candidateStart >= 0) {
                if (this.getUnsignedShortWord(i) == 0) continue;
                int candidateLength2 = i - candidateStart;
                if (candidateLength2 >= maxLength) {
                    start = candidateStart;
                    maxLength = candidateLength2;
                }
                candidateStart = -1;
                continue;
            }
            if (this.getUnsignedShortWord(i) != 0) continue;
            candidateStart = i;
        }
        if (candidateStart >= 0 && (candidateLength = 8 - candidateStart) >= maxLength) {
            start = candidateStart;
            maxLength = candidateLength;
        }
        return start;
    }

    public String toString(boolean zeroCompression, boolean leadingZeros) {
        StringBuilder res = new StringBuilder();
        int compressionStart = zeroCompression ? this.getZeroCompressStart() : Integer.MAX_VALUE;
        boolean inCompression = false;
        boolean colonNeeded = false;
        for (int i = 0; i < 8; ++i) {
            int word = this.getUnsignedShortWord(i);
            if (word == 0) {
                if (inCompression) continue;
                if (i == compressionStart) {
                    res.append(':').append(':');
                    inCompression = true;
                    colonNeeded = false;
                    continue;
                }
            } else {
                inCompression = false;
            }
            if (colonNeeded) {
                res.append(':');
                colonNeeded = false;
            }
            res.append(leadingZeros ? String.format("%04x", word) : Integer.toString(word, 16));
            colonNeeded = true;
        }
        return res.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.raw1 ^ this.raw1 >>> 32);
        result = 31 * result + (int)(this.raw2 ^ this.raw2 >>> 32);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IPv6Address other = (IPv6Address)obj;
        if (this.raw1 != other.raw1) {
            return false;
        }
        return this.raw2 == other.raw2;
    }

    public void write16Bytes(ChannelBuffer c) {
        c.writeLong(this.raw1);
        c.writeLong(this.raw2);
    }

    public static IPv6Address read16Bytes(ChannelBuffer c) throws OFParseError {
        return IPv6Address.of(c.readLong(), c.readLong());
    }

    @Override
    public IPv6Address applyMask(IPv6Address mask) {
        return this.and(mask);
    }

    @Override
    public int compareTo(IPv6Address o) {
        int res = Longs.compare((long)this.raw1, (long)o.raw1);
        if (res != 0) {
            return res;
        }
        return Longs.compare((long)this.raw2, (long)o.raw2);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        sink.putLong(this.raw1);
        sink.putLong(this.raw2);
    }

    private static class IPv6Builder {
        private long raw1;
        private long raw2;

        private IPv6Builder() {
        }

        public void setUnsignedShortWord(int i, int value) {
            int shift = 48 - i % 4 * 16;
            if (value < 0 || value > 65535) {
                throw new IllegalArgumentException("16 bit word must be in [0, 0xFFFF]");
            }
            if (i >= 0 && i < 4) {
                this.raw1 = this.raw1 & (65535L << shift ^ 0xFFFFFFFFFFFFFFFFL) | ((long)value & 0xFFFFL) << shift;
            } else if (i >= 4 && i < 8) {
                this.raw2 = this.raw2 & (65535L << shift ^ 0xFFFFFFFFFFFFFFFFL) | ((long)value & 0xFFFFL) << shift;
            } else {
                throw new IllegalArgumentException("16 bit word index must be in [0,7]");
            }
        }

        public IPv6Address getIPv6() {
            return IPv6Address.of(this.raw1, this.raw2);
        }
    }
}

