/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.types;

import com.google.common.base.Preconditions;
import org.projectfloodlight.openflow.types.IPAddress;
import org.projectfloodlight.openflow.types.IPAddressWithMask;
import org.projectfloodlight.openflow.types.IPVersion;
import org.projectfloodlight.openflow.types.IPv6Address;

public class IPv6AddressWithMask
extends IPAddressWithMask<IPv6Address> {
    public static final IPv6AddressWithMask NONE = IPv6AddressWithMask.of(IPv6Address.NONE, IPv6Address.NONE);

    private IPv6AddressWithMask(IPv6Address value, IPv6Address mask) {
        super(value, mask);
    }

    @Override
    public IPVersion getIpVersion() {
        return IPVersion.IPv6;
    }

    public static IPv6AddressWithMask of(IPv6Address value, IPv6Address mask) {
        Preconditions.checkNotNull((Object)value, (Object)"value must not be null");
        Preconditions.checkNotNull((Object)mask, (Object)"mask must not be null");
        return new IPv6AddressWithMask(value, mask);
    }

    public static IPv6AddressWithMask of(String string) {
        Preconditions.checkNotNull((Object)string, (Object)"string must not be null");
        String ip = string;
        int cidrMaskLength = 128;
        IPv6Address maskAddress = null;
        int slashPos = string.indexOf(47);
        if (slashPos != -1) {
            ip = string.substring(0, slashPos);
            try {
                String suffix = string.substring(slashPos + 1);
                if (suffix.length() == 0) {
                    throw new IllegalArgumentException("IPv6 Address not well formed: " + string);
                }
                if (suffix.indexOf(58) != -1) {
                    maskAddress = IPv6Address.of(suffix);
                } else {
                    cidrMaskLength = Integer.parseInt(suffix);
                }
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("IPv6 Address not well formed: " + string);
            }
        }
        IPv6Address ipv6 = IPv6Address.of(ip);
        if (maskAddress != null) {
            return IPv6AddressWithMask.of(ipv6, maskAddress);
        }
        return IPv6AddressWithMask.of(ipv6, IPv6Address.ofCidrMaskLength(cidrMaskLength));
    }

    @Override
    public boolean contains(IPAddress<?> ip) {
        Preconditions.checkNotNull(ip, (Object)"ip must not be null");
        if (ip.getIpVersion() == IPVersion.IPv6) {
            IPv6Address ipv6 = (IPv6Address)ip;
            return this.matches(ipv6);
        }
        return false;
    }
}

