/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.types;

import com.google.common.hash.PrimitiveSink;
import com.google.common.primitives.UnsignedInts;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.annotations.Immutable;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.types.OFValueType;
import org.projectfloodlight.openflow.types.U32;

@Immutable
public class OFPort
implements OFValueType<OFPort> {
    static final int LENGTH = 4;
    private static final int OFPP_ANY_INT = -1;
    private static final int OFPP_LOCAL_INT = -2;
    private static final int OFPP_CONTROLLER_INT = -3;
    private static final int OFPP_ALL_INT = -4;
    private static final int OFPP_FLOOD_INT = -5;
    private static final int OFPP_NORMAL_INT = -6;
    private static final int OFPP_TABLE_INT = -7;
    private static final int OFPP_MAX_INT = -256;
    private static final int OFPP_IN_PORT_INT = -8;
    private static final short OFPP_ANY_SHORT = -1;
    private static final short OFPP_LOCAL_SHORT = -2;
    private static final short OFPP_CONTROLLER_SHORT = -3;
    private static final short OFPP_ALL_SHORT = -4;
    private static final short OFPP_FLOOD_SHORT = -5;
    private static final short OFPP_NORMAL_SHORT = -6;
    private static final short OFPP_TABLE_SHORT = -7;
    private static final short OFPP_IN_PORT_SHORT = -8;
    private static final short OFPP_MAX_SHORT = -256;
    private static final int OFPP_MAX_SHORT_UNSIGNED = 65280;
    public static final OFPort MAX = new NamedPort(-256, "max");
    public static final OFPort IN_PORT = new NamedPort(-8, "in_port");
    public static final OFPort TABLE = new NamedPort(-7, "table");
    public static final OFPort NORMAL = new NamedPort(-6, "normal");
    public static final OFPort FLOOD = new NamedPort(-5, "flood");
    public static final OFPort ALL = new NamedPort(-4, "all");
    public static final OFPort CONTROLLER = new NamedPort(-3, "controller");
    public static final OFPort LOCAL = new NamedPort(-2, "local");
    public static final OFPort ANY = new NamedPort(-1, "any");
    public static final OFPort ZERO = OFPort.of(0);
    public static final OFPort NO_MASK = OFPort.of(-1);
    public static final OFPort FULL_MASK = ZERO;
    private final int portNumber;

    private OFPort(int portNumber) {
        this.portNumber = portNumber;
    }

    public static OFPort ofInt(int portNumber) {
        switch (portNumber) {
            case 0: {
                return PrecachedPort.p0;
            }
            case 1: {
                return PrecachedPort.p1;
            }
            case 2: {
                return PrecachedPort.p2;
            }
            case 3: {
                return PrecachedPort.p3;
            }
            case 4: {
                return PrecachedPort.p4;
            }
            case 5: {
                return PrecachedPort.p5;
            }
            case 6: {
                return PrecachedPort.p6;
            }
            case 7: {
                return PrecachedPort.p7;
            }
            case 8: {
                return PrecachedPort.p8;
            }
            case 9: {
                return PrecachedPort.p9;
            }
            case 10: {
                return PrecachedPort.p10;
            }
            case 11: {
                return PrecachedPort.p11;
            }
            case 12: {
                return PrecachedPort.p12;
            }
            case 13: {
                return PrecachedPort.p13;
            }
            case 14: {
                return PrecachedPort.p14;
            }
            case 15: {
                return PrecachedPort.p15;
            }
            case 16: {
                return PrecachedPort.p16;
            }
            case 17: {
                return PrecachedPort.p17;
            }
            case 18: {
                return PrecachedPort.p18;
            }
            case 19: {
                return PrecachedPort.p19;
            }
            case 20: {
                return PrecachedPort.p20;
            }
            case 21: {
                return PrecachedPort.p21;
            }
            case 22: {
                return PrecachedPort.p22;
            }
            case 23: {
                return PrecachedPort.p23;
            }
            case 24: {
                return PrecachedPort.p24;
            }
            case 25: {
                return PrecachedPort.p25;
            }
            case 26: {
                return PrecachedPort.p26;
            }
            case 27: {
                return PrecachedPort.p27;
            }
            case 28: {
                return PrecachedPort.p28;
            }
            case 29: {
                return PrecachedPort.p29;
            }
            case 31: {
                return PrecachedPort.p31;
            }
            case 32: {
                return PrecachedPort.p32;
            }
            case 33: {
                return PrecachedPort.p33;
            }
            case 34: {
                return PrecachedPort.p34;
            }
            case 35: {
                return PrecachedPort.p35;
            }
            case 36: {
                return PrecachedPort.p36;
            }
            case 37: {
                return PrecachedPort.p37;
            }
            case 38: {
                return PrecachedPort.p38;
            }
            case 39: {
                return PrecachedPort.p39;
            }
            case 40: {
                return PrecachedPort.p40;
            }
            case 41: {
                return PrecachedPort.p41;
            }
            case 42: {
                return PrecachedPort.p42;
            }
            case 43: {
                return PrecachedPort.p43;
            }
            case 44: {
                return PrecachedPort.p44;
            }
            case 45: {
                return PrecachedPort.p45;
            }
            case 46: {
                return PrecachedPort.p46;
            }
            case 47: {
                return PrecachedPort.p47;
            }
            case 48: {
                return PrecachedPort.p48;
            }
            case -256: {
                return MAX;
            }
            case -8: {
                return IN_PORT;
            }
            case -7: {
                return TABLE;
            }
            case -6: {
                return NORMAL;
            }
            case -5: {
                return FLOOD;
            }
            case -4: {
                return ALL;
            }
            case -3: {
                return CONTROLLER;
            }
            case -2: {
                return LOCAL;
            }
            case -1: {
                return ANY;
            }
        }
        if (portNumber < 0 && portNumber > -256) {
            throw new IllegalArgumentException("Unknown special port number: " + portNumber);
        }
        return new OFPort(portNumber);
    }

    public static OFPort of(int portNumber) {
        return OFPort.ofInt(portNumber);
    }

    public static OFPort ofShort(short portNumber) {
        switch (portNumber) {
            case 0: {
                return PrecachedPort.p0;
            }
            case 1: {
                return PrecachedPort.p1;
            }
            case 2: {
                return PrecachedPort.p2;
            }
            case 3: {
                return PrecachedPort.p3;
            }
            case 4: {
                return PrecachedPort.p4;
            }
            case 5: {
                return PrecachedPort.p5;
            }
            case 6: {
                return PrecachedPort.p6;
            }
            case 7: {
                return PrecachedPort.p7;
            }
            case 8: {
                return PrecachedPort.p8;
            }
            case 9: {
                return PrecachedPort.p9;
            }
            case 10: {
                return PrecachedPort.p10;
            }
            case 11: {
                return PrecachedPort.p11;
            }
            case 12: {
                return PrecachedPort.p12;
            }
            case 13: {
                return PrecachedPort.p13;
            }
            case 14: {
                return PrecachedPort.p14;
            }
            case 15: {
                return PrecachedPort.p15;
            }
            case 16: {
                return PrecachedPort.p16;
            }
            case 17: {
                return PrecachedPort.p17;
            }
            case 18: {
                return PrecachedPort.p18;
            }
            case 19: {
                return PrecachedPort.p19;
            }
            case 20: {
                return PrecachedPort.p20;
            }
            case 21: {
                return PrecachedPort.p21;
            }
            case 22: {
                return PrecachedPort.p22;
            }
            case 23: {
                return PrecachedPort.p23;
            }
            case 24: {
                return PrecachedPort.p24;
            }
            case 25: {
                return PrecachedPort.p25;
            }
            case 26: {
                return PrecachedPort.p26;
            }
            case 27: {
                return PrecachedPort.p27;
            }
            case 28: {
                return PrecachedPort.p28;
            }
            case 29: {
                return PrecachedPort.p29;
            }
            case 31: {
                return PrecachedPort.p31;
            }
            case 32: {
                return PrecachedPort.p32;
            }
            case 33: {
                return PrecachedPort.p33;
            }
            case 34: {
                return PrecachedPort.p34;
            }
            case 35: {
                return PrecachedPort.p35;
            }
            case 36: {
                return PrecachedPort.p36;
            }
            case 37: {
                return PrecachedPort.p37;
            }
            case 38: {
                return PrecachedPort.p38;
            }
            case 39: {
                return PrecachedPort.p39;
            }
            case 40: {
                return PrecachedPort.p40;
            }
            case 41: {
                return PrecachedPort.p41;
            }
            case 42: {
                return PrecachedPort.p42;
            }
            case 43: {
                return PrecachedPort.p43;
            }
            case 44: {
                return PrecachedPort.p44;
            }
            case 45: {
                return PrecachedPort.p45;
            }
            case 46: {
                return PrecachedPort.p46;
            }
            case 47: {
                return PrecachedPort.p47;
            }
            case 48: {
                return PrecachedPort.p48;
            }
            case -256: {
                return MAX;
            }
            case -8: {
                return IN_PORT;
            }
            case -7: {
                return TABLE;
            }
            case -6: {
                return NORMAL;
            }
            case -5: {
                return FLOOD;
            }
            case -4: {
                return ALL;
            }
            case -3: {
                return CONTROLLER;
            }
            case -2: {
                return LOCAL;
            }
            case -1: {
                return ANY;
            }
        }
        if (portNumber < 0 && portNumber > -256) {
            throw new IllegalArgumentException("Unknown special port number: " + portNumber);
        }
        return new OFPort(portNumber);
    }

    public int getPortNumber() {
        return this.portNumber;
    }

    public short getShortPortNumber() {
        switch (this.portNumber) {
            case -256: {
                return -256;
            }
            case -8: {
                return -8;
            }
            case -7: {
                return -7;
            }
            case -6: {
                return -6;
            }
            case -5: {
                return -5;
            }
            case -4: {
                return -4;
            }
            case -3: {
                return -3;
            }
            case -2: {
                return -2;
            }
            case -1: {
                return -1;
            }
        }
        if (this.portNumber >= 65280 || this.portNumber < 0) {
            throw new IllegalArgumentException("32bit Port number " + U32.f(this.portNumber) + " cannot be represented as uint16 (OF1.0)");
        }
        return (short)this.portNumber;
    }

    public String toString() {
        return Long.toString(U32.f(this.portNumber));
    }

    @Override
    public int getLength() {
        return 4;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof OFPort)) {
            return false;
        }
        OFPort other = (OFPort)obj;
        return other.portNumber == this.portNumber;
    }

    public int hashCode() {
        int prime = 53;
        int result = 1;
        result = 53 * result + this.portNumber;
        return result;
    }

    public void write2Bytes(ChannelBuffer c) {
        c.writeShort(this.portNumber);
    }

    public static OFPort read2Bytes(ChannelBuffer c) throws OFParseError {
        return OFPort.ofShort(c.readShort());
    }

    public void write4Bytes(ChannelBuffer c) {
        c.writeInt(this.portNumber);
    }

    public static OFPort read4Bytes(ChannelBuffer c) throws OFParseError {
        return OFPort.of((int)(c.readUnsignedInt() & 0xFFFFFFFFFFFFFFFFL));
    }

    @Override
    public OFPort applyMask(OFPort mask) {
        return OFPort.of(this.portNumber & mask.portNumber);
    }

    @Override
    public int compareTo(OFPort o) {
        return UnsignedInts.compare((int)this.portNumber, (int)o.portNumber);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        sink.putInt(this.portNumber);
    }

    static class NamedPort
    extends OFPort {
        private final String name;

        NamedPort(int portNo, String name) {
            super(portNo);
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        @Override
        public String toString() {
            return this.name;
        }
    }

    private static class PrecachedPort {
        private static final OFPort p0 = new OFPort(0);
        private static final OFPort p1 = new OFPort(1);
        private static final OFPort p2 = new OFPort(2);
        private static final OFPort p3 = new OFPort(3);
        private static final OFPort p4 = new OFPort(4);
        private static final OFPort p5 = new OFPort(5);
        private static final OFPort p6 = new OFPort(6);
        private static final OFPort p7 = new OFPort(7);
        private static final OFPort p8 = new OFPort(8);
        private static final OFPort p9 = new OFPort(9);
        private static final OFPort p10 = new OFPort(10);
        private static final OFPort p11 = new OFPort(11);
        private static final OFPort p12 = new OFPort(12);
        private static final OFPort p13 = new OFPort(13);
        private static final OFPort p14 = new OFPort(14);
        private static final OFPort p15 = new OFPort(15);
        private static final OFPort p16 = new OFPort(16);
        private static final OFPort p17 = new OFPort(17);
        private static final OFPort p18 = new OFPort(18);
        private static final OFPort p19 = new OFPort(19);
        private static final OFPort p20 = new OFPort(20);
        private static final OFPort p21 = new OFPort(21);
        private static final OFPort p22 = new OFPort(22);
        private static final OFPort p23 = new OFPort(23);
        private static final OFPort p24 = new OFPort(24);
        private static final OFPort p25 = new OFPort(25);
        private static final OFPort p26 = new OFPort(26);
        private static final OFPort p27 = new OFPort(27);
        private static final OFPort p28 = new OFPort(28);
        private static final OFPort p29 = new OFPort(29);
        private static final OFPort p31 = new OFPort(31);
        private static final OFPort p32 = new OFPort(32);
        private static final OFPort p33 = new OFPort(33);
        private static final OFPort p34 = new OFPort(34);
        private static final OFPort p35 = new OFPort(35);
        private static final OFPort p36 = new OFPort(36);
        private static final OFPort p37 = new OFPort(37);
        private static final OFPort p38 = new OFPort(38);
        private static final OFPort p39 = new OFPort(39);
        private static final OFPort p40 = new OFPort(40);
        private static final OFPort p41 = new OFPort(41);
        private static final OFPort p42 = new OFPort(42);
        private static final OFPort p43 = new OFPort(43);
        private static final OFPort p44 = new OFPort(44);
        private static final OFPort p45 = new OFPort(45);
        private static final OFPort p46 = new OFPort(46);
        private static final OFPort p47 = new OFPort(47);
        private static final OFPort p48 = new OFPort(48);

        private PrecachedPort() {
        }
    }
}

