/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.types;

import com.google.common.hash.PrimitiveSink;
import com.google.common.primitives.Shorts;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.types.OFValueType;

public class TableId
implements OFValueType<TableId>,
Comparable<TableId> {
    static final int LENGTH = 1;
    private static final short VALIDATION_MASK = 255;
    private static final short ALL_VAL = 255;
    private static final short NONE_VAL = 0;
    public static final TableId NONE = new TableId(0);
    public static final TableId ALL = new TableId(255);
    public static final TableId ZERO = NONE;
    private final short id;

    private TableId(short id) {
        this.id = id;
    }

    public static TableId of(short id) {
        switch (id) {
            case 0: {
                return NONE;
            }
            case 255: {
                return ALL;
            }
        }
        if ((id & 0xFF) != id) {
            throw new IllegalArgumentException("Illegal Table id value: " + id);
        }
        return new TableId(id);
    }

    public static TableId of(int id) {
        if ((id & 0xFF) != id) {
            throw new IllegalArgumentException("Illegal Table id value: " + id);
        }
        return TableId.of((short)id);
    }

    public String toString() {
        return "0x" + Integer.toHexString(this.id);
    }

    public short getValue() {
        return this.id;
    }

    @Override
    public int getLength() {
        return 1;
    }

    public void writeByte(ChannelBuffer c) {
        c.writeByte((int)this.id);
    }

    public static TableId readByte(ChannelBuffer c) throws OFParseError {
        return TableId.of(c.readUnsignedByte());
    }

    @Override
    public TableId applyMask(TableId mask) {
        return TableId.of((short)(this.id & mask.id));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TableId)) {
            return false;
        }
        TableId other = (TableId)obj;
        return other.id == this.id;
    }

    public int hashCode() {
        int prime = 13873;
        return this.id * prime;
    }

    @Override
    public int compareTo(TableId other) {
        return Shorts.compare((short)this.id, (short)other.id);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        sink.putByte((byte)this.id);
    }
}

