/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.types;

import com.google.common.hash.PrimitiveSink;
import com.google.common.primitives.UnsignedInts;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.Writeable;
import org.projectfloodlight.openflow.types.OFValueType;

public class U32
implements Writeable,
OFValueType<U32> {
    private static final int ZERO_VAL = 0;
    public static final U32 ZERO = new U32(0);
    private static final int NO_MASK_VAL = -1;
    public static final U32 NO_MASK = new U32(-1);
    public static final U32 FULL_MASK = ZERO;
    private final int raw;
    public static final Reader READER = new Reader();

    private U32(int raw) {
        this.raw = raw;
    }

    public static U32 of(long value) {
        return U32.ofRaw(U32.t(value));
    }

    public static U32 ofRaw(int raw) {
        if (raw == 0) {
            return ZERO;
        }
        if (raw == -1) {
            return NO_MASK;
        }
        return new U32(raw);
    }

    public long getValue() {
        return U32.f(this.raw);
    }

    public int getRaw() {
        return this.raw;
    }

    public String toString() {
        return String.format("0x%08x", this.raw);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.raw;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        U32 other = (U32)obj;
        return this.raw == other.raw;
    }

    public static long f(int i) {
        return (long)i & 0xFFFFFFFFL;
    }

    public static int t(long l) {
        return (int)l;
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        bb.writeInt(this.raw);
    }

    @Override
    public int getLength() {
        return 4;
    }

    @Override
    public U32 applyMask(U32 mask) {
        return U32.ofRaw(this.raw & mask.raw);
    }

    @Override
    public int compareTo(U32 o) {
        return UnsignedInts.compare((int)this.raw, (int)o.raw);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        sink.putInt(this.raw);
    }

    private static class Reader
    implements OFMessageReader<U32> {
        private Reader() {
        }

        @Override
        public U32 readFrom(ChannelBuffer bb) throws OFParseError {
            return new U32(bb.readInt());
        }
    }
}

