/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.util;

import org.projectfloodlight.openflow.types.U8;

public class HexString {
    public static String toHexString(byte[] bytes) {
        String ret = "";
        for (int i = 0; i < bytes.length; ++i) {
            String tmp;
            if (i > 0) {
                ret = ret + ":";
            }
            if ((tmp = Integer.toHexString(U8.f(bytes[i]))).length() == 1) {
                ret = ret + "0";
            }
            ret = ret + tmp;
        }
        return ret;
    }

    public static String toHexString(long val, int padTo) {
        int i;
        char[] arr = Long.toHexString(val).toCharArray();
        String ret = "";
        for (i = 0; i < padTo * 2 - arr.length; ++i) {
            ret = ret + "0";
            if (i % 2 == 0) continue;
            ret = ret + ":";
        }
        for (int j = 0; j < arr.length; ++j) {
            ret = ret + arr[j];
            if ((i + j) % 2 == 0 || j >= arr.length - 1) continue;
            ret = ret + ":";
        }
        return ret;
    }

    public static String toHexString(long val) {
        return HexString.toHexString(val, 8);
    }

    public static byte[] fromHexString(String values) throws NumberFormatException {
        String[] octets = values.split(":");
        byte[] ret = new byte[octets.length];
        for (int i = 0; i < octets.length; ++i) {
            if (octets[i].length() > 2) {
                throw new NumberFormatException("Invalid octet length");
            }
            ret[i] = Integer.valueOf(octets[i], 16).byteValue();
        }
        return ret;
    }

    public static long toLong(String value) throws NumberFormatException {
        String[] octets = value.split(":");
        if (octets.length > 8) {
            throw new NumberFormatException("Input string is too big to fit in long: " + value);
        }
        long l = 0L;
        for (String octet : octets) {
            if (octet.length() > 2) {
                throw new NumberFormatException("Each colon-separated byte component must consist of 1 or 2 hex digits: " + value);
            }
            short s = Short.parseShort(octet, 16);
            l = (l << 8) + (long)s;
        }
        return l;
    }
}

