// Copyright (c) 2008 The Board of Trustees of The Leland Stanford Junior University
// Copyright (c) 2011, 2012 Open Networking Foundation
// Copyright (c) 2012, 2013 Big Switch Networks, Inc.
// This library was generated by the LoxiGen Compiler.
// See the file LICENSE.txt which should have been included in the source distribution

// Automatically generated by LOXI from template of_class.java
// Do not modify

package org.projectfloodlight.openflow.protocol.ver13;

import org.projectfloodlight.openflow.protocol.*;
import org.projectfloodlight.openflow.protocol.action.*;
import org.projectfloodlight.openflow.protocol.actionid.*;
import org.projectfloodlight.openflow.protocol.bsntlv.*;
import org.projectfloodlight.openflow.protocol.errormsg.*;
import org.projectfloodlight.openflow.protocol.meterband.*;
import org.projectfloodlight.openflow.protocol.instruction.*;
import org.projectfloodlight.openflow.protocol.instructionid.*;
import org.projectfloodlight.openflow.protocol.match.*;
import org.projectfloodlight.openflow.protocol.oxm.*;
import org.projectfloodlight.openflow.protocol.queueprop.*;
import org.projectfloodlight.openflow.types.*;
import org.projectfloodlight.openflow.util.*;
import org.projectfloodlight.openflow.exceptions.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.util.Set;
import org.jboss.netty.buffer.ChannelBuffer;
import com.google.common.hash.PrimitiveSink;
import com.google.common.hash.Funnel;

class OFExpPortOpticalTransportLayerEntryVer13 implements OFExpPortOpticalTransportLayerEntry {
    private static final Logger logger = LoggerFactory.getLogger(OFExpPortOpticalTransportLayerEntryVer13.class);
    // version: 1.3
    final static byte WIRE_VERSION = 4;
    final static int LENGTH = 8;

        private final static short DEFAULT_SIGNAL_TYPE = (short) 0x0;

    // OF message fields
    private final OFPortOpticalTransportLayerClass layerClass;
    private final short signalType;
    private final OFAdaptationsType adaptation;
//

    // package private constructor - used by readers, builders, and factory
    OFExpPortOpticalTransportLayerEntryVer13(OFPortOpticalTransportLayerClass layerClass, short signalType, OFAdaptationsType adaptation) {
        if(layerClass == null) {
            throw new NullPointerException("OFExpPortOpticalTransportLayerEntryVer13: property layerClass cannot be null");
        }
        if(adaptation == null) {
            throw new NullPointerException("OFExpPortOpticalTransportLayerEntryVer13: property adaptation cannot be null");
        }
        this.layerClass = layerClass;
        this.signalType = signalType;
        this.adaptation = adaptation;
    }

    // Accessors for OF message fields
    @Override
    public OFPortOpticalTransportLayerClass getLayerClass() {
        return layerClass;
    }

    @Override
    public short getSignalType() {
        return signalType;
    }

    @Override
    public OFAdaptationsType getAdaptation() {
        return adaptation;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }



    public OFExpPortOpticalTransportLayerEntry.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    static class BuilderWithParent implements OFExpPortOpticalTransportLayerEntry.Builder {
        final OFExpPortOpticalTransportLayerEntryVer13 parentMessage;

        // OF message fields
        private boolean layerClassSet;
        private OFPortOpticalTransportLayerClass layerClass;
        private boolean signalTypeSet;
        private short signalType;
        private boolean adaptationSet;
        private OFAdaptationsType adaptation;

        BuilderWithParent(OFExpPortOpticalTransportLayerEntryVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

    @Override
    public OFPortOpticalTransportLayerClass getLayerClass() {
        return layerClass;
    }

    @Override
    public OFExpPortOpticalTransportLayerEntry.Builder setLayerClass(OFPortOpticalTransportLayerClass layerClass) {
        this.layerClass = layerClass;
        this.layerClassSet = true;
        return this;
    }
    @Override
    public short getSignalType() {
        return signalType;
    }

    @Override
    public OFExpPortOpticalTransportLayerEntry.Builder setSignalType(short signalType) {
        this.signalType = signalType;
        this.signalTypeSet = true;
        return this;
    }
    @Override
    public OFAdaptationsType getAdaptation() {
        return adaptation;
    }

    @Override
    public OFExpPortOpticalTransportLayerEntry.Builder setAdaptation(OFAdaptationsType adaptation) {
        this.adaptation = adaptation;
        this.adaptationSet = true;
        return this;
    }
    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }



        @Override
        public OFExpPortOpticalTransportLayerEntry build() {
                OFPortOpticalTransportLayerClass layerClass = this.layerClassSet ? this.layerClass : parentMessage.layerClass;
                if(layerClass == null)
                    throw new NullPointerException("Property layerClass must not be null");
                short signalType = this.signalTypeSet ? this.signalType : parentMessage.signalType;
                OFAdaptationsType adaptation = this.adaptationSet ? this.adaptation : parentMessage.adaptation;
                if(adaptation == null)
                    throw new NullPointerException("Property adaptation must not be null");

                //
                return new OFExpPortOpticalTransportLayerEntryVer13(
                    layerClass,
                    signalType,
                    adaptation
                );
        }

    }

    static class Builder implements OFExpPortOpticalTransportLayerEntry.Builder {
        // OF message fields
        private boolean layerClassSet;
        private OFPortOpticalTransportLayerClass layerClass;
        private boolean signalTypeSet;
        private short signalType;
        private boolean adaptationSet;
        private OFAdaptationsType adaptation;

    @Override
    public OFPortOpticalTransportLayerClass getLayerClass() {
        return layerClass;
    }

    @Override
    public OFExpPortOpticalTransportLayerEntry.Builder setLayerClass(OFPortOpticalTransportLayerClass layerClass) {
        this.layerClass = layerClass;
        this.layerClassSet = true;
        return this;
    }
    @Override
    public short getSignalType() {
        return signalType;
    }

    @Override
    public OFExpPortOpticalTransportLayerEntry.Builder setSignalType(short signalType) {
        this.signalType = signalType;
        this.signalTypeSet = true;
        return this;
    }
    @Override
    public OFAdaptationsType getAdaptation() {
        return adaptation;
    }

    @Override
    public OFExpPortOpticalTransportLayerEntry.Builder setAdaptation(OFAdaptationsType adaptation) {
        this.adaptation = adaptation;
        this.adaptationSet = true;
        return this;
    }
    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

//
        @Override
        public OFExpPortOpticalTransportLayerEntry build() {
            if(!this.layerClassSet)
                throw new IllegalStateException("Property layerClass doesn't have default value -- must be set");
            if(layerClass == null)
                throw new NullPointerException("Property layerClass must not be null");
            short signalType = this.signalTypeSet ? this.signalType : DEFAULT_SIGNAL_TYPE;
            if(!this.adaptationSet)
                throw new IllegalStateException("Property adaptation doesn't have default value -- must be set");
            if(adaptation == null)
                throw new NullPointerException("Property adaptation must not be null");


            return new OFExpPortOpticalTransportLayerEntryVer13(
                    layerClass,
                    signalType,
                    adaptation
                );
        }

    }


    final static Reader READER = new Reader();
    static class Reader implements OFMessageReader<OFExpPortOpticalTransportLayerEntry> {
        @Override
        public OFExpPortOpticalTransportLayerEntry readFrom(ChannelBuffer bb) throws OFParseError {
            OFPortOpticalTransportLayerClass layerClass = OFPortOpticalTransportLayerClassSerializerVer13.readFrom(bb);
            short signalType = U8.f(bb.readByte());
            OFAdaptationsType adaptation = OFAdaptationsTypeSerializerVer13.readFrom(bb);
            // pad: 5 bytes
            bb.skipBytes(5);

            OFExpPortOpticalTransportLayerEntryVer13 expPortOpticalTransportLayerEntryVer13 = new OFExpPortOpticalTransportLayerEntryVer13(
                    layerClass,
                      signalType,
                      adaptation
                    );
            if(logger.isTraceEnabled())
                logger.trace("readFrom - read={}", expPortOpticalTransportLayerEntryVer13);
            return expPortOpticalTransportLayerEntryVer13;
        }
    }

    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    final static OFExpPortOpticalTransportLayerEntryVer13Funnel FUNNEL = new OFExpPortOpticalTransportLayerEntryVer13Funnel();
    static class OFExpPortOpticalTransportLayerEntryVer13Funnel implements Funnel<OFExpPortOpticalTransportLayerEntryVer13> {
        private static final long serialVersionUID = 1L;
        @Override
        public void funnel(OFExpPortOpticalTransportLayerEntryVer13 message, PrimitiveSink sink) {
            OFPortOpticalTransportLayerClassSerializerVer13.putTo(message.layerClass, sink);
            sink.putShort(message.signalType);
            OFAdaptationsTypeSerializerVer13.putTo(message.adaptation, sink);
            // skip pad (5 bytes)
        }
    }


    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    final static Writer WRITER = new Writer();
    static class Writer implements OFMessageWriter<OFExpPortOpticalTransportLayerEntryVer13> {
        @Override
        public void write(ChannelBuffer bb, OFExpPortOpticalTransportLayerEntryVer13 message) {
            OFPortOpticalTransportLayerClassSerializerVer13.writeTo(bb, message.layerClass);
            bb.writeByte(U8.t(message.signalType));
            OFAdaptationsTypeSerializerVer13.writeTo(bb, message.adaptation);
            // pad: 5 bytes
            bb.writeZero(5);


        }
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder("OFExpPortOpticalTransportLayerEntryVer13(");
        b.append("layerClass=").append(layerClass);
        b.append(", ");
        b.append("signalType=").append(signalType);
        b.append(", ");
        b.append("adaptation=").append(adaptation);
        b.append(")");
        return b.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        OFExpPortOpticalTransportLayerEntryVer13 other = (OFExpPortOpticalTransportLayerEntryVer13) obj;

        if (layerClass == null) {
            if (other.layerClass != null)
                return false;
        } else if (!layerClass.equals(other.layerClass))
            return false;
        if( signalType != other.signalType)
            return false;
        if (adaptation == null) {
            if (other.adaptation != null)
                return false;
        } else if (!adaptation.equals(other.adaptation))
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;

        result = prime * result + ((layerClass == null) ? 0 : layerClass.hashCode());
        result = prime * result + signalType;
        result = prime * result + ((adaptation == null) ? 0 : adaptation.hashCode());
        return result;
    }

}
