/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver10;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.OFHello;
import org.projectfloodlight.openflow.protocol.ver10.OFFactoryVer10;
import org.projectfloodlight.openflow.protocol.ver10.OFHelloVer10;

public class OFHelloVer10Test {
    OFFactory factory;
    static final byte[] HELLO_SERIALIZED = new byte[]{1, 0, 0, 8, 18, 52, 86, 120};

    @Before
    public void setup() {
        this.factory = OFFactoryVer10.INSTANCE;
    }

    @Test
    public void testWrite() {
        OFHello.Builder builder = this.factory.buildHello();
        builder.setXid(305419896L);
        OFHello hello = builder.build();
        ChannelBuffer bb = ChannelBuffers.dynamicBuffer();
        hello.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)HELLO_SERIALIZED));
    }

    @Test
    public void testRead() throws Exception {
        OFHello.Builder builder = this.factory.buildHello();
        builder.setXid(305419896L);
        OFHello helloBuilt = builder.build();
        ChannelBuffer input = ChannelBuffers.copiedBuffer((byte[])HELLO_SERIALIZED);
        OFHello helloRead = OFHelloVer10.READER.readFrom(input);
        Assert.assertEquals((long)HELLO_SERIALIZED.length, (long)input.readerIndex());
        Assert.assertEquals((Object)helloBuilt, (Object)helloRead);
    }

    @Test
    public void testReadWrite() throws Exception {
        ChannelBuffer input = ChannelBuffers.copiedBuffer((byte[])HELLO_SERIALIZED);
        OFHello hello = OFHelloVer10.READER.readFrom(input);
        Assert.assertEquals((long)HELLO_SERIALIZED.length, (long)input.readerIndex());
        ChannelBuffer bb = ChannelBuffers.dynamicBuffer();
        hello.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)HELLO_SERIALIZED));
    }
}

