/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectfloodlight.openflow.protocol.OFBsnVirtualPortCreateRequest;
import org.projectfloodlight.openflow.protocol.OFBsnVport;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.ver13.OFBsnVirtualPortCreateRequestVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFFactoryVer13;

public class OFBsnVirtualPortCreateRequestVer13QInQTest {
    OFFactory factory;
    static final byte[] BSN_VIRTUAL_PORT_CREATE_REQUEST_SERIALIZED = new byte[]{4, 4, 0, 48, 1, 2, 3, 4, 0, 92, 22, -57, 0, 0, 0, 15, 0, 0, 0, 32, 0, 0, 0, 1, 0, 2, 0, 3, 0, 4, 0, 5, 102, 111, 111, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    @Before
    public void setup() {
        this.factory = OFFactoryVer13.INSTANCE;
    }

    @Test
    public void testWrite() {
        OFBsnVirtualPortCreateRequest.Builder builder = this.factory.buildBsnVirtualPortCreateRequest();
        builder.setXid(16909060L).setVport((OFBsnVport)this.factory.buildBsnVportQInQ().setPortNo(1L).setIngressTpid(2).setIngressVlanId(3).setEgressTpid(4).setEgressVlanId(5).setIfName("foo").build());
        OFBsnVirtualPortCreateRequest bsnVirtualPortCreateRequest = builder.build();
        ChannelBuffer bb = ChannelBuffers.dynamicBuffer();
        bsnVirtualPortCreateRequest.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)BSN_VIRTUAL_PORT_CREATE_REQUEST_SERIALIZED));
    }

    @Test
    public void testRead() throws Exception {
        OFBsnVirtualPortCreateRequest.Builder builder = this.factory.buildBsnVirtualPortCreateRequest();
        builder.setXid(16909060L).setVport((OFBsnVport)this.factory.buildBsnVportQInQ().setPortNo(1L).setIngressTpid(2).setIngressVlanId(3).setEgressTpid(4).setEgressVlanId(5).setIfName("foo").build());
        OFBsnVirtualPortCreateRequest bsnVirtualPortCreateRequestBuilt = builder.build();
        ChannelBuffer input = ChannelBuffers.copiedBuffer((byte[])BSN_VIRTUAL_PORT_CREATE_REQUEST_SERIALIZED);
        OFBsnVirtualPortCreateRequest bsnVirtualPortCreateRequestRead = OFBsnVirtualPortCreateRequestVer13.READER.readFrom(input);
        Assert.assertEquals((long)BSN_VIRTUAL_PORT_CREATE_REQUEST_SERIALIZED.length, (long)input.readerIndex());
        Assert.assertEquals((Object)bsnVirtualPortCreateRequestBuilt, (Object)bsnVirtualPortCreateRequestRead);
    }

    @Test
    public void testReadWrite() throws Exception {
        ChannelBuffer input = ChannelBuffers.copiedBuffer((byte[])BSN_VIRTUAL_PORT_CREATE_REQUEST_SERIALIZED);
        OFBsnVirtualPortCreateRequest bsnVirtualPortCreateRequest = OFBsnVirtualPortCreateRequestVer13.READER.readFrom(input);
        Assert.assertEquals((long)BSN_VIRTUAL_PORT_CREATE_REQUEST_SERIALIZED.length, (long)input.readerIndex());
        ChannelBuffer bb = ChannelBuffers.dynamicBuffer();
        bsnVirtualPortCreateRequest.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)BSN_VIRTUAL_PORT_CREATE_REQUEST_SERIALIZED));
    }
}

