/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmMplsBos;
import org.projectfloodlight.openflow.protocol.oxm.OFOxms;
import org.projectfloodlight.openflow.protocol.ver13.OFOxmMplsBosVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFOxmsVer13;

public class OFOxmMplsBosVer13Test {
    OFOxms factory;
    static final byte[] OXM_MPLS_BOS_SERIALIZED = new byte[]{-128, 0, 72, 1, 1};

    @Before
    public void setup() {
        this.factory = OFOxmsVer13.INSTANCE;
    }

    @Test
    public void testReadWrite() throws Exception {
        ChannelBuffer input = ChannelBuffers.copiedBuffer((byte[])OXM_MPLS_BOS_SERIALIZED);
        OFOxmMplsBos oxmMplsBos = OFOxmMplsBosVer13.READER.readFrom(input);
        Assert.assertEquals((long)OXM_MPLS_BOS_SERIALIZED.length, (long)input.readerIndex());
        ChannelBuffer bb = ChannelBuffers.dynamicBuffer();
        oxmMplsBos.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)OXM_MPLS_BOS_SERIALIZED));
    }
}

