/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.types;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.junit.Assert;
import org.junit.Test;
import org.projectfloodlight.openflow.protocol.OFFactories;
import org.projectfloodlight.openflow.protocol.OFFlowAdd;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.OFErrorCauseData;
import org.projectfloodlight.openflow.types.TableId;
import org.projectfloodlight.openflow.types.U64;

public class OFErrorCauseDataTest {
    byte[] truncatedFlowAddd = new byte[]{4, 14, 0, -128, 18, 52, 86, 120, -2, -36, -70, -104, 118, 84, 50, 16, -1, 0, -1, 0, -1, 0, -1, 0, 3};

    @Test
    public void testEmpty() {
        OFErrorCauseData emptyCause = OFErrorCauseData.of((byte[])new byte[0], (OFVersion)OFVersion.OF_13);
        Assert.assertThat((Object)emptyCause.getData(), (Matcher)CoreMatchers.equalTo((Object)new byte[0]));
        Assert.assertThat((Object)emptyCause.getParsedMessage().isPresent(), (Matcher)CoreMatchers.equalTo((Object)false));
        Assert.assertThat((Object)emptyCause.toString(), (Matcher)Matchers.containsString((String)"unparsed"));
    }

    @Test
    public void testTooShort() {
        OFErrorCauseData emptyCause = OFErrorCauseData.of((byte[])new byte[]{1, 2}, (OFVersion)OFVersion.OF_13);
        Assert.assertThat((Object)emptyCause.getData(), (Matcher)CoreMatchers.equalTo((Object)new byte[]{1, 2}));
        Assert.assertThat((Object)emptyCause.getParsedMessage().isPresent(), (Matcher)CoreMatchers.equalTo((Object)false));
        Assert.assertThat((Object)emptyCause.toString(), (Matcher)Matchers.containsString((String)"unparsed"));
        Assert.assertThat((Object)emptyCause.toString(), (Matcher)Matchers.containsString((String)"01 02"));
    }

    @Test
    public void testTruncated() {
        OFErrorCauseData emptyCause = OFErrorCauseData.of((byte[])this.truncatedFlowAddd, (OFVersion)OFVersion.OF_13);
        Assert.assertThat((Object)emptyCause.getData(), (Matcher)CoreMatchers.equalTo((Object)this.truncatedFlowAddd));
        Assert.assertThat((Object)emptyCause.getParsedMessage().isPresent(), (Matcher)CoreMatchers.equalTo((Object)false));
        Assert.assertThat((Object)emptyCause.toString(), (Matcher)Matchers.containsString((String)"unparsed"));
        Assert.assertThat((Object)emptyCause.toString(), (Matcher)Matchers.containsString((String)"04 0e 00 80"));
    }

    @Test
    public void testFlowAdd() {
        OFFlowAdd flowAdd = OFFactories.getFactory((OFVersion)OFVersion.OF_13).buildFlowAdd().setXid(305419896L).setCookie(U64.parseHex((String)"FEDCBA9876543210")).setCookieMask(U64.parseHex((String)"FF00FF00FF00FF00")).setTableId(TableId.of((int)3)).setIdleTimeout(5).setHardTimeout(10).setPriority(6000).build();
        ChannelBuffer bb = ChannelBuffers.dynamicBuffer();
        flowAdd.writeTo(bb);
        byte[] flowAddBytes = new byte[bb.readableBytes()];
        bb.readBytes(flowAddBytes);
        OFErrorCauseData emptyCause = OFErrorCauseData.of((byte[])flowAddBytes, (OFVersion)OFVersion.OF_13);
        Assert.assertThat((Object)emptyCause.getData(), (Matcher)CoreMatchers.equalTo((Object)flowAddBytes));
        Assert.assertThat((Object)emptyCause.getParsedMessage().isPresent(), (Matcher)CoreMatchers.equalTo((Object)true));
        Assert.assertThat((Object)emptyCause.toString(), (Matcher)Matchers.containsString((String)"OFFlowAdd"));
        Assert.assertThat((Object)emptyCause.toString(), (Matcher)Matchers.containsString((String)"idleTimeout=5"));
    }
}

