/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.match;

import org.projectfloodlight.openflow.protocol.match.Match;
import org.projectfloodlight.openflow.protocol.match.MatchFields;
import org.projectfloodlight.openflow.protocol.match.Prerequisite;
import org.projectfloodlight.openflow.types.ArpOpcode;
import org.projectfloodlight.openflow.types.CircuitSignalID;
import org.projectfloodlight.openflow.types.ClassId;
import org.projectfloodlight.openflow.types.EthType;
import org.projectfloodlight.openflow.types.ICMPv4Code;
import org.projectfloodlight.openflow.types.ICMPv4Type;
import org.projectfloodlight.openflow.types.IPv4Address;
import org.projectfloodlight.openflow.types.IPv6Address;
import org.projectfloodlight.openflow.types.IPv6FlowLabel;
import org.projectfloodlight.openflow.types.IpDscp;
import org.projectfloodlight.openflow.types.IpEcn;
import org.projectfloodlight.openflow.types.IpProtocol;
import org.projectfloodlight.openflow.types.LagId;
import org.projectfloodlight.openflow.types.MacAddress;
import org.projectfloodlight.openflow.types.OFBitMask128;
import org.projectfloodlight.openflow.types.OFBitMask512;
import org.projectfloodlight.openflow.types.OFBooleanValue;
import org.projectfloodlight.openflow.types.OFMetadata;
import org.projectfloodlight.openflow.types.OFPort;
import org.projectfloodlight.openflow.types.OFValueType;
import org.projectfloodlight.openflow.types.OFVlanVidMatch;
import org.projectfloodlight.openflow.types.OduSignalID;
import org.projectfloodlight.openflow.types.TransportPort;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.types.U64;
import org.projectfloodlight.openflow.types.U8;
import org.projectfloodlight.openflow.types.UDF;
import org.projectfloodlight.openflow.types.VRF;
import org.projectfloodlight.openflow.types.VlanPcp;

public class MatchField<F extends OFValueType<F>> {
    private final String name;
    public final MatchFields id;
    private final Prerequisite<?>[] prerequisites;
    public static final MatchField<OFPort> IN_PORT = new MatchField("in_port", MatchFields.IN_PORT, new Prerequisite[0]);
    public static final MatchField<OFPort> IN_PHY_PORT = new MatchField("in_phy_port", MatchFields.IN_PHY_PORT, new Prerequisite<OFPort>(IN_PORT, new OFValueType[0]));
    public static final MatchField<OFMetadata> METADATA = new MatchField("metadata", MatchFields.METADATA, new Prerequisite[0]);
    public static final MatchField<MacAddress> ETH_DST = new MatchField("eth_dst", MatchFields.ETH_DST, new Prerequisite[0]);
    public static final MatchField<MacAddress> ETH_SRC = new MatchField("eth_src", MatchFields.ETH_SRC, new Prerequisite[0]);
    public static final MatchField<EthType> ETH_TYPE = new MatchField("eth_type", MatchFields.ETH_TYPE, new Prerequisite[0]);
    public static final MatchField<OFVlanVidMatch> VLAN_VID = new MatchField("vlan_vid", MatchFields.VLAN_VID, new Prerequisite[0]);
    public static final MatchField<VlanPcp> VLAN_PCP = new MatchField("vlan_pcp", MatchFields.VLAN_PCP, new Prerequisite<OFVlanVidMatch>(VLAN_VID, new OFValueType[0]));
    public static final MatchField<IpDscp> IP_DSCP = new MatchField("ip_dscp", MatchFields.IP_DSCP, new Prerequisite<EthType>(ETH_TYPE, EthType.IPv4, EthType.IPv6));
    public static final MatchField<IpEcn> IP_ECN = new MatchField("ip_ecn", MatchFields.IP_ECN, new Prerequisite<EthType>(ETH_TYPE, EthType.IPv4, EthType.IPv6));
    public static final MatchField<IpProtocol> IP_PROTO = new MatchField("ip_proto", MatchFields.IP_PROTO, new Prerequisite<EthType>(ETH_TYPE, EthType.IPv4, EthType.IPv6));
    public static final MatchField<IPv4Address> IPV4_SRC = new MatchField("ipv4_src", MatchFields.IPV4_SRC, new Prerequisite<EthType>(ETH_TYPE, EthType.IPv4));
    public static final MatchField<IPv4Address> IPV4_DST = new MatchField("ipv4_dst", MatchFields.IPV4_DST, new Prerequisite<EthType>(ETH_TYPE, EthType.IPv4));
    public static final MatchField<TransportPort> TCP_SRC = new MatchField("tcp_src", MatchFields.TCP_SRC, new Prerequisite<IpProtocol>(IP_PROTO, IpProtocol.TCP));
    public static final MatchField<TransportPort> TCP_DST = new MatchField("tcp_dst", MatchFields.TCP_DST, new Prerequisite<IpProtocol>(IP_PROTO, IpProtocol.TCP));
    public static final MatchField<TransportPort> UDP_SRC = new MatchField("udp_src", MatchFields.UDP_SRC, new Prerequisite<IpProtocol>(IP_PROTO, IpProtocol.UDP));
    public static final MatchField<TransportPort> UDP_DST = new MatchField("udp_dst", MatchFields.UDP_DST, new Prerequisite<IpProtocol>(IP_PROTO, IpProtocol.UDP));
    public static final MatchField<TransportPort> SCTP_SRC = new MatchField("sctp_src", MatchFields.SCTP_SRC, new Prerequisite<IpProtocol>(IP_PROTO, IpProtocol.SCTP));
    public static final MatchField<TransportPort> SCTP_DST = new MatchField("sctp_dst", MatchFields.SCTP_DST, new Prerequisite<IpProtocol>(IP_PROTO, IpProtocol.SCTP));
    public static final MatchField<ICMPv4Type> ICMPV4_TYPE = new MatchField("icmpv4_type", MatchFields.ICMPV4_TYPE, new Prerequisite<IpProtocol>(IP_PROTO, IpProtocol.ICMP));
    public static final MatchField<ICMPv4Code> ICMPV4_CODE = new MatchField("icmpv4_code", MatchFields.ICMPV4_CODE, new Prerequisite<IpProtocol>(IP_PROTO, IpProtocol.ICMP));
    public static final MatchField<ArpOpcode> ARP_OP = new MatchField("arp_op", MatchFields.ARP_OP, new Prerequisite<EthType>(ETH_TYPE, EthType.ARP));
    public static final MatchField<IPv4Address> ARP_SPA = new MatchField("arp_spa", MatchFields.ARP_SPA, new Prerequisite<EthType>(ETH_TYPE, EthType.ARP));
    public static final MatchField<IPv4Address> ARP_TPA = new MatchField("arp_tpa", MatchFields.ARP_TPA, new Prerequisite<EthType>(ETH_TYPE, EthType.ARP));
    public static final MatchField<MacAddress> ARP_SHA = new MatchField("arp_sha", MatchFields.ARP_SHA, new Prerequisite<EthType>(ETH_TYPE, EthType.ARP));
    public static final MatchField<MacAddress> ARP_THA = new MatchField("arp_tha", MatchFields.ARP_THA, new Prerequisite<EthType>(ETH_TYPE, EthType.ARP));
    public static final MatchField<IPv6Address> IPV6_SRC = new MatchField("ipv6_src", MatchFields.IPV6_SRC, new Prerequisite<EthType>(ETH_TYPE, EthType.IPv6));
    public static final MatchField<IPv6Address> IPV6_DST = new MatchField("ipv6_dst", MatchFields.IPV6_DST, new Prerequisite<EthType>(ETH_TYPE, EthType.IPv6));
    public static final MatchField<IPv6FlowLabel> IPV6_FLABEL = new MatchField("ipv6_flabel", MatchFields.IPV6_FLABEL, new Prerequisite<EthType>(ETH_TYPE, EthType.IPv6));
    public static final MatchField<U8> ICMPV6_TYPE = new MatchField("icmpv6_type", MatchFields.ICMPV6_TYPE, new Prerequisite<IpProtocol>(IP_PROTO, IpProtocol.IPv6_ICMP));
    public static final MatchField<U8> ICMPV6_CODE = new MatchField("icmpv6_code", MatchFields.ICMPV6_CODE, new Prerequisite<IpProtocol>(IP_PROTO, IpProtocol.IPv6_ICMP));
    public static final MatchField<IPv6Address> IPV6_ND_TARGET = new MatchField("ipv6_nd_target", MatchFields.IPV6_ND_TARGET, new Prerequisite<U8>(ICMPV6_TYPE, U8.of((short)135), U8.of((short)136)));
    public static final MatchField<MacAddress> IPV6_ND_SLL = new MatchField("ipv6_nd_sll", MatchFields.IPV6_ND_SLL, new Prerequisite<U8>(ICMPV6_TYPE, U8.of((short)135)));
    public static final MatchField<MacAddress> IPV6_ND_TLL = new MatchField("ipv6_nd_tll", MatchFields.IPV6_ND_TLL, new Prerequisite<U8>(ICMPV6_TYPE, U8.of((short)136)));
    public static final MatchField<U32> MPLS_LABEL = new MatchField("mpls_label", MatchFields.MPLS_LABEL, new Prerequisite<EthType>(ETH_TYPE, EthType.MPLS_UNICAST, EthType.MPLS_MULTICAST));
    public static final MatchField<U8> MPLS_TC = new MatchField("mpls_tc", MatchFields.MPLS_TC, new Prerequisite<EthType>(ETH_TYPE, EthType.MPLS_UNICAST, EthType.MPLS_MULTICAST));
    public static final MatchField<OFBooleanValue> MPLS_BOS = new MatchField("mpls_bos", MatchFields.MPLS_BOS, new Prerequisite<EthType>(ETH_TYPE, EthType.MPLS_UNICAST, EthType.MPLS_MULTICAST));
    public static final MatchField<U64> TUNNEL_ID = new MatchField("tunnel_id", MatchFields.TUNNEL_ID, new Prerequisite[0]);
    public static final MatchField<U16> IPV6_EXTHDR = new MatchField("ipv6_exthdr", MatchFields.IPV6_EXTHDR, new Prerequisite[0]);
    public static final MatchField<OFBooleanValue> PBB_UCA = new MatchField("pbb_uca", MatchFields.PBB_UCA, new Prerequisite[0]);
    public static final MatchField<IPv4Address> TUNNEL_IPV4_SRC = new MatchField("tunnel_ipv4_src", MatchFields.TUNNEL_IPV4_SRC, new Prerequisite<EthType>(ETH_TYPE, EthType.IPv4));
    public static final MatchField<IPv4Address> TUNNEL_IPV4_DST = new MatchField("tunnel_ipv4_dst", MatchFields.TUNNEL_IPV4_DST, new Prerequisite<EthType>(ETH_TYPE, EthType.IPv4));
    public static final MatchField<OFBitMask128> BSN_IN_PORTS_128 = new MatchField("bsn_in_ports_128", MatchFields.BSN_IN_PORTS_128, new Prerequisite[0]);
    public static final MatchField<OFBitMask512> BSN_IN_PORTS_512 = new MatchField("bsn_in_ports_512", MatchFields.BSN_IN_PORTS_512, new Prerequisite[0]);
    public static final MatchField<LagId> BSN_LAG_ID = new MatchField("bsn_lag_id", MatchFields.BSN_LAG_ID, new Prerequisite[0]);
    public static final MatchField<VRF> BSN_VRF = new MatchField("bsn_vrf", MatchFields.BSN_VRF, new Prerequisite[0]);
    public static final MatchField<OFBooleanValue> BSN_GLOBAL_VRF_ALLOWED = new MatchField("bsn_global_vrf_allowed", MatchFields.BSN_GLOBAL_VRF_ALLOWED, new Prerequisite[0]);
    public static final MatchField<ClassId> BSN_L3_INTERFACE_CLASS_ID = new MatchField("bsn_l3_interface_class_id", MatchFields.BSN_L3_INTERFACE_CLASS_ID, new Prerequisite[0]);
    public static final MatchField<ClassId> BSN_L3_SRC_CLASS_ID = new MatchField("bsn_l3_src_class_id", MatchFields.BSN_L3_SRC_CLASS_ID, new Prerequisite[0]);
    public static final MatchField<ClassId> BSN_L3_DST_CLASS_ID = new MatchField("bsn_l3_dst_class_id", MatchFields.BSN_L3_DST_CLASS_ID, new Prerequisite[0]);
    public static final MatchField<ClassId> BSN_EGR_PORT_GROUP_ID = new MatchField("bsn_egr_port_group_id", MatchFields.BSN_EGR_PORT_GROUP_ID, new Prerequisite[0]);
    public static final MatchField<ClassId> BSN_INGRESS_PORT_GROUP_ID = new MatchField("bsn_ingress_port_group_id", MatchFields.BSN_INGRESS_PORT_GROUP_ID, new Prerequisite[0]);
    public static final MatchField<UDF> BSN_UDF0 = new MatchField("bsn_udf", MatchFields.BSN_UDF0, new Prerequisite[0]);
    public static final MatchField<UDF> BSN_UDF1 = new MatchField("bsn_udf", MatchFields.BSN_UDF1, new Prerequisite[0]);
    public static final MatchField<UDF> BSN_UDF2 = new MatchField("bsn_udf", MatchFields.BSN_UDF2, new Prerequisite[0]);
    public static final MatchField<UDF> BSN_UDF3 = new MatchField("bsn_udf", MatchFields.BSN_UDF3, new Prerequisite[0]);
    public static final MatchField<UDF> BSN_UDF4 = new MatchField("bsn_udf", MatchFields.BSN_UDF4, new Prerequisite[0]);
    public static final MatchField<UDF> BSN_UDF5 = new MatchField("bsn_udf", MatchFields.BSN_UDF5, new Prerequisite[0]);
    public static final MatchField<UDF> BSN_UDF6 = new MatchField("bsn_udf", MatchFields.BSN_UDF6, new Prerequisite[0]);
    public static final MatchField<UDF> BSN_UDF7 = new MatchField("bsn_udf", MatchFields.BSN_UDF7, new Prerequisite[0]);
    public static final MatchField<U16> BSN_TCP_FLAGS = new MatchField("bsn_tcp_flags", MatchFields.BSN_TCP_FLAGS, new Prerequisite[0]);
    public static final MatchField<ClassId> BSN_VLAN_XLATE_PORT_GROUP_ID = new MatchField("bsn_vlan_xlate_port_group_id", MatchFields.BSN_VLAN_XLATE_PORT_GROUP_ID, new Prerequisite[0]);
    public static final MatchField<U8> OCH_SIGTYPE = new MatchField("och_sigtype", MatchFields.OCH_SIGTYPE, new Prerequisite[0]);
    public static final MatchField<U8> OCH_SIGTYPE_BASIC = new MatchField("och_sigtype_basic", MatchFields.OCH_SIGTYPE_BASIC, new Prerequisite[0]);
    public static final MatchField<CircuitSignalID> OCH_SIGID = new MatchField("och_sigid", MatchFields.OCH_SIGID, new Prerequisite[0]);
    public static final MatchField<CircuitSignalID> OCH_SIGID_BASIC = new MatchField("och_sigid_basic", MatchFields.OCH_SIGID, new Prerequisite[0]);
    public static final MatchField<OFBooleanValue> BSN_L2_CACHE_HIT = new MatchField("bsn_l2_cache_hit", MatchFields.BSN_L2_CACHE_HIT, new Prerequisite[0]);
    public static final MatchField<U32> BSN_VXLAN_NETWORK_ID = new MatchField("bsn_vxlan_network_id", MatchFields.BSN_VXLAN_NETWORK_ID, new Prerequisite[0]);
    public static final MatchField<MacAddress> BSN_INNER_ETH_DST = new MatchField("bsn_inner_eth_dst", MatchFields.BSN_INNER_ETH_DST, new Prerequisite[0]);
    public static final MatchField<MacAddress> BSN_INNER_ETH_SRC = new MatchField("bsn_inner_eth_src", MatchFields.BSN_INNER_ETH_SRC, new Prerequisite[0]);
    public static final MatchField<OFVlanVidMatch> BSN_INNER_VLAN_VID = new MatchField("bsn_inner_vlan_vid", MatchFields.BSN_INNER_VLAN_VID, new Prerequisite[0]);
    public static final MatchField<OduSignalID> EXP_ODU_SIG_ID = new MatchField("exp_odu_sig_id", MatchFields.EXP_ODU_SIG_ID, new Prerequisite[0]);
    public static final MatchField<U8> EXP_ODU_SIGTYPE = new MatchField("exp_odu_sigtype", MatchFields.EXP_ODU_SIGTYPE, new Prerequisite[0]);
    public static final MatchField<CircuitSignalID> EXP_OCH_SIG_ID = new MatchField("exp_och_sig_id", MatchFields.EXP_OCH_SIG_ID, new Prerequisite[0]);
    public static final MatchField<U8> EXP_OCH_SIGTYPE = new MatchField("exp_och_sigtype", MatchFields.EXP_OCH_SIGTYPE, new Prerequisite[0]);

    private MatchField(String name, MatchFields id, Prerequisite<?> ... prerequisites) {
        this.name = name;
        this.id = id;
        this.prerequisites = prerequisites;
    }

    public String getName() {
        return this.name;
    }

    public boolean arePrerequisitesOK(Match match) {
        for (Prerequisite<?> p : this.prerequisites) {
            if (p.isSatisfied(match)) continue;
            return false;
        }
        return true;
    }
}

