/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver10;

import com.google.common.hash.PrimitiveSink;
import java.util.EnumSet;
import java.util.Set;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFActionType;
import org.projectfloodlight.openflow.protocol.match.Match;
import org.projectfloodlight.openflow.protocol.ver10.OFMatchV1Ver10;

public class ChannelUtilsVer10 {
    public static Match readOFMatch(ChannelBuffer bb) throws OFParseError {
        return OFMatchV1Ver10.READER.readFrom(bb);
    }

    public static Set<OFActionType> readSupportedActions(ChannelBuffer bb) {
        int actions = bb.readInt();
        EnumSet<OFActionType> supportedActions = EnumSet.noneOf(OFActionType.class);
        if ((actions & 1) != 0) {
            supportedActions.add(OFActionType.OUTPUT);
        }
        if ((actions & 2) != 0) {
            supportedActions.add(OFActionType.SET_VLAN_VID);
        }
        if ((actions & 4) != 0) {
            supportedActions.add(OFActionType.SET_VLAN_PCP);
        }
        if ((actions & 8) != 0) {
            supportedActions.add(OFActionType.STRIP_VLAN);
        }
        if ((actions & 0x10) != 0) {
            supportedActions.add(OFActionType.SET_DL_SRC);
        }
        if ((actions & 0x20) != 0) {
            supportedActions.add(OFActionType.SET_DL_DST);
        }
        if ((actions & 0x40) != 0) {
            supportedActions.add(OFActionType.SET_NW_SRC);
        }
        if ((actions & 0x80) != 0) {
            supportedActions.add(OFActionType.SET_NW_DST);
        }
        if ((actions & 0x100) != 0) {
            supportedActions.add(OFActionType.SET_NW_TOS);
        }
        if ((actions & 0x200) != 0) {
            supportedActions.add(OFActionType.SET_TP_SRC);
        }
        if ((actions & 0x400) != 0) {
            supportedActions.add(OFActionType.SET_TP_DST);
        }
        if ((actions & 0x800) != 0) {
            supportedActions.add(OFActionType.ENQUEUE);
        }
        return supportedActions;
    }

    public static int supportedActionsToWire(Set<OFActionType> supportedActions) {
        int supportedActionsVal = 0;
        if (supportedActions.contains((Object)OFActionType.OUTPUT)) {
            supportedActionsVal |= 1;
        }
        if (supportedActions.contains((Object)OFActionType.SET_VLAN_VID)) {
            supportedActionsVal |= 2;
        }
        if (supportedActions.contains((Object)OFActionType.SET_VLAN_PCP)) {
            supportedActionsVal |= 4;
        }
        if (supportedActions.contains((Object)OFActionType.STRIP_VLAN)) {
            supportedActionsVal |= 8;
        }
        if (supportedActions.contains((Object)OFActionType.SET_DL_SRC)) {
            supportedActionsVal |= 0x10;
        }
        if (supportedActions.contains((Object)OFActionType.SET_DL_DST)) {
            supportedActionsVal |= 0x20;
        }
        if (supportedActions.contains((Object)OFActionType.SET_NW_SRC)) {
            supportedActionsVal |= 0x40;
        }
        if (supportedActions.contains((Object)OFActionType.SET_NW_DST)) {
            supportedActionsVal |= 0x80;
        }
        if (supportedActions.contains((Object)OFActionType.SET_NW_TOS)) {
            supportedActionsVal |= 0x100;
        }
        if (supportedActions.contains((Object)OFActionType.SET_TP_SRC)) {
            supportedActionsVal |= 0x200;
        }
        if (supportedActions.contains((Object)OFActionType.SET_TP_DST)) {
            supportedActionsVal |= 0x400;
        }
        if (supportedActions.contains((Object)OFActionType.ENQUEUE)) {
            supportedActionsVal |= 0x800;
        }
        return supportedActionsVal;
    }

    public static void putSupportedActionsTo(Set<OFActionType> supportedActions, PrimitiveSink sink) {
        sink.putInt(ChannelUtilsVer10.supportedActionsToWire(supportedActions));
    }

    public static void writeSupportedActions(ChannelBuffer bb, Set<OFActionType> supportedActions) {
        bb.writeInt(ChannelUtilsVer10.supportedActionsToWire(supportedActions));
    }
}

