/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver10;

import com.google.common.collect.ImmutableSet;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import java.util.Set;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFAggregateStatsRequest;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFStatsRequestFlags;
import org.projectfloodlight.openflow.protocol.OFStatsType;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.Match;
import org.projectfloodlight.openflow.protocol.ver10.ChannelUtilsVer10;
import org.projectfloodlight.openflow.protocol.ver10.OFFactoryVer10;
import org.projectfloodlight.openflow.protocol.ver10.OFStatsRequestFlagsSerializerVer10;
import org.projectfloodlight.openflow.types.OFGroup;
import org.projectfloodlight.openflow.types.OFPort;
import org.projectfloodlight.openflow.types.TableId;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.types.U64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFAggregateStatsRequestVer10
implements OFAggregateStatsRequest {
    private static final Logger logger = LoggerFactory.getLogger(OFAggregateStatsRequestVer10.class);
    static final byte WIRE_VERSION = 1;
    static final int LENGTH = 56;
    private static final long DEFAULT_XID = 0L;
    private static final Set<OFStatsRequestFlags> DEFAULT_FLAGS = ImmutableSet.of();
    private static final Match DEFAULT_MATCH = OFFactoryVer10.MATCH_WILDCARD_ALL;
    private static final TableId DEFAULT_TABLE_ID = TableId.ALL;
    private static final OFPort DEFAULT_OUT_PORT = OFPort.ANY;
    private final long xid;
    private final Set<OFStatsRequestFlags> flags;
    private final Match match;
    private final TableId tableId;
    private final OFPort outPort;
    static final OFAggregateStatsRequestVer10 DEFAULT = new OFAggregateStatsRequestVer10(0L, DEFAULT_FLAGS, DEFAULT_MATCH, DEFAULT_TABLE_ID, DEFAULT_OUT_PORT);
    static final Reader READER = new Reader();
    static final OFAggregateStatsRequestVer10Funnel FUNNEL = new OFAggregateStatsRequestVer10Funnel();
    static final Writer WRITER = new Writer();

    OFAggregateStatsRequestVer10(long xid, Set<OFStatsRequestFlags> flags, Match match, TableId tableId, OFPort outPort) {
        if (flags == null) {
            throw new NullPointerException("OFAggregateStatsRequestVer10: property flags cannot be null");
        }
        if (match == null) {
            throw new NullPointerException("OFAggregateStatsRequestVer10: property match cannot be null");
        }
        if (tableId == null) {
            throw new NullPointerException("OFAggregateStatsRequestVer10: property tableId cannot be null");
        }
        if (outPort == null) {
            throw new NullPointerException("OFAggregateStatsRequestVer10: property outPort cannot be null");
        }
        this.xid = xid;
        this.flags = flags;
        this.match = match;
        this.tableId = tableId;
        this.outPort = outPort;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_10;
    }

    @Override
    public OFType getType() {
        return OFType.STATS_REQUEST;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public OFStatsType getStatsType() {
        return OFStatsType.AGGREGATE;
    }

    @Override
    public Set<OFStatsRequestFlags> getFlags() {
        return this.flags;
    }

    @Override
    public TableId getTableId() {
        return this.tableId;
    }

    @Override
    public OFPort getOutPort() {
        return this.outPort;
    }

    @Override
    public OFGroup getOutGroup() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property outGroup not supported in version 1.0");
    }

    @Override
    public U64 getCookie() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property cookie not supported in version 1.0");
    }

    @Override
    public U64 getCookieMask() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property cookieMask not supported in version 1.0");
    }

    @Override
    public Match getMatch() {
        return this.match;
    }

    @Override
    public OFAggregateStatsRequest.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFAggregateStatsRequestVer10(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("flags=").append(this.flags);
        b.append(", ");
        b.append("match=").append(this.match);
        b.append(", ");
        b.append("tableId=").append(this.tableId);
        b.append(", ");
        b.append("outPort=").append(this.outPort);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFAggregateStatsRequestVer10 other = (OFAggregateStatsRequestVer10)obj;
        if (this.xid != other.xid) {
            return false;
        }
        if (this.flags == null ? other.flags != null : !this.flags.equals(other.flags)) {
            return false;
        }
        if (this.match == null ? other.match != null : !this.match.equals(other.match)) {
            return false;
        }
        if (this.tableId == null ? other.tableId != null : !this.tableId.equals(other.tableId)) {
            return false;
        }
        return !(this.outPort == null ? other.outPort != null : !this.outPort.equals(other.outPort));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + (this.flags == null ? 0 : this.flags.hashCode());
        result = 31 * result + (this.match == null ? 0 : this.match.hashCode());
        result = 31 * result + (this.tableId == null ? 0 : this.tableId.hashCode());
        result = 31 * result + (this.outPort == null ? 0 : this.outPort.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFAggregateStatsRequestVer10> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFAggregateStatsRequestVer10 message) {
            bb.writeByte(1);
            bb.writeByte(16);
            bb.writeShort(56);
            bb.writeInt(U32.t(message.xid));
            bb.writeShort(2);
            OFStatsRequestFlagsSerializerVer10.writeTo(bb, message.flags);
            message.match.writeTo(bb);
            message.tableId.writeByte(bb);
            bb.writeZero(1);
            message.outPort.write2Bytes(bb);
        }
    }

    static class OFAggregateStatsRequestVer10Funnel
    implements Funnel<OFAggregateStatsRequestVer10> {
        private static final long serialVersionUID = 1L;

        OFAggregateStatsRequestVer10Funnel() {
        }

        public void funnel(OFAggregateStatsRequestVer10 message, PrimitiveSink sink) {
            sink.putByte((byte)1);
            sink.putByte((byte)16);
            sink.putShort((short)56);
            sink.putLong(message.xid);
            sink.putShort((short)2);
            OFStatsRequestFlagsSerializerVer10.putTo(message.flags, sink);
            message.match.putTo(sink);
            message.tableId.putTo(sink);
            message.outPort.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFAggregateStatsRequest> {
        Reader() {
        }

        @Override
        public OFAggregateStatsRequest readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 1) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_10(1), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 16) {
                throw new OFParseError("Wrong type: Expected=OFType.STATS_REQUEST(16), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 56) {
                throw new OFParseError("Wrong length: Expected=56(56), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            short statsType = bb.readShort();
            if (statsType != 2) {
                throw new OFParseError("Wrong statsType: Expected=OFStatsType.AGGREGATE(2), got=" + statsType);
            }
            Set<OFStatsRequestFlags> flags = OFStatsRequestFlagsSerializerVer10.readFrom(bb);
            Match match = ChannelUtilsVer10.readOFMatch(bb);
            TableId tableId = TableId.readByte(bb);
            bb.skipBytes(1);
            OFPort outPort = OFPort.read2Bytes(bb);
            OFAggregateStatsRequestVer10 aggregateStatsRequestVer10 = new OFAggregateStatsRequestVer10(xid, flags, match, tableId, outPort);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)aggregateStatsRequestVer10);
            }
            return aggregateStatsRequestVer10;
        }
    }

    static class Builder
    implements OFAggregateStatsRequest.Builder {
        private boolean xidSet;
        private long xid;
        private boolean flagsSet;
        private Set<OFStatsRequestFlags> flags;
        private boolean matchSet;
        private Match match;
        private boolean tableIdSet;
        private TableId tableId;
        private boolean outPortSet;
        private OFPort outPort;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_10;
        }

        @Override
        public OFType getType() {
            return OFType.STATS_REQUEST;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFAggregateStatsRequest.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFStatsType getStatsType() {
            return OFStatsType.AGGREGATE;
        }

        @Override
        public Set<OFStatsRequestFlags> getFlags() {
            return this.flags;
        }

        @Override
        public OFAggregateStatsRequest.Builder setFlags(Set<OFStatsRequestFlags> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public TableId getTableId() {
            return this.tableId;
        }

        @Override
        public OFAggregateStatsRequest.Builder setTableId(TableId tableId) {
            this.tableId = tableId;
            this.tableIdSet = true;
            return this;
        }

        @Override
        public OFPort getOutPort() {
            return this.outPort;
        }

        @Override
        public OFAggregateStatsRequest.Builder setOutPort(OFPort outPort) {
            this.outPort = outPort;
            this.outPortSet = true;
            return this;
        }

        @Override
        public OFGroup getOutGroup() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property outGroup not supported in version 1.0");
        }

        @Override
        public OFAggregateStatsRequest.Builder setOutGroup(OFGroup outGroup) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property outGroup not supported in version 1.0");
        }

        @Override
        public U64 getCookie() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property cookie not supported in version 1.0");
        }

        @Override
        public OFAggregateStatsRequest.Builder setCookie(U64 cookie) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property cookie not supported in version 1.0");
        }

        @Override
        public U64 getCookieMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property cookieMask not supported in version 1.0");
        }

        @Override
        public OFAggregateStatsRequest.Builder setCookieMask(U64 cookieMask) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property cookieMask not supported in version 1.0");
        }

        @Override
        public Match getMatch() {
            return this.match;
        }

        @Override
        public OFAggregateStatsRequest.Builder setMatch(Match match) {
            this.match = match;
            this.matchSet = true;
            return this;
        }

        @Override
        public OFAggregateStatsRequest build() {
            OFPort outPort;
            TableId tableId;
            Match match;
            Set<OFStatsRequestFlags> flags;
            long xid = this.xidSet ? this.xid : 0L;
            Set<OFStatsRequestFlags> set = flags = this.flagsSet ? this.flags : DEFAULT_FLAGS;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            Match match2 = match = this.matchSet ? this.match : DEFAULT_MATCH;
            if (match == null) {
                throw new NullPointerException("Property match must not be null");
            }
            TableId tableId2 = tableId = this.tableIdSet ? this.tableId : DEFAULT_TABLE_ID;
            if (tableId == null) {
                throw new NullPointerException("Property tableId must not be null");
            }
            OFPort oFPort = outPort = this.outPortSet ? this.outPort : DEFAULT_OUT_PORT;
            if (outPort == null) {
                throw new NullPointerException("Property outPort must not be null");
            }
            return new OFAggregateStatsRequestVer10(xid, flags, match, tableId, outPort);
        }
    }

    static class BuilderWithParent
    implements OFAggregateStatsRequest.Builder {
        final OFAggregateStatsRequestVer10 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean flagsSet;
        private Set<OFStatsRequestFlags> flags;
        private boolean matchSet;
        private Match match;
        private boolean tableIdSet;
        private TableId tableId;
        private boolean outPortSet;
        private OFPort outPort;

        BuilderWithParent(OFAggregateStatsRequestVer10 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_10;
        }

        @Override
        public OFType getType() {
            return OFType.STATS_REQUEST;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFAggregateStatsRequest.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFStatsType getStatsType() {
            return OFStatsType.AGGREGATE;
        }

        @Override
        public Set<OFStatsRequestFlags> getFlags() {
            return this.flags;
        }

        @Override
        public OFAggregateStatsRequest.Builder setFlags(Set<OFStatsRequestFlags> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public TableId getTableId() {
            return this.tableId;
        }

        @Override
        public OFAggregateStatsRequest.Builder setTableId(TableId tableId) {
            this.tableId = tableId;
            this.tableIdSet = true;
            return this;
        }

        @Override
        public OFPort getOutPort() {
            return this.outPort;
        }

        @Override
        public OFAggregateStatsRequest.Builder setOutPort(OFPort outPort) {
            this.outPort = outPort;
            this.outPortSet = true;
            return this;
        }

        @Override
        public OFGroup getOutGroup() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property outGroup not supported in version 1.0");
        }

        @Override
        public OFAggregateStatsRequest.Builder setOutGroup(OFGroup outGroup) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property outGroup not supported in version 1.0");
        }

        @Override
        public U64 getCookie() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property cookie not supported in version 1.0");
        }

        @Override
        public OFAggregateStatsRequest.Builder setCookie(U64 cookie) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property cookie not supported in version 1.0");
        }

        @Override
        public U64 getCookieMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property cookieMask not supported in version 1.0");
        }

        @Override
        public OFAggregateStatsRequest.Builder setCookieMask(U64 cookieMask) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property cookieMask not supported in version 1.0");
        }

        @Override
        public Match getMatch() {
            return this.match;
        }

        @Override
        public OFAggregateStatsRequest.Builder setMatch(Match match) {
            this.match = match;
            this.matchSet = true;
            return this;
        }

        @Override
        public OFAggregateStatsRequest build() {
            OFPort outPort;
            TableId tableId;
            Match match;
            Set flags;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            Set set = flags = this.flagsSet ? this.flags : this.parentMessage.flags;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            Match match2 = match = this.matchSet ? this.match : this.parentMessage.match;
            if (match == null) {
                throw new NullPointerException("Property match must not be null");
            }
            TableId tableId2 = tableId = this.tableIdSet ? this.tableId : this.parentMessage.tableId;
            if (tableId == null) {
                throw new NullPointerException("Property tableId must not be null");
            }
            OFPort oFPort = outPort = this.outPortSet ? this.outPort : this.parentMessage.outPort;
            if (outPort == null) {
                throw new NullPointerException("Property outPort must not be null");
            }
            return new OFAggregateStatsRequestVer10(xid, flags, match, tableId, outPort);
        }
    }
}

