/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver10;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnGetIpMaskRequest;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.types.U8;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnGetIpMaskRequestVer10
implements OFBsnGetIpMaskRequest {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnGetIpMaskRequestVer10.class);
    static final byte WIRE_VERSION = 1;
    static final int LENGTH = 24;
    private static final long DEFAULT_XID = 0L;
    private static final short DEFAULT_INDEX = 0;
    private final long xid;
    private final short index;
    static final OFBsnGetIpMaskRequestVer10 DEFAULT = new OFBsnGetIpMaskRequestVer10(0L, 0);
    static final Reader READER = new Reader();
    static final OFBsnGetIpMaskRequestVer10Funnel FUNNEL = new OFBsnGetIpMaskRequestVer10Funnel();
    static final Writer WRITER = new Writer();

    OFBsnGetIpMaskRequestVer10(long xid, short index) {
        this.xid = xid;
        this.index = index;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_10;
    }

    @Override
    public OFType getType() {
        return OFType.EXPERIMENTER;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public long getExperimenter() {
        return 6035143L;
    }

    @Override
    public long getSubtype() {
        return 1L;
    }

    @Override
    public short getIndex() {
        return this.index;
    }

    @Override
    public OFBsnGetIpMaskRequest.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnGetIpMaskRequestVer10(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("index=").append(this.index);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnGetIpMaskRequestVer10 other = (OFBsnGetIpMaskRequestVer10)obj;
        if (this.xid != other.xid) {
            return false;
        }
        return this.index == other.index;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + this.index;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnGetIpMaskRequestVer10> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFBsnGetIpMaskRequestVer10 message) {
            bb.writeByte(1);
            bb.writeByte(4);
            bb.writeShort(24);
            bb.writeInt(U32.t(message.xid));
            bb.writeInt(6035143);
            bb.writeInt(1);
            bb.writeByte((int)U8.t(message.index));
            bb.writeZero(7);
        }
    }

    static class OFBsnGetIpMaskRequestVer10Funnel
    implements Funnel<OFBsnGetIpMaskRequestVer10> {
        private static final long serialVersionUID = 1L;

        OFBsnGetIpMaskRequestVer10Funnel() {
        }

        public void funnel(OFBsnGetIpMaskRequestVer10 message, PrimitiveSink sink) {
            sink.putByte((byte)1);
            sink.putByte((byte)4);
            sink.putShort((short)24);
            sink.putLong(message.xid);
            sink.putInt(6035143);
            sink.putInt(1);
            sink.putShort(message.index);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnGetIpMaskRequest> {
        Reader() {
        }

        @Override
        public OFBsnGetIpMaskRequest readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 1) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_10(1), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 4) {
                throw new OFParseError("Wrong type: Expected=OFType.EXPERIMENTER(4), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 24) {
                throw new OFParseError("Wrong length: Expected=24(24), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            int experimenter = bb.readInt();
            if (experimenter != 6035143) {
                throw new OFParseError("Wrong experimenter: Expected=0x5c16c7L(0x5c16c7L), got=" + experimenter);
            }
            int subtype = bb.readInt();
            if (subtype != 1) {
                throw new OFParseError("Wrong subtype: Expected=0x1L(0x1L), got=" + subtype);
            }
            short index = U8.f(bb.readByte());
            bb.skipBytes(7);
            OFBsnGetIpMaskRequestVer10 bsnGetIpMaskRequestVer10 = new OFBsnGetIpMaskRequestVer10(xid, index);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnGetIpMaskRequestVer10);
            }
            return bsnGetIpMaskRequestVer10;
        }
    }

    static class Builder
    implements OFBsnGetIpMaskRequest.Builder {
        private boolean xidSet;
        private long xid;
        private boolean indexSet;
        private short index;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_10;
        }

        @Override
        public OFType getType() {
            return OFType.EXPERIMENTER;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnGetIpMaskRequest.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 1L;
        }

        @Override
        public short getIndex() {
            return this.index;
        }

        @Override
        public OFBsnGetIpMaskRequest.Builder setIndex(short index) {
            this.index = index;
            this.indexSet = true;
            return this;
        }

        @Override
        public OFBsnGetIpMaskRequest build() {
            long xid = this.xidSet ? this.xid : 0L;
            short index = this.indexSet ? this.index : (short)0;
            return new OFBsnGetIpMaskRequestVer10(xid, index);
        }
    }

    static class BuilderWithParent
    implements OFBsnGetIpMaskRequest.Builder {
        final OFBsnGetIpMaskRequestVer10 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean indexSet;
        private short index;

        BuilderWithParent(OFBsnGetIpMaskRequestVer10 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_10;
        }

        @Override
        public OFType getType() {
            return OFType.EXPERIMENTER;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnGetIpMaskRequest.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 1L;
        }

        @Override
        public short getIndex() {
            return this.index;
        }

        @Override
        public OFBsnGetIpMaskRequest.Builder setIndex(short index) {
            this.index = index;
            this.indexSet = true;
            return this;
        }

        @Override
        public OFBsnGetIpMaskRequest build() {
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            short index = this.indexSet ? this.index : this.parentMessage.index;
            return new OFBsnGetIpMaskRequestVer10(xid, index);
        }
    }
}

