/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver10;

import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFErrorMsg;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.ver10.OFBadActionErrorMsgVer10;
import org.projectfloodlight.openflow.protocol.ver10.OFBadRequestErrorMsgVer10;
import org.projectfloodlight.openflow.protocol.ver10.OFFlowModFailedErrorMsgVer10;
import org.projectfloodlight.openflow.protocol.ver10.OFHelloFailedErrorMsgVer10;
import org.projectfloodlight.openflow.protocol.ver10.OFPortModFailedErrorMsgVer10;
import org.projectfloodlight.openflow.protocol.ver10.OFQueueOpFailedErrorMsgVer10;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;

abstract class OFErrorMsgVer10 {
    static final byte WIRE_VERSION = 1;
    static final int MINIMUM_LENGTH = 10;
    public static final Reader READER = new Reader();

    OFErrorMsgVer10() {
    }

    static class Reader
    implements OFMessageReader<OFErrorMsg> {
        Reader() {
        }

        @Override
        public OFErrorMsg readFrom(ChannelBuffer bb) throws OFParseError {
            if (bb.readableBytes() < 10) {
                return null;
            }
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 1) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_10(1), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 1) {
                throw new OFParseError("Wrong type: Expected=OFType.ERROR(1), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 10) {
                throw new OFParseError("Wrong length: Expected to be >= 10, was: " + length);
            }
            U32.f(bb.readInt());
            short errType = bb.readShort();
            bb.readerIndex(start);
            switch (errType) {
                case 2: {
                    return OFBadActionErrorMsgVer10.READER.readFrom(bb);
                }
                case 1: {
                    return OFBadRequestErrorMsgVer10.READER.readFrom(bb);
                }
                case 3: {
                    return OFFlowModFailedErrorMsgVer10.READER.readFrom(bb);
                }
                case 0: {
                    return OFHelloFailedErrorMsgVer10.READER.readFrom(bb);
                }
                case 4: {
                    return OFPortModFailedErrorMsgVer10.READER.readFrom(bb);
                }
                case 5: {
                    return OFQueueOpFailedErrorMsgVer10.READER.readFrom(bb);
                }
            }
            throw new OFParseError("Unknown value for discriminator errType of class OFErrorMsgVer10: " + errType);
        }
    }
}

