/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver10;

import com.google.common.collect.ImmutableList;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import java.util.List;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFPacketQueue;
import org.projectfloodlight.openflow.protocol.OFQueueGetConfigReply;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.ver10.OFPacketQueueVer10;
import org.projectfloodlight.openflow.types.OFPort;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.projectfloodlight.openflow.util.FunnelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFQueueGetConfigReplyVer10
implements OFQueueGetConfigReply {
    private static final Logger logger = LoggerFactory.getLogger(OFQueueGetConfigReplyVer10.class);
    static final byte WIRE_VERSION = 1;
    static final int MINIMUM_LENGTH = 16;
    private static final long DEFAULT_XID = 0L;
    private static final OFPort DEFAULT_PORT = OFPort.ANY;
    private static final List<OFPacketQueue> DEFAULT_QUEUES = ImmutableList.of();
    private final long xid;
    private final OFPort port;
    private final List<OFPacketQueue> queues;
    static final OFQueueGetConfigReplyVer10 DEFAULT = new OFQueueGetConfigReplyVer10(0L, DEFAULT_PORT, DEFAULT_QUEUES);
    static final Reader READER = new Reader();
    static final OFQueueGetConfigReplyVer10Funnel FUNNEL = new OFQueueGetConfigReplyVer10Funnel();
    static final Writer WRITER = new Writer();

    OFQueueGetConfigReplyVer10(long xid, OFPort port, List<OFPacketQueue> queues) {
        if (port == null) {
            throw new NullPointerException("OFQueueGetConfigReplyVer10: property port cannot be null");
        }
        if (queues == null) {
            throw new NullPointerException("OFQueueGetConfigReplyVer10: property queues cannot be null");
        }
        this.xid = xid;
        this.port = port;
        this.queues = queues;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_10;
    }

    @Override
    public OFType getType() {
        return OFType.QUEUE_GET_CONFIG_REPLY;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public OFPort getPort() {
        return this.port;
    }

    @Override
    public List<OFPacketQueue> getQueues() {
        return this.queues;
    }

    @Override
    public OFQueueGetConfigReply.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFQueueGetConfigReplyVer10(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("port=").append(this.port);
        b.append(", ");
        b.append("queues=").append(this.queues);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFQueueGetConfigReplyVer10 other = (OFQueueGetConfigReplyVer10)obj;
        if (this.xid != other.xid) {
            return false;
        }
        if (this.port == null ? other.port != null : !this.port.equals(other.port)) {
            return false;
        }
        return !(this.queues == null ? other.queues != null : !this.queues.equals(other.queues));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + (this.port == null ? 0 : this.port.hashCode());
        result = 31 * result + (this.queues == null ? 0 : this.queues.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFQueueGetConfigReplyVer10> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFQueueGetConfigReplyVer10 message) {
            int startIndex = bb.writerIndex();
            bb.writeByte(1);
            bb.writeByte(21);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            bb.writeInt(U32.t(message.xid));
            message.port.write2Bytes(bb);
            bb.writeZero(6);
            ChannelUtils.writeList(bb, message.queues);
            int length = bb.writerIndex() - startIndex;
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFQueueGetConfigReplyVer10Funnel
    implements Funnel<OFQueueGetConfigReplyVer10> {
        private static final long serialVersionUID = 1L;

        OFQueueGetConfigReplyVer10Funnel() {
        }

        public void funnel(OFQueueGetConfigReplyVer10 message, PrimitiveSink sink) {
            sink.putByte((byte)1);
            sink.putByte((byte)21);
            sink.putLong(message.xid);
            message.port.putTo(sink);
            FunnelUtils.putList(message.queues, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFQueueGetConfigReply> {
        Reader() {
        }

        @Override
        public OFQueueGetConfigReply readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 1) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_10(1), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 21) {
                throw new OFParseError("Wrong type: Expected=OFType.QUEUE_GET_CONFIG_REPLY(21), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 16) {
                throw new OFParseError("Wrong length: Expected to be >= 16, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            OFPort port = OFPort.read2Bytes(bb);
            bb.skipBytes(6);
            List<OFPacketQueue> queues = ChannelUtils.readList(bb, length - (bb.readerIndex() - start), OFPacketQueueVer10.READER);
            OFQueueGetConfigReplyVer10 queueGetConfigReplyVer10 = new OFQueueGetConfigReplyVer10(xid, port, queues);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)queueGetConfigReplyVer10);
            }
            return queueGetConfigReplyVer10;
        }
    }

    static class Builder
    implements OFQueueGetConfigReply.Builder {
        private boolean xidSet;
        private long xid;
        private boolean portSet;
        private OFPort port;
        private boolean queuesSet;
        private List<OFPacketQueue> queues;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_10;
        }

        @Override
        public OFType getType() {
            return OFType.QUEUE_GET_CONFIG_REPLY;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFQueueGetConfigReply.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFPort getPort() {
            return this.port;
        }

        @Override
        public OFQueueGetConfigReply.Builder setPort(OFPort port) {
            this.port = port;
            this.portSet = true;
            return this;
        }

        @Override
        public List<OFPacketQueue> getQueues() {
            return this.queues;
        }

        @Override
        public OFQueueGetConfigReply.Builder setQueues(List<OFPacketQueue> queues) {
            this.queues = queues;
            this.queuesSet = true;
            return this;
        }

        @Override
        public OFQueueGetConfigReply build() {
            List<OFPacketQueue> queues;
            OFPort port;
            long xid = this.xidSet ? this.xid : 0L;
            OFPort oFPort = port = this.portSet ? this.port : DEFAULT_PORT;
            if (port == null) {
                throw new NullPointerException("Property port must not be null");
            }
            List<OFPacketQueue> list = queues = this.queuesSet ? this.queues : DEFAULT_QUEUES;
            if (queues == null) {
                throw new NullPointerException("Property queues must not be null");
            }
            return new OFQueueGetConfigReplyVer10(xid, port, queues);
        }
    }

    static class BuilderWithParent
    implements OFQueueGetConfigReply.Builder {
        final OFQueueGetConfigReplyVer10 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean portSet;
        private OFPort port;
        private boolean queuesSet;
        private List<OFPacketQueue> queues;

        BuilderWithParent(OFQueueGetConfigReplyVer10 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_10;
        }

        @Override
        public OFType getType() {
            return OFType.QUEUE_GET_CONFIG_REPLY;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFQueueGetConfigReply.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFPort getPort() {
            return this.port;
        }

        @Override
        public OFQueueGetConfigReply.Builder setPort(OFPort port) {
            this.port = port;
            this.portSet = true;
            return this;
        }

        @Override
        public List<OFPacketQueue> getQueues() {
            return this.queues;
        }

        @Override
        public OFQueueGetConfigReply.Builder setQueues(List<OFPacketQueue> queues) {
            this.queues = queues;
            this.queuesSet = true;
            return this;
        }

        @Override
        public OFQueueGetConfigReply build() {
            List queues;
            OFPort port;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            OFPort oFPort = port = this.portSet ? this.port : this.parentMessage.port;
            if (port == null) {
                throw new NullPointerException("Property port must not be null");
            }
            List list = queues = this.queuesSet ? this.queues : this.parentMessage.queues;
            if (queues == null) {
                throw new NullPointerException("Property queues must not be null");
            }
            return new OFQueueGetConfigReplyVer10(xid, port, queues);
        }
    }
}

