/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver11;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFActionType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.action.OFActionGroup;
import org.projectfloodlight.openflow.types.OFGroup;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFActionGroupVer11
implements OFActionGroup {
    private static final Logger logger = LoggerFactory.getLogger(OFActionGroupVer11.class);
    static final byte WIRE_VERSION = 2;
    static final int LENGTH = 8;
    private static final OFGroup DEFAULT_GROUP_ID = OFGroup.ALL;
    private final OFGroup group;
    static final OFActionGroupVer11 DEFAULT = new OFActionGroupVer11(DEFAULT_GROUP_ID);
    static final Reader READER = new Reader();
    static final OFActionGroupVer11Funnel FUNNEL = new OFActionGroupVer11Funnel();
    static final Writer WRITER = new Writer();

    OFActionGroupVer11(OFGroup group) {
        if (group == null) {
            throw new NullPointerException("OFActionGroupVer11: property group cannot be null");
        }
        this.group = group;
    }

    @Override
    public OFActionType getType() {
        return OFActionType.GROUP;
    }

    @Override
    public OFGroup getGroup() {
        return this.group;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_11;
    }

    @Override
    public OFActionGroup.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFActionGroupVer11(");
        b.append("group=").append(this.group);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFActionGroupVer11 other = (OFActionGroupVer11)obj;
        return !(this.group == null ? other.group != null : !this.group.equals(other.group));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.group == null ? 0 : this.group.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFActionGroupVer11> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFActionGroupVer11 message) {
            bb.writeShort(22);
            bb.writeShort(8);
            message.group.write4Bytes(bb);
        }
    }

    static class OFActionGroupVer11Funnel
    implements Funnel<OFActionGroupVer11> {
        private static final long serialVersionUID = 1L;

        OFActionGroupVer11Funnel() {
        }

        public void funnel(OFActionGroupVer11 message, PrimitiveSink sink) {
            sink.putShort((short)22);
            sink.putShort((short)8);
            message.group.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFActionGroup> {
        Reader() {
        }

        @Override
        public OFActionGroup readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 22) {
                throw new OFParseError("Wrong type: Expected=OFActionType.GROUP(22), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            OFGroup group = OFGroup.read4Bytes(bb);
            OFActionGroupVer11 actionGroupVer11 = new OFActionGroupVer11(group);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)actionGroupVer11);
            }
            return actionGroupVer11;
        }
    }

    static class Builder
    implements OFActionGroup.Builder {
        private boolean groupSet;
        private OFGroup group;

        Builder() {
        }

        @Override
        public OFActionType getType() {
            return OFActionType.GROUP;
        }

        @Override
        public OFGroup getGroup() {
            return this.group;
        }

        @Override
        public OFActionGroup.Builder setGroup(OFGroup group) {
            this.group = group;
            this.groupSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_11;
        }

        @Override
        public OFActionGroup build() {
            OFGroup group;
            OFGroup oFGroup = group = this.groupSet ? this.group : DEFAULT_GROUP_ID;
            if (group == null) {
                throw new NullPointerException("Property group must not be null");
            }
            return new OFActionGroupVer11(group);
        }
    }

    static class BuilderWithParent
    implements OFActionGroup.Builder {
        final OFActionGroupVer11 parentMessage;
        private boolean groupSet;
        private OFGroup group;

        BuilderWithParent(OFActionGroupVer11 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFActionType getType() {
            return OFActionType.GROUP;
        }

        @Override
        public OFGroup getGroup() {
            return this.group;
        }

        @Override
        public OFActionGroup.Builder setGroup(OFGroup group) {
            this.group = group;
            this.groupSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_11;
        }

        @Override
        public OFActionGroup build() {
            OFGroup group;
            OFGroup oFGroup = group = this.groupSet ? this.group : this.parentMessage.group;
            if (group == null) {
                throw new NullPointerException("Property group must not be null");
            }
            return new OFActionGroupVer11(group);
        }
    }
}

