/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver12;

import com.google.common.collect.ImmutableList;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import java.util.List;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBucket;
import org.projectfloodlight.openflow.protocol.OFGroupAdd;
import org.projectfloodlight.openflow.protocol.OFGroupModCommand;
import org.projectfloodlight.openflow.protocol.OFGroupType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.ver12.OFBucketVer12;
import org.projectfloodlight.openflow.protocol.ver12.OFGroupTypeSerializerVer12;
import org.projectfloodlight.openflow.types.OFGroup;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.projectfloodlight.openflow.util.FunnelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFGroupAddVer12
implements OFGroupAdd {
    private static final Logger logger = LoggerFactory.getLogger(OFGroupAddVer12.class);
    static final byte WIRE_VERSION = 3;
    static final int MINIMUM_LENGTH = 16;
    private static final long DEFAULT_XID = 0L;
    private static final OFGroup DEFAULT_GROUP_ID = OFGroup.ALL;
    private static final List<OFBucket> DEFAULT_BUCKETS = ImmutableList.of();
    private final long xid;
    private final OFGroupType groupType;
    private final OFGroup group;
    private final List<OFBucket> buckets;
    static final Reader READER = new Reader();
    static final OFGroupAddVer12Funnel FUNNEL = new OFGroupAddVer12Funnel();
    static final Writer WRITER = new Writer();

    OFGroupAddVer12(long xid, OFGroupType groupType, OFGroup group, List<OFBucket> buckets) {
        if (groupType == null) {
            throw new NullPointerException("OFGroupAddVer12: property groupType cannot be null");
        }
        if (group == null) {
            throw new NullPointerException("OFGroupAddVer12: property group cannot be null");
        }
        if (buckets == null) {
            throw new NullPointerException("OFGroupAddVer12: property buckets cannot be null");
        }
        this.xid = xid;
        this.groupType = groupType;
        this.group = group;
        this.buckets = buckets;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_12;
    }

    @Override
    public OFType getType() {
        return OFType.GROUP_MOD;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public OFGroupModCommand getCommand() {
        return OFGroupModCommand.ADD;
    }

    @Override
    public OFGroupType getGroupType() {
        return this.groupType;
    }

    @Override
    public OFGroup getGroup() {
        return this.group;
    }

    @Override
    public List<OFBucket> getBuckets() {
        return this.buckets;
    }

    @Override
    public OFGroupAdd.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFGroupAddVer12(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("groupType=").append((Object)this.groupType);
        b.append(", ");
        b.append("group=").append(this.group);
        b.append(", ");
        b.append("buckets=").append(this.buckets);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFGroupAddVer12 other = (OFGroupAddVer12)obj;
        if (this.xid != other.xid) {
            return false;
        }
        if (this.groupType == null ? other.groupType != null : !this.groupType.equals((Object)other.groupType)) {
            return false;
        }
        if (this.group == null ? other.group != null : !this.group.equals(other.group)) {
            return false;
        }
        return !(this.buckets == null ? other.buckets != null : !this.buckets.equals(other.buckets));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + (this.groupType == null ? 0 : this.groupType.hashCode());
        result = 31 * result + (this.group == null ? 0 : this.group.hashCode());
        result = 31 * result + (this.buckets == null ? 0 : this.buckets.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFGroupAddVer12> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFGroupAddVer12 message) {
            int startIndex = bb.writerIndex();
            bb.writeByte(3);
            bb.writeByte(15);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            bb.writeInt(U32.t(message.xid));
            bb.writeShort(0);
            OFGroupTypeSerializerVer12.writeTo(bb, message.groupType);
            bb.writeZero(1);
            message.group.write4Bytes(bb);
            ChannelUtils.writeList(bb, message.buckets);
            int length = bb.writerIndex() - startIndex;
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFGroupAddVer12Funnel
    implements Funnel<OFGroupAddVer12> {
        private static final long serialVersionUID = 1L;

        OFGroupAddVer12Funnel() {
        }

        public void funnel(OFGroupAddVer12 message, PrimitiveSink sink) {
            sink.putByte((byte)3);
            sink.putByte((byte)15);
            sink.putLong(message.xid);
            sink.putShort((short)0);
            OFGroupTypeSerializerVer12.putTo(message.groupType, sink);
            message.group.putTo(sink);
            FunnelUtils.putList(message.buckets, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFGroupAdd> {
        Reader() {
        }

        @Override
        public OFGroupAdd readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 3) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_12(3), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 15) {
                throw new OFParseError("Wrong type: Expected=OFType.GROUP_MOD(15), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 16) {
                throw new OFParseError("Wrong length: Expected to be >= 16, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            short command = bb.readShort();
            if (command != 0) {
                throw new OFParseError("Wrong command: Expected=OFGroupModCommand.ADD(0), got=" + command);
            }
            OFGroupType groupType = OFGroupTypeSerializerVer12.readFrom(bb);
            bb.skipBytes(1);
            OFGroup group = OFGroup.read4Bytes(bb);
            List<OFBucket> buckets = ChannelUtils.readList(bb, length - (bb.readerIndex() - start), OFBucketVer12.READER);
            OFGroupAddVer12 groupAddVer12 = new OFGroupAddVer12(xid, groupType, group, buckets);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)groupAddVer12);
            }
            return groupAddVer12;
        }
    }

    static class Builder
    implements OFGroupAdd.Builder {
        private boolean xidSet;
        private long xid;
        private boolean groupTypeSet;
        private OFGroupType groupType;
        private boolean groupSet;
        private OFGroup group;
        private boolean bucketsSet;
        private List<OFBucket> buckets;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_12;
        }

        @Override
        public OFType getType() {
            return OFType.GROUP_MOD;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFGroupAdd.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFGroupModCommand getCommand() {
            return OFGroupModCommand.ADD;
        }

        @Override
        public OFGroupType getGroupType() {
            return this.groupType;
        }

        @Override
        public OFGroupAdd.Builder setGroupType(OFGroupType groupType) {
            this.groupType = groupType;
            this.groupTypeSet = true;
            return this;
        }

        @Override
        public OFGroup getGroup() {
            return this.group;
        }

        @Override
        public OFGroupAdd.Builder setGroup(OFGroup group) {
            this.group = group;
            this.groupSet = true;
            return this;
        }

        @Override
        public List<OFBucket> getBuckets() {
            return this.buckets;
        }

        @Override
        public OFGroupAdd.Builder setBuckets(List<OFBucket> buckets) {
            this.buckets = buckets;
            this.bucketsSet = true;
            return this;
        }

        @Override
        public OFGroupAdd build() {
            List<OFBucket> buckets;
            OFGroup group;
            long xid;
            long l = xid = this.xidSet ? this.xid : 0L;
            if (!this.groupTypeSet) {
                throw new IllegalStateException("Property groupType doesn't have default value -- must be set");
            }
            if (this.groupType == null) {
                throw new NullPointerException("Property groupType must not be null");
            }
            OFGroup oFGroup = group = this.groupSet ? this.group : DEFAULT_GROUP_ID;
            if (group == null) {
                throw new NullPointerException("Property group must not be null");
            }
            List<OFBucket> list = buckets = this.bucketsSet ? this.buckets : DEFAULT_BUCKETS;
            if (buckets == null) {
                throw new NullPointerException("Property buckets must not be null");
            }
            return new OFGroupAddVer12(xid, this.groupType, group, buckets);
        }
    }

    static class BuilderWithParent
    implements OFGroupAdd.Builder {
        final OFGroupAddVer12 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean groupTypeSet;
        private OFGroupType groupType;
        private boolean groupSet;
        private OFGroup group;
        private boolean bucketsSet;
        private List<OFBucket> buckets;

        BuilderWithParent(OFGroupAddVer12 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_12;
        }

        @Override
        public OFType getType() {
            return OFType.GROUP_MOD;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFGroupAdd.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFGroupModCommand getCommand() {
            return OFGroupModCommand.ADD;
        }

        @Override
        public OFGroupType getGroupType() {
            return this.groupType;
        }

        @Override
        public OFGroupAdd.Builder setGroupType(OFGroupType groupType) {
            this.groupType = groupType;
            this.groupTypeSet = true;
            return this;
        }

        @Override
        public OFGroup getGroup() {
            return this.group;
        }

        @Override
        public OFGroupAdd.Builder setGroup(OFGroup group) {
            this.group = group;
            this.groupSet = true;
            return this;
        }

        @Override
        public List<OFBucket> getBuckets() {
            return this.buckets;
        }

        @Override
        public OFGroupAdd.Builder setBuckets(List<OFBucket> buckets) {
            this.buckets = buckets;
            this.bucketsSet = true;
            return this;
        }

        @Override
        public OFGroupAdd build() {
            List buckets;
            OFGroup group;
            OFGroupType groupType;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            OFGroupType oFGroupType = groupType = this.groupTypeSet ? this.groupType : this.parentMessage.groupType;
            if (groupType == null) {
                throw new NullPointerException("Property groupType must not be null");
            }
            OFGroup oFGroup = group = this.groupSet ? this.group : this.parentMessage.group;
            if (group == null) {
                throw new NullPointerException("Property group must not be null");
            }
            List list = buckets = this.bucketsSet ? this.buckets : this.parentMessage.buckets;
            if (buckets == null) {
                throw new NullPointerException("Property buckets must not be null");
            }
            return new OFGroupAddVer12(xid, groupType, group, buckets);
        }
    }
}

