/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver12;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmVlanPcpMasked;
import org.projectfloodlight.openflow.protocol.ver12.OFOxmVlanPcpVer12;
import org.projectfloodlight.openflow.types.VlanPcp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmVlanPcpMaskedVer12
implements OFOxmVlanPcpMasked {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmVlanPcpMaskedVer12.class);
    static final byte WIRE_VERSION = 3;
    static final int LENGTH = 6;
    private static final VlanPcp DEFAULT_VALUE = VlanPcp.NONE;
    private static final VlanPcp DEFAULT_VALUE_MASK = VlanPcp.NONE;
    private final VlanPcp value;
    private final VlanPcp mask;
    static final OFOxmVlanPcpMaskedVer12 DEFAULT = new OFOxmVlanPcpMaskedVer12(DEFAULT_VALUE, DEFAULT_VALUE_MASK);
    static final Reader READER = new Reader();
    static final OFOxmVlanPcpMaskedVer12Funnel FUNNEL = new OFOxmVlanPcpMaskedVer12Funnel();
    static final Writer WRITER = new Writer();

    OFOxmVlanPcpMaskedVer12(VlanPcp value, VlanPcp mask) {
        if (value == null) {
            throw new NullPointerException("OFOxmVlanPcpMaskedVer12: property value cannot be null");
        }
        if (mask == null) {
            throw new NullPointerException("OFOxmVlanPcpMaskedVer12: property mask cannot be null");
        }
        this.value = value;
        this.mask = mask;
    }

    @Override
    public long getTypeLen() {
        return 2147487490L;
    }

    @Override
    public VlanPcp getValue() {
        return this.value;
    }

    @Override
    public VlanPcp getMask() {
        return this.mask;
    }

    @Override
    public MatchField<VlanPcp> getMatchField() {
        return MatchField.VLAN_PCP;
    }

    @Override
    public boolean isMasked() {
        return true;
    }

    @Override
    public OFOxm<VlanPcp> getCanonical() {
        if (VlanPcp.NO_MASK.equals(this.mask)) {
            return new OFOxmVlanPcpVer12(this.value);
        }
        if (VlanPcp.FULL_MASK.equals(this.mask)) {
            return null;
        }
        return this;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_12;
    }

    @Override
    public OFOxmVlanPcpMasked.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmVlanPcpMaskedVer12(");
        b.append("value=").append(this.value);
        b.append(", ");
        b.append("mask=").append(this.mask);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmVlanPcpMaskedVer12 other = (OFOxmVlanPcpMaskedVer12)obj;
        if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
            return false;
        }
        return !(this.mask == null ? other.mask != null : !this.mask.equals(other.mask));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        result = 31 * result + (this.mask == null ? 0 : this.mask.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmVlanPcpMaskedVer12> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFOxmVlanPcpMaskedVer12 message) {
            bb.writeInt(-2147479806);
            message.value.writeByte(bb);
            message.mask.writeByte(bb);
        }
    }

    static class OFOxmVlanPcpMaskedVer12Funnel
    implements Funnel<OFOxmVlanPcpMaskedVer12> {
        private static final long serialVersionUID = 1L;

        OFOxmVlanPcpMaskedVer12Funnel() {
        }

        public void funnel(OFOxmVlanPcpMaskedVer12 message, PrimitiveSink sink) {
            sink.putInt(-2147479806);
            message.value.putTo(sink);
            message.mask.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmVlanPcpMasked> {
        Reader() {
        }

        @Override
        public OFOxmVlanPcpMasked readFrom(ChannelBuffer bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != -2147479806) {
                throw new OFParseError("Wrong typeLen: Expected=0x80000f02L(0x80000f02L), got=" + typeLen);
            }
            VlanPcp value = VlanPcp.readByte(bb);
            VlanPcp mask = VlanPcp.readByte(bb);
            OFOxmVlanPcpMaskedVer12 oxmVlanPcpMaskedVer12 = new OFOxmVlanPcpMaskedVer12(value, mask);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmVlanPcpMaskedVer12);
            }
            return oxmVlanPcpMaskedVer12;
        }
    }

    static class Builder
    implements OFOxmVlanPcpMasked.Builder {
        private boolean valueSet;
        private VlanPcp value;
        private boolean maskSet;
        private VlanPcp mask;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 2147487490L;
        }

        @Override
        public VlanPcp getValue() {
            return this.value;
        }

        @Override
        public OFOxmVlanPcpMasked.Builder setValue(VlanPcp value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public VlanPcp getMask() {
            return this.mask;
        }

        @Override
        public OFOxmVlanPcpMasked.Builder setMask(VlanPcp mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public MatchField<VlanPcp> getMatchField() {
            return MatchField.VLAN_PCP;
        }

        @Override
        public boolean isMasked() {
            return true;
        }

        @Override
        public OFOxm<VlanPcp> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.2");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_12;
        }

        @Override
        public OFOxmVlanPcpMasked build() {
            VlanPcp mask;
            VlanPcp value;
            VlanPcp vlanPcp = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            VlanPcp vlanPcp2 = mask = this.maskSet ? this.mask : DEFAULT_VALUE_MASK;
            if (mask == null) {
                throw new NullPointerException("Property mask must not be null");
            }
            return new OFOxmVlanPcpMaskedVer12(value, mask);
        }
    }

    static class BuilderWithParent
    implements OFOxmVlanPcpMasked.Builder {
        final OFOxmVlanPcpMaskedVer12 parentMessage;
        private boolean valueSet;
        private VlanPcp value;
        private boolean maskSet;
        private VlanPcp mask;

        BuilderWithParent(OFOxmVlanPcpMaskedVer12 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 2147487490L;
        }

        @Override
        public VlanPcp getValue() {
            return this.value;
        }

        @Override
        public OFOxmVlanPcpMasked.Builder setValue(VlanPcp value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public VlanPcp getMask() {
            return this.mask;
        }

        @Override
        public OFOxmVlanPcpMasked.Builder setMask(VlanPcp mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public MatchField<VlanPcp> getMatchField() {
            return MatchField.VLAN_PCP;
        }

        @Override
        public boolean isMasked() {
            return true;
        }

        @Override
        public OFOxm<VlanPcp> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.2");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_12;
        }

        @Override
        public OFOxmVlanPcpMasked build() {
            VlanPcp mask;
            VlanPcp value;
            VlanPcp vlanPcp = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            VlanPcp vlanPcp2 = mask = this.maskSet ? this.mask : this.parentMessage.mask;
            if (mask == null) {
                throw new NullPointerException("Property mask must not be null");
            }
            return new OFOxmVlanPcpMaskedVer12(value, mask);
        }
    }
}

