/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFActionType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.actionid.OFActionIdPushPbb;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFActionIdPushPbbVer13
implements OFActionIdPushPbb {
    private static final Logger logger = LoggerFactory.getLogger(OFActionIdPushPbbVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 4;
    static final OFActionIdPushPbbVer13 DEFAULT = new OFActionIdPushPbbVer13();
    static final OFActionIdPushPbbVer13 INSTANCE = new OFActionIdPushPbbVer13();
    static final Reader READER = new Reader();
    static final OFActionIdPushPbbVer13Funnel FUNNEL = new OFActionIdPushPbbVer13Funnel();
    static final Writer WRITER = new Writer();

    private OFActionIdPushPbbVer13() {
    }

    @Override
    public OFActionType getType() {
        return OFActionType.PUSH_PBB;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFActionIdPushPbb.Builder createBuilder() {
        throw new UnsupportedOperationException("OFActionIdPushPbbVer13 has no mutable properties -- builder unneeded");
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFActionIdPushPbbVer13(");
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }

    public int hashCode() {
        int result = 1;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFActionIdPushPbbVer13> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFActionIdPushPbbVer13 message) {
            bb.writeShort(26);
            bb.writeShort(4);
        }
    }

    static class OFActionIdPushPbbVer13Funnel
    implements Funnel<OFActionIdPushPbbVer13> {
        private static final long serialVersionUID = 1L;

        OFActionIdPushPbbVer13Funnel() {
        }

        public void funnel(OFActionIdPushPbbVer13 message, PrimitiveSink sink) {
            sink.putShort((short)26);
            sink.putShort((short)4);
        }
    }

    static class Reader
    implements OFMessageReader<OFActionIdPushPbb> {
        Reader() {
        }

        @Override
        public OFActionIdPushPbb readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 26) {
                throw new OFParseError("Wrong type: Expected=OFActionType.PUSH_PBB(26), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 4) {
                throw new OFParseError("Wrong length: Expected=4(4), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - returning shared instance={}", (Object)INSTANCE);
            }
            return INSTANCE;
        }
    }
}

