/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnGentableSetBucketsSize;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.GenTableId;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnGentableSetBucketsSizeVer13
implements OFBsnGentableSetBucketsSize {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnGentableSetBucketsSizeVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 24;
    private static final long DEFAULT_XID = 0L;
    private static final long DEFAULT_BUCKETS_SIZE = 0L;
    private final long xid;
    private final GenTableId tableId;
    private final long bucketsSize;
    static final Reader READER = new Reader();
    static final OFBsnGentableSetBucketsSizeVer13Funnel FUNNEL = new OFBsnGentableSetBucketsSizeVer13Funnel();
    static final Writer WRITER = new Writer();

    OFBsnGentableSetBucketsSizeVer13(long xid, GenTableId tableId, long bucketsSize) {
        if (tableId == null) {
            throw new NullPointerException("OFBsnGentableSetBucketsSizeVer13: property tableId cannot be null");
        }
        this.xid = xid;
        this.tableId = tableId;
        this.bucketsSize = bucketsSize;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFType getType() {
        return OFType.EXPERIMENTER;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public long getExperimenter() {
        return 6035143L;
    }

    @Override
    public long getSubtype() {
        return 50L;
    }

    @Override
    public GenTableId getTableId() {
        return this.tableId;
    }

    @Override
    public long getBucketsSize() {
        return this.bucketsSize;
    }

    @Override
    public OFBsnGentableSetBucketsSize.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnGentableSetBucketsSizeVer13(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("tableId=").append(this.tableId);
        b.append(", ");
        b.append("bucketsSize=").append(this.bucketsSize);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnGentableSetBucketsSizeVer13 other = (OFBsnGentableSetBucketsSizeVer13)obj;
        if (this.xid != other.xid) {
            return false;
        }
        if (this.tableId == null ? other.tableId != null : !this.tableId.equals(other.tableId)) {
            return false;
        }
        return this.bucketsSize == other.bucketsSize;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + (this.tableId == null ? 0 : this.tableId.hashCode());
        result = 31 * (int)(this.bucketsSize ^ this.bucketsSize >>> 32);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnGentableSetBucketsSizeVer13> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFBsnGentableSetBucketsSizeVer13 message) {
            bb.writeByte(4);
            bb.writeByte(4);
            bb.writeShort(24);
            bb.writeInt(U32.t(message.xid));
            bb.writeInt(6035143);
            bb.writeInt(50);
            message.tableId.write2Bytes(bb);
            bb.writeZero(2);
            bb.writeInt(U32.t(message.bucketsSize));
        }
    }

    static class OFBsnGentableSetBucketsSizeVer13Funnel
    implements Funnel<OFBsnGentableSetBucketsSizeVer13> {
        private static final long serialVersionUID = 1L;

        OFBsnGentableSetBucketsSizeVer13Funnel() {
        }

        public void funnel(OFBsnGentableSetBucketsSizeVer13 message, PrimitiveSink sink) {
            sink.putByte((byte)4);
            sink.putByte((byte)4);
            sink.putShort((short)24);
            sink.putLong(message.xid);
            sink.putInt(6035143);
            sink.putInt(50);
            message.tableId.putTo(sink);
            sink.putLong(message.bucketsSize);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnGentableSetBucketsSize> {
        Reader() {
        }

        @Override
        public OFBsnGentableSetBucketsSize readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 4) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_13(4), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 4) {
                throw new OFParseError("Wrong type: Expected=OFType.EXPERIMENTER(4), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 24) {
                throw new OFParseError("Wrong length: Expected=24(24), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            int experimenter = bb.readInt();
            if (experimenter != 6035143) {
                throw new OFParseError("Wrong experimenter: Expected=0x5c16c7L(0x5c16c7L), got=" + experimenter);
            }
            int subtype = bb.readInt();
            if (subtype != 50) {
                throw new OFParseError("Wrong subtype: Expected=0x32L(0x32L), got=" + subtype);
            }
            GenTableId tableId = GenTableId.read2Bytes(bb);
            bb.skipBytes(2);
            long bucketsSize = U32.f(bb.readInt());
            OFBsnGentableSetBucketsSizeVer13 bsnGentableSetBucketsSizeVer13 = new OFBsnGentableSetBucketsSizeVer13(xid, tableId, bucketsSize);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnGentableSetBucketsSizeVer13);
            }
            return bsnGentableSetBucketsSizeVer13;
        }
    }

    static class Builder
    implements OFBsnGentableSetBucketsSize.Builder {
        private boolean xidSet;
        private long xid;
        private boolean tableIdSet;
        private GenTableId tableId;
        private boolean bucketsSizeSet;
        private long bucketsSize;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFType getType() {
            return OFType.EXPERIMENTER;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnGentableSetBucketsSize.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 50L;
        }

        @Override
        public GenTableId getTableId() {
            return this.tableId;
        }

        @Override
        public OFBsnGentableSetBucketsSize.Builder setTableId(GenTableId tableId) {
            this.tableId = tableId;
            this.tableIdSet = true;
            return this;
        }

        @Override
        public long getBucketsSize() {
            return this.bucketsSize;
        }

        @Override
        public OFBsnGentableSetBucketsSize.Builder setBucketsSize(long bucketsSize) {
            this.bucketsSize = bucketsSize;
            this.bucketsSizeSet = true;
            return this;
        }

        @Override
        public OFBsnGentableSetBucketsSize build() {
            long xid;
            long l = xid = this.xidSet ? this.xid : 0L;
            if (!this.tableIdSet) {
                throw new IllegalStateException("Property tableId doesn't have default value -- must be set");
            }
            if (this.tableId == null) {
                throw new NullPointerException("Property tableId must not be null");
            }
            long bucketsSize = this.bucketsSizeSet ? this.bucketsSize : 0L;
            return new OFBsnGentableSetBucketsSizeVer13(xid, this.tableId, bucketsSize);
        }
    }

    static class BuilderWithParent
    implements OFBsnGentableSetBucketsSize.Builder {
        final OFBsnGentableSetBucketsSizeVer13 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean tableIdSet;
        private GenTableId tableId;
        private boolean bucketsSizeSet;
        private long bucketsSize;

        BuilderWithParent(OFBsnGentableSetBucketsSizeVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFType getType() {
            return OFType.EXPERIMENTER;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnGentableSetBucketsSize.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 50L;
        }

        @Override
        public GenTableId getTableId() {
            return this.tableId;
        }

        @Override
        public OFBsnGentableSetBucketsSize.Builder setTableId(GenTableId tableId) {
            this.tableId = tableId;
            this.tableIdSet = true;
            return this;
        }

        @Override
        public long getBucketsSize() {
            return this.bucketsSize;
        }

        @Override
        public OFBsnGentableSetBucketsSize.Builder setBucketsSize(long bucketsSize) {
            this.bucketsSize = bucketsSize;
            this.bucketsSizeSet = true;
            return this;
        }

        @Override
        public OFBsnGentableSetBucketsSize build() {
            GenTableId tableId;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            GenTableId genTableId = tableId = this.tableIdSet ? this.tableId : this.parentMessage.tableId;
            if (tableId == null) {
                throw new NullPointerException("Property tableId must not be null");
            }
            long bucketsSize = this.bucketsSizeSet ? this.bucketsSize : this.parentMessage.bucketsSize;
            return new OFBsnGentableSetBucketsSizeVer13(xid, tableId, bucketsSize);
        }
    }
}

