/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvActorSystemMac;
import org.projectfloodlight.openflow.types.MacAddress;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvActorSystemMacVer13
implements OFBsnTlvActorSystemMac {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvActorSystemMacVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 10;
    private static final MacAddress DEFAULT_VALUE = MacAddress.NONE;
    private final MacAddress value;
    static final OFBsnTlvActorSystemMacVer13 DEFAULT = new OFBsnTlvActorSystemMacVer13(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFBsnTlvActorSystemMacVer13Funnel FUNNEL = new OFBsnTlvActorSystemMacVer13Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvActorSystemMacVer13(MacAddress value) {
        if (value == null) {
            throw new NullPointerException("OFBsnTlvActorSystemMacVer13: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public int getType() {
        return 41;
    }

    @Override
    public MacAddress getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFBsnTlvActorSystemMac.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvActorSystemMacVer13(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvActorSystemMacVer13 other = (OFBsnTlvActorSystemMacVer13)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvActorSystemMacVer13> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFBsnTlvActorSystemMacVer13 message) {
            bb.writeShort(41);
            bb.writeShort(10);
            message.value.write6Bytes(bb);
        }
    }

    static class OFBsnTlvActorSystemMacVer13Funnel
    implements Funnel<OFBsnTlvActorSystemMacVer13> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvActorSystemMacVer13Funnel() {
        }

        public void funnel(OFBsnTlvActorSystemMacVer13 message, PrimitiveSink sink) {
            sink.putShort((short)41);
            sink.putShort((short)10);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvActorSystemMac> {
        Reader() {
        }

        @Override
        public OFBsnTlvActorSystemMac readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 41) {
                throw new OFParseError("Wrong type: Expected=0x29(0x29), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 10) {
                throw new OFParseError("Wrong length: Expected=10(10), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            MacAddress value = MacAddress.read6Bytes(bb);
            OFBsnTlvActorSystemMacVer13 bsnTlvActorSystemMacVer13 = new OFBsnTlvActorSystemMacVer13(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvActorSystemMacVer13);
            }
            return bsnTlvActorSystemMacVer13;
        }
    }

    static class Builder
    implements OFBsnTlvActorSystemMac.Builder {
        private boolean valueSet;
        private MacAddress value;

        Builder() {
        }

        @Override
        public int getType() {
            return 41;
        }

        @Override
        public MacAddress getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvActorSystemMac.Builder setValue(MacAddress value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvActorSystemMac build() {
            MacAddress value;
            MacAddress macAddress = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvActorSystemMacVer13(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvActorSystemMac.Builder {
        final OFBsnTlvActorSystemMacVer13 parentMessage;
        private boolean valueSet;
        private MacAddress value;

        BuilderWithParent(OFBsnTlvActorSystemMacVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 41;
        }

        @Override
        public MacAddress getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvActorSystemMac.Builder setValue(MacAddress value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvActorSystemMac build() {
            MacAddress value;
            MacAddress macAddress = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvActorSystemMacVer13(value);
        }
    }
}

