/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.collect.ImmutableSet;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import java.util.Set;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFCalientFlowStatsRequest;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFStatsRequestFlags;
import org.projectfloodlight.openflow.protocol.OFStatsType;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.Match;
import org.projectfloodlight.openflow.protocol.ver13.ChannelUtilsVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFFactoryVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFStatsRequestFlagsSerializerVer13;
import org.projectfloodlight.openflow.types.OFPort;
import org.projectfloodlight.openflow.types.TableId;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.types.U64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFCalientFlowStatsRequestVer13
implements OFCalientFlowStatsRequest {
    private static final Logger logger = LoggerFactory.getLogger(OFCalientFlowStatsRequestVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int MINIMUM_LENGTH = 64;
    private static final long DEFAULT_XID = 0L;
    private static final Set<OFStatsRequestFlags> DEFAULT_FLAGS = ImmutableSet.of();
    private static final TableId DEFAULT_TABLE_ID = TableId.ALL;
    private static final OFPort DEFAULT_OUT_PORT = OFPort.ANY;
    private static final long DEFAULT_OUT_GROUP = 0L;
    private static final U64 DEFAULT_COOKIE = U64.ZERO;
    private static final U64 DEFAULT_COOKIE_MASK = U64.ZERO;
    private static final Match DEFAULT_MATCH = OFFactoryVer13.MATCH_WILDCARD_ALL;
    private final long xid;
    private final Set<OFStatsRequestFlags> flags;
    private final TableId tableId;
    private final OFPort outPort;
    private final long outGroup;
    private final U64 cookie;
    private final U64 cookieMask;
    private final Match match;
    static final OFCalientFlowStatsRequestVer13 DEFAULT = new OFCalientFlowStatsRequestVer13(0L, DEFAULT_FLAGS, DEFAULT_TABLE_ID, DEFAULT_OUT_PORT, 0L, DEFAULT_COOKIE, DEFAULT_COOKIE_MASK, DEFAULT_MATCH);
    static final Reader READER = new Reader();
    static final OFCalientFlowStatsRequestVer13Funnel FUNNEL = new OFCalientFlowStatsRequestVer13Funnel();
    static final Writer WRITER = new Writer();

    OFCalientFlowStatsRequestVer13(long xid, Set<OFStatsRequestFlags> flags, TableId tableId, OFPort outPort, long outGroup, U64 cookie, U64 cookieMask, Match match) {
        if (flags == null) {
            throw new NullPointerException("OFCalientFlowStatsRequestVer13: property flags cannot be null");
        }
        if (tableId == null) {
            throw new NullPointerException("OFCalientFlowStatsRequestVer13: property tableId cannot be null");
        }
        if (outPort == null) {
            throw new NullPointerException("OFCalientFlowStatsRequestVer13: property outPort cannot be null");
        }
        if (cookie == null) {
            throw new NullPointerException("OFCalientFlowStatsRequestVer13: property cookie cannot be null");
        }
        if (cookieMask == null) {
            throw new NullPointerException("OFCalientFlowStatsRequestVer13: property cookieMask cannot be null");
        }
        if (match == null) {
            throw new NullPointerException("OFCalientFlowStatsRequestVer13: property match cannot be null");
        }
        this.xid = xid;
        this.flags = flags;
        this.tableId = tableId;
        this.outPort = outPort;
        this.outGroup = outGroup;
        this.cookie = cookie;
        this.cookieMask = cookieMask;
        this.match = match;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFType getType() {
        return OFType.STATS_REQUEST;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public OFStatsType getStatsType() {
        return OFStatsType.EXPERIMENTER;
    }

    @Override
    public Set<OFStatsRequestFlags> getFlags() {
        return this.flags;
    }

    @Override
    public long getExperimenter() {
        return 8452440L;
    }

    @Override
    public long getSubtype() {
        return 2L;
    }

    @Override
    public TableId getTableId() {
        return this.tableId;
    }

    @Override
    public OFPort getOutPort() {
        return this.outPort;
    }

    @Override
    public long getOutGroup() {
        return this.outGroup;
    }

    @Override
    public U64 getCookie() {
        return this.cookie;
    }

    @Override
    public U64 getCookieMask() {
        return this.cookieMask;
    }

    @Override
    public Match getMatch() {
        return this.match;
    }

    @Override
    public OFCalientFlowStatsRequest.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFCalientFlowStatsRequestVer13(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("flags=").append(this.flags);
        b.append(", ");
        b.append("tableId=").append(this.tableId);
        b.append(", ");
        b.append("outPort=").append(this.outPort);
        b.append(", ");
        b.append("outGroup=").append(this.outGroup);
        b.append(", ");
        b.append("cookie=").append(this.cookie);
        b.append(", ");
        b.append("cookieMask=").append(this.cookieMask);
        b.append(", ");
        b.append("match=").append(this.match);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFCalientFlowStatsRequestVer13 other = (OFCalientFlowStatsRequestVer13)obj;
        if (this.xid != other.xid) {
            return false;
        }
        if (this.flags == null ? other.flags != null : !this.flags.equals(other.flags)) {
            return false;
        }
        if (this.tableId == null ? other.tableId != null : !this.tableId.equals(other.tableId)) {
            return false;
        }
        if (this.outPort == null ? other.outPort != null : !this.outPort.equals(other.outPort)) {
            return false;
        }
        if (this.outGroup != other.outGroup) {
            return false;
        }
        if (this.cookie == null ? other.cookie != null : !this.cookie.equals(other.cookie)) {
            return false;
        }
        if (this.cookieMask == null ? other.cookieMask != null : !this.cookieMask.equals(other.cookieMask)) {
            return false;
        }
        return !(this.match == null ? other.match != null : !this.match.equals(other.match));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + (this.flags == null ? 0 : this.flags.hashCode());
        result = 31 * result + (this.tableId == null ? 0 : this.tableId.hashCode());
        result = 31 * result + (this.outPort == null ? 0 : this.outPort.hashCode());
        result = 31 * (int)(this.outGroup ^ this.outGroup >>> 32);
        result = 31 * result + (this.cookie == null ? 0 : this.cookie.hashCode());
        result = 31 * result + (this.cookieMask == null ? 0 : this.cookieMask.hashCode());
        result = 31 * result + (this.match == null ? 0 : this.match.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFCalientFlowStatsRequestVer13> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFCalientFlowStatsRequestVer13 message) {
            int startIndex = bb.writerIndex();
            bb.writeByte(4);
            bb.writeByte(18);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            bb.writeInt(U32.t(message.xid));
            bb.writeShort(-1);
            OFStatsRequestFlagsSerializerVer13.writeTo(bb, message.flags);
            bb.writeZero(4);
            bb.writeInt(8452440);
            bb.writeInt(2);
            message.tableId.writeByte(bb);
            bb.writeZero(3);
            message.outPort.write4Bytes(bb);
            bb.writeInt(U32.t(message.outGroup));
            bb.writeZero(4);
            bb.writeLong(message.cookie.getValue());
            bb.writeLong(message.cookieMask.getValue());
            message.match.writeTo(bb);
            int length = bb.writerIndex() - startIndex;
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFCalientFlowStatsRequestVer13Funnel
    implements Funnel<OFCalientFlowStatsRequestVer13> {
        private static final long serialVersionUID = 1L;

        OFCalientFlowStatsRequestVer13Funnel() {
        }

        public void funnel(OFCalientFlowStatsRequestVer13 message, PrimitiveSink sink) {
            sink.putByte((byte)4);
            sink.putByte((byte)18);
            sink.putLong(message.xid);
            sink.putShort((short)-1);
            OFStatsRequestFlagsSerializerVer13.putTo(message.flags, sink);
            sink.putInt(8452440);
            sink.putInt(2);
            message.tableId.putTo(sink);
            message.outPort.putTo(sink);
            sink.putLong(message.outGroup);
            message.cookie.putTo(sink);
            message.cookieMask.putTo(sink);
            message.match.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFCalientFlowStatsRequest> {
        Reader() {
        }

        @Override
        public OFCalientFlowStatsRequest readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 4) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_13(4), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 18) {
                throw new OFParseError("Wrong type: Expected=OFType.STATS_REQUEST(18), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 64) {
                throw new OFParseError("Wrong length: Expected to be >= 64, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            short statsType = bb.readShort();
            if (statsType != -1) {
                throw new OFParseError("Wrong statsType: Expected=OFStatsType.EXPERIMENTER(65535), got=" + statsType);
            }
            Set<OFStatsRequestFlags> flags = OFStatsRequestFlagsSerializerVer13.readFrom(bb);
            bb.skipBytes(4);
            int experimenter = bb.readInt();
            if (experimenter != 8452440) {
                throw new OFParseError("Wrong experimenter: Expected=0x80f958L(0x80f958L), got=" + experimenter);
            }
            int subtype = bb.readInt();
            if (subtype != 2) {
                throw new OFParseError("Wrong subtype: Expected=0x2L(0x2L), got=" + subtype);
            }
            TableId tableId = TableId.readByte(bb);
            bb.skipBytes(3);
            OFPort outPort = OFPort.read4Bytes(bb);
            long outGroup = U32.f(bb.readInt());
            bb.skipBytes(4);
            U64 cookie = U64.ofRaw(bb.readLong());
            U64 cookieMask = U64.ofRaw(bb.readLong());
            Match match = ChannelUtilsVer13.readOFMatch(bb);
            OFCalientFlowStatsRequestVer13 calientFlowStatsRequestVer13 = new OFCalientFlowStatsRequestVer13(xid, flags, tableId, outPort, outGroup, cookie, cookieMask, match);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)calientFlowStatsRequestVer13);
            }
            return calientFlowStatsRequestVer13;
        }
    }

    static class Builder
    implements OFCalientFlowStatsRequest.Builder {
        private boolean xidSet;
        private long xid;
        private boolean flagsSet;
        private Set<OFStatsRequestFlags> flags;
        private boolean tableIdSet;
        private TableId tableId;
        private boolean outPortSet;
        private OFPort outPort;
        private boolean outGroupSet;
        private long outGroup;
        private boolean cookieSet;
        private U64 cookie;
        private boolean cookieMaskSet;
        private U64 cookieMask;
        private boolean matchSet;
        private Match match;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFType getType() {
            return OFType.STATS_REQUEST;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFCalientFlowStatsRequest.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFStatsType getStatsType() {
            return OFStatsType.EXPERIMENTER;
        }

        @Override
        public Set<OFStatsRequestFlags> getFlags() {
            return this.flags;
        }

        @Override
        public OFCalientFlowStatsRequest.Builder setFlags(Set<OFStatsRequestFlags> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 8452440L;
        }

        @Override
        public long getSubtype() {
            return 2L;
        }

        @Override
        public TableId getTableId() {
            return this.tableId;
        }

        @Override
        public OFCalientFlowStatsRequest.Builder setTableId(TableId tableId) {
            this.tableId = tableId;
            this.tableIdSet = true;
            return this;
        }

        @Override
        public OFPort getOutPort() {
            return this.outPort;
        }

        @Override
        public OFCalientFlowStatsRequest.Builder setOutPort(OFPort outPort) {
            this.outPort = outPort;
            this.outPortSet = true;
            return this;
        }

        @Override
        public long getOutGroup() {
            return this.outGroup;
        }

        @Override
        public OFCalientFlowStatsRequest.Builder setOutGroup(long outGroup) {
            this.outGroup = outGroup;
            this.outGroupSet = true;
            return this;
        }

        @Override
        public U64 getCookie() {
            return this.cookie;
        }

        @Override
        public OFCalientFlowStatsRequest.Builder setCookie(U64 cookie) {
            this.cookie = cookie;
            this.cookieSet = true;
            return this;
        }

        @Override
        public U64 getCookieMask() {
            return this.cookieMask;
        }

        @Override
        public OFCalientFlowStatsRequest.Builder setCookieMask(U64 cookieMask) {
            this.cookieMask = cookieMask;
            this.cookieMaskSet = true;
            return this;
        }

        @Override
        public Match getMatch() {
            return this.match;
        }

        @Override
        public OFCalientFlowStatsRequest.Builder setMatch(Match match) {
            this.match = match;
            this.matchSet = true;
            return this;
        }

        @Override
        public OFCalientFlowStatsRequest build() {
            Match match;
            U64 cookieMask;
            U64 cookie;
            OFPort outPort;
            TableId tableId;
            Set<OFStatsRequestFlags> flags;
            long xid = this.xidSet ? this.xid : 0L;
            Set<OFStatsRequestFlags> set = flags = this.flagsSet ? this.flags : DEFAULT_FLAGS;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            TableId tableId2 = tableId = this.tableIdSet ? this.tableId : DEFAULT_TABLE_ID;
            if (tableId == null) {
                throw new NullPointerException("Property tableId must not be null");
            }
            OFPort oFPort = outPort = this.outPortSet ? this.outPort : DEFAULT_OUT_PORT;
            if (outPort == null) {
                throw new NullPointerException("Property outPort must not be null");
            }
            long outGroup = this.outGroupSet ? this.outGroup : 0L;
            U64 u64 = cookie = this.cookieSet ? this.cookie : DEFAULT_COOKIE;
            if (cookie == null) {
                throw new NullPointerException("Property cookie must not be null");
            }
            U64 u642 = cookieMask = this.cookieMaskSet ? this.cookieMask : DEFAULT_COOKIE_MASK;
            if (cookieMask == null) {
                throw new NullPointerException("Property cookieMask must not be null");
            }
            Match match2 = match = this.matchSet ? this.match : DEFAULT_MATCH;
            if (match == null) {
                throw new NullPointerException("Property match must not be null");
            }
            return new OFCalientFlowStatsRequestVer13(xid, flags, tableId, outPort, outGroup, cookie, cookieMask, match);
        }
    }

    static class BuilderWithParent
    implements OFCalientFlowStatsRequest.Builder {
        final OFCalientFlowStatsRequestVer13 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean flagsSet;
        private Set<OFStatsRequestFlags> flags;
        private boolean tableIdSet;
        private TableId tableId;
        private boolean outPortSet;
        private OFPort outPort;
        private boolean outGroupSet;
        private long outGroup;
        private boolean cookieSet;
        private U64 cookie;
        private boolean cookieMaskSet;
        private U64 cookieMask;
        private boolean matchSet;
        private Match match;

        BuilderWithParent(OFCalientFlowStatsRequestVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFType getType() {
            return OFType.STATS_REQUEST;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFCalientFlowStatsRequest.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFStatsType getStatsType() {
            return OFStatsType.EXPERIMENTER;
        }

        @Override
        public Set<OFStatsRequestFlags> getFlags() {
            return this.flags;
        }

        @Override
        public OFCalientFlowStatsRequest.Builder setFlags(Set<OFStatsRequestFlags> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 8452440L;
        }

        @Override
        public long getSubtype() {
            return 2L;
        }

        @Override
        public TableId getTableId() {
            return this.tableId;
        }

        @Override
        public OFCalientFlowStatsRequest.Builder setTableId(TableId tableId) {
            this.tableId = tableId;
            this.tableIdSet = true;
            return this;
        }

        @Override
        public OFPort getOutPort() {
            return this.outPort;
        }

        @Override
        public OFCalientFlowStatsRequest.Builder setOutPort(OFPort outPort) {
            this.outPort = outPort;
            this.outPortSet = true;
            return this;
        }

        @Override
        public long getOutGroup() {
            return this.outGroup;
        }

        @Override
        public OFCalientFlowStatsRequest.Builder setOutGroup(long outGroup) {
            this.outGroup = outGroup;
            this.outGroupSet = true;
            return this;
        }

        @Override
        public U64 getCookie() {
            return this.cookie;
        }

        @Override
        public OFCalientFlowStatsRequest.Builder setCookie(U64 cookie) {
            this.cookie = cookie;
            this.cookieSet = true;
            return this;
        }

        @Override
        public U64 getCookieMask() {
            return this.cookieMask;
        }

        @Override
        public OFCalientFlowStatsRequest.Builder setCookieMask(U64 cookieMask) {
            this.cookieMask = cookieMask;
            this.cookieMaskSet = true;
            return this;
        }

        @Override
        public Match getMatch() {
            return this.match;
        }

        @Override
        public OFCalientFlowStatsRequest.Builder setMatch(Match match) {
            this.match = match;
            this.matchSet = true;
            return this;
        }

        @Override
        public OFCalientFlowStatsRequest build() {
            Match match;
            U64 cookieMask;
            U64 cookie;
            OFPort outPort;
            TableId tableId;
            Set flags;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            Set set = flags = this.flagsSet ? this.flags : this.parentMessage.flags;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            TableId tableId2 = tableId = this.tableIdSet ? this.tableId : this.parentMessage.tableId;
            if (tableId == null) {
                throw new NullPointerException("Property tableId must not be null");
            }
            OFPort oFPort = outPort = this.outPortSet ? this.outPort : this.parentMessage.outPort;
            if (outPort == null) {
                throw new NullPointerException("Property outPort must not be null");
            }
            long outGroup = this.outGroupSet ? this.outGroup : this.parentMessage.outGroup;
            U64 u64 = cookie = this.cookieSet ? this.cookie : this.parentMessage.cookie;
            if (cookie == null) {
                throw new NullPointerException("Property cookie must not be null");
            }
            U64 u642 = cookieMask = this.cookieMaskSet ? this.cookieMask : this.parentMessage.cookieMask;
            if (cookieMask == null) {
                throw new NullPointerException("Property cookieMask must not be null");
            }
            Match match2 = match = this.matchSet ? this.match : this.parentMessage.match;
            if (match == null) {
                throw new NullPointerException("Property match must not be null");
            }
            return new OFCalientFlowStatsRequestVer13(xid, flags, tableId, outPort, outGroup, cookie, cookieMask, match);
        }
    }
}

