/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.collect.ImmutableList;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import java.util.List;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFExpPortDescPropOpticalTransport;
import org.projectfloodlight.openflow.protocol.OFExpPortOpticalTransportLayerStack;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFPortOpticalTransportSignalType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.ver13.OFExpPortOpticalTransportLayerStackVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFPortOpticalTransportSignalTypeSerializerVer13;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U8;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.projectfloodlight.openflow.util.FunnelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFExpPortDescPropOpticalTransportVer13
implements OFExpPortDescPropOpticalTransport {
    private static final Logger logger = LoggerFactory.getLogger(OFExpPortDescPropOpticalTransportVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int MINIMUM_LENGTH = 8;
    private static final short DEFAULT_RESERVED = 0;
    private static final List<OFExpPortOpticalTransportLayerStack> DEFAULT_FEATURES = ImmutableList.of();
    private final OFPortOpticalTransportSignalType portSignalType;
    private final short reserved;
    private final List<OFExpPortOpticalTransportLayerStack> features;
    static final Reader READER = new Reader();
    static final OFExpPortDescPropOpticalTransportVer13Funnel FUNNEL = new OFExpPortDescPropOpticalTransportVer13Funnel();
    static final Writer WRITER = new Writer();

    OFExpPortDescPropOpticalTransportVer13(OFPortOpticalTransportSignalType portSignalType, short reserved, List<OFExpPortOpticalTransportLayerStack> features) {
        if (portSignalType == null) {
            throw new NullPointerException("OFExpPortDescPropOpticalTransportVer13: property portSignalType cannot be null");
        }
        if (features == null) {
            throw new NullPointerException("OFExpPortDescPropOpticalTransportVer13: property features cannot be null");
        }
        this.portSignalType = portSignalType;
        this.reserved = reserved;
        this.features = features;
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    public OFPortOpticalTransportSignalType getPortSignalType() {
        return this.portSignalType;
    }

    @Override
    public short getReserved() {
        return this.reserved;
    }

    @Override
    public List<OFExpPortOpticalTransportLayerStack> getFeatures() {
        return this.features;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFExpPortDescPropOpticalTransport.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFExpPortDescPropOpticalTransportVer13(");
        b.append("portSignalType=").append((Object)this.portSignalType);
        b.append(", ");
        b.append("reserved=").append(this.reserved);
        b.append(", ");
        b.append("features=").append(this.features);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFExpPortDescPropOpticalTransportVer13 other = (OFExpPortDescPropOpticalTransportVer13)obj;
        if (this.portSignalType == null ? other.portSignalType != null : !this.portSignalType.equals((Object)other.portSignalType)) {
            return false;
        }
        if (this.reserved != other.reserved) {
            return false;
        }
        return !(this.features == null ? other.features != null : !this.features.equals(other.features));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.portSignalType == null ? 0 : this.portSignalType.hashCode());
        result = 31 * result + this.reserved;
        result = 31 * result + (this.features == null ? 0 : this.features.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFExpPortDescPropOpticalTransportVer13> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFExpPortDescPropOpticalTransportVer13 message) {
            int startIndex = bb.writerIndex();
            bb.writeShort(2);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            OFPortOpticalTransportSignalTypeSerializerVer13.writeTo(bb, message.portSignalType);
            bb.writeByte((int)U8.t(message.reserved));
            bb.writeZero(2);
            ChannelUtils.writeList(bb, message.features);
            int length = bb.writerIndex() - startIndex;
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFExpPortDescPropOpticalTransportVer13Funnel
    implements Funnel<OFExpPortDescPropOpticalTransportVer13> {
        private static final long serialVersionUID = 1L;

        OFExpPortDescPropOpticalTransportVer13Funnel() {
        }

        public void funnel(OFExpPortDescPropOpticalTransportVer13 message, PrimitiveSink sink) {
            sink.putShort((short)2);
            OFPortOpticalTransportSignalTypeSerializerVer13.putTo(message.portSignalType, sink);
            sink.putShort(message.reserved);
            FunnelUtils.putList(message.features, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFExpPortDescPropOpticalTransport> {
        Reader() {
        }

        @Override
        public OFExpPortDescPropOpticalTransport readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 2) {
                throw new OFParseError("Wrong type: Expected=0x2(0x2), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 8) {
                throw new OFParseError("Wrong length: Expected to be >= 8, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            OFPortOpticalTransportSignalType portSignalType = OFPortOpticalTransportSignalTypeSerializerVer13.readFrom(bb);
            short reserved = U8.f(bb.readByte());
            bb.skipBytes(2);
            List<OFExpPortOpticalTransportLayerStack> features = ChannelUtils.readList(bb, length - (bb.readerIndex() - start), OFExpPortOpticalTransportLayerStackVer13.READER);
            OFExpPortDescPropOpticalTransportVer13 expPortDescPropOpticalTransportVer13 = new OFExpPortDescPropOpticalTransportVer13(portSignalType, reserved, features);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)expPortDescPropOpticalTransportVer13);
            }
            return expPortDescPropOpticalTransportVer13;
        }
    }

    static class Builder
    implements OFExpPortDescPropOpticalTransport.Builder {
        private boolean portSignalTypeSet;
        private OFPortOpticalTransportSignalType portSignalType;
        private boolean reservedSet;
        private short reserved;
        private boolean featuresSet;
        private List<OFExpPortOpticalTransportLayerStack> features;

        Builder() {
        }

        @Override
        public int getType() {
            return 2;
        }

        @Override
        public OFPortOpticalTransportSignalType getPortSignalType() {
            return this.portSignalType;
        }

        @Override
        public OFExpPortDescPropOpticalTransport.Builder setPortSignalType(OFPortOpticalTransportSignalType portSignalType) {
            this.portSignalType = portSignalType;
            this.portSignalTypeSet = true;
            return this;
        }

        @Override
        public short getReserved() {
            return this.reserved;
        }

        @Override
        public OFExpPortDescPropOpticalTransport.Builder setReserved(short reserved) {
            this.reserved = reserved;
            this.reservedSet = true;
            return this;
        }

        @Override
        public List<OFExpPortOpticalTransportLayerStack> getFeatures() {
            return this.features;
        }

        @Override
        public OFExpPortDescPropOpticalTransport.Builder setFeatures(List<OFExpPortOpticalTransportLayerStack> features) {
            this.features = features;
            this.featuresSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFExpPortDescPropOpticalTransport build() {
            List<OFExpPortOpticalTransportLayerStack> features;
            if (!this.portSignalTypeSet) {
                throw new IllegalStateException("Property portSignalType doesn't have default value -- must be set");
            }
            if (this.portSignalType == null) {
                throw new NullPointerException("Property portSignalType must not be null");
            }
            short reserved = this.reservedSet ? this.reserved : (short)0;
            List<OFExpPortOpticalTransportLayerStack> list = features = this.featuresSet ? this.features : DEFAULT_FEATURES;
            if (features == null) {
                throw new NullPointerException("Property features must not be null");
            }
            return new OFExpPortDescPropOpticalTransportVer13(this.portSignalType, reserved, features);
        }
    }

    static class BuilderWithParent
    implements OFExpPortDescPropOpticalTransport.Builder {
        final OFExpPortDescPropOpticalTransportVer13 parentMessage;
        private boolean portSignalTypeSet;
        private OFPortOpticalTransportSignalType portSignalType;
        private boolean reservedSet;
        private short reserved;
        private boolean featuresSet;
        private List<OFExpPortOpticalTransportLayerStack> features;

        BuilderWithParent(OFExpPortDescPropOpticalTransportVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 2;
        }

        @Override
        public OFPortOpticalTransportSignalType getPortSignalType() {
            return this.portSignalType;
        }

        @Override
        public OFExpPortDescPropOpticalTransport.Builder setPortSignalType(OFPortOpticalTransportSignalType portSignalType) {
            this.portSignalType = portSignalType;
            this.portSignalTypeSet = true;
            return this;
        }

        @Override
        public short getReserved() {
            return this.reserved;
        }

        @Override
        public OFExpPortDescPropOpticalTransport.Builder setReserved(short reserved) {
            this.reserved = reserved;
            this.reservedSet = true;
            return this;
        }

        @Override
        public List<OFExpPortOpticalTransportLayerStack> getFeatures() {
            return this.features;
        }

        @Override
        public OFExpPortDescPropOpticalTransport.Builder setFeatures(List<OFExpPortOpticalTransportLayerStack> features) {
            this.features = features;
            this.featuresSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFExpPortDescPropOpticalTransport build() {
            List features;
            OFPortOpticalTransportSignalType portSignalType;
            OFPortOpticalTransportSignalType oFPortOpticalTransportSignalType = portSignalType = this.portSignalTypeSet ? this.portSignalType : this.parentMessage.portSignalType;
            if (portSignalType == null) {
                throw new NullPointerException("Property portSignalType must not be null");
            }
            short reserved = this.reservedSet ? this.reserved : this.parentMessage.reserved;
            List list = features = this.featuresSet ? this.features : this.parentMessage.features;
            if (features == null) {
                throw new NullPointerException("Property features must not be null");
            }
            return new OFExpPortDescPropOpticalTransportVer13(portSignalType, reserved, features);
        }
    }
}

