/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.collect.ImmutableList;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import java.util.List;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFExpPortOpticalTransportLayerEntry;
import org.projectfloodlight.openflow.protocol.OFExpPortOpticalTransportLayerStack;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.ver13.OFExpPortOpticalTransportLayerEntryVer13;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.projectfloodlight.openflow.util.FunnelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFExpPortOpticalTransportLayerStackVer13
implements OFExpPortOpticalTransportLayerStack {
    private static final Logger logger = LoggerFactory.getLogger(OFExpPortOpticalTransportLayerStackVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int MINIMUM_LENGTH = 8;
    private static final List<OFExpPortOpticalTransportLayerEntry> DEFAULT_VALUE = ImmutableList.of();
    private final List<OFExpPortOpticalTransportLayerEntry> value;
    static final OFExpPortOpticalTransportLayerStackVer13 DEFAULT = new OFExpPortOpticalTransportLayerStackVer13(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFExpPortOpticalTransportLayerStackVer13Funnel FUNNEL = new OFExpPortOpticalTransportLayerStackVer13Funnel();
    static final Writer WRITER = new Writer();

    OFExpPortOpticalTransportLayerStackVer13(List<OFExpPortOpticalTransportLayerEntry> value) {
        if (value == null) {
            throw new NullPointerException("OFExpPortOpticalTransportLayerStackVer13: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public int getFeatureType() {
        return 2;
    }

    @Override
    public List<OFExpPortOpticalTransportLayerEntry> getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFExpPortOpticalTransportLayerStack.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFExpPortOpticalTransportLayerStackVer13(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFExpPortOpticalTransportLayerStackVer13 other = (OFExpPortOpticalTransportLayerStackVer13)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFExpPortOpticalTransportLayerStackVer13> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFExpPortOpticalTransportLayerStackVer13 message) {
            int startIndex = bb.writerIndex();
            bb.writeShort(2);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            bb.writeZero(4);
            ChannelUtils.writeList(bb, message.value);
            int length = bb.writerIndex() - startIndex;
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFExpPortOpticalTransportLayerStackVer13Funnel
    implements Funnel<OFExpPortOpticalTransportLayerStackVer13> {
        private static final long serialVersionUID = 1L;

        OFExpPortOpticalTransportLayerStackVer13Funnel() {
        }

        public void funnel(OFExpPortOpticalTransportLayerStackVer13 message, PrimitiveSink sink) {
            sink.putShort((short)2);
            FunnelUtils.putList(message.value, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFExpPortOpticalTransportLayerStack> {
        Reader() {
        }

        @Override
        public OFExpPortOpticalTransportLayerStack readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            short featureType = bb.readShort();
            if (featureType != 2) {
                throw new OFParseError("Wrong featureType: Expected=0x2(0x2), got=" + featureType);
            }
            int length = U16.f(bb.readShort());
            if (length < 8) {
                throw new OFParseError("Wrong length: Expected to be >= 8, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            bb.skipBytes(4);
            List<OFExpPortOpticalTransportLayerEntry> value = ChannelUtils.readList(bb, length - (bb.readerIndex() - start), OFExpPortOpticalTransportLayerEntryVer13.READER);
            OFExpPortOpticalTransportLayerStackVer13 expPortOpticalTransportLayerStackVer13 = new OFExpPortOpticalTransportLayerStackVer13(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)expPortOpticalTransportLayerStackVer13);
            }
            return expPortOpticalTransportLayerStackVer13;
        }
    }

    static class Builder
    implements OFExpPortOpticalTransportLayerStack.Builder {
        private boolean valueSet;
        private List<OFExpPortOpticalTransportLayerEntry> value;

        Builder() {
        }

        @Override
        public int getFeatureType() {
            return 2;
        }

        @Override
        public List<OFExpPortOpticalTransportLayerEntry> getValue() {
            return this.value;
        }

        @Override
        public OFExpPortOpticalTransportLayerStack.Builder setValue(List<OFExpPortOpticalTransportLayerEntry> value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFExpPortOpticalTransportLayerStack build() {
            List<OFExpPortOpticalTransportLayerEntry> value;
            List<OFExpPortOpticalTransportLayerEntry> list = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFExpPortOpticalTransportLayerStackVer13(value);
        }
    }

    static class BuilderWithParent
    implements OFExpPortOpticalTransportLayerStack.Builder {
        final OFExpPortOpticalTransportLayerStackVer13 parentMessage;
        private boolean valueSet;
        private List<OFExpPortOpticalTransportLayerEntry> value;

        BuilderWithParent(OFExpPortOpticalTransportLayerStackVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getFeatureType() {
            return 2;
        }

        @Override
        public List<OFExpPortOpticalTransportLayerEntry> getValue() {
            return this.value;
        }

        @Override
        public OFExpPortOpticalTransportLayerStack.Builder setValue(List<OFExpPortOpticalTransportLayerEntry> value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFExpPortOpticalTransportLayerStack build() {
            List value;
            List list = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFExpPortOpticalTransportLayerStackVer13(value);
        }
    }
}

