/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFFlowModCommand;
import org.projectfloodlight.openflow.protocol.OFFlowModFlags;
import org.projectfloodlight.openflow.protocol.OFFlowModify;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.action.OFAction;
import org.projectfloodlight.openflow.protocol.instruction.OFInstruction;
import org.projectfloodlight.openflow.protocol.instruction.OFInstructionApplyActions;
import org.projectfloodlight.openflow.protocol.match.Match;
import org.projectfloodlight.openflow.protocol.ver13.ChannelUtilsVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFFactoryVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFFlowModFlagsSerializerVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFInstructionApplyActionsVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFInstructionVer13;
import org.projectfloodlight.openflow.types.OFBufferId;
import org.projectfloodlight.openflow.types.OFGroup;
import org.projectfloodlight.openflow.types.OFPort;
import org.projectfloodlight.openflow.types.TableId;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.types.U64;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.projectfloodlight.openflow.util.FunnelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFFlowModifyVer13
implements OFFlowModify {
    private static final Logger logger = LoggerFactory.getLogger(OFFlowModifyVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int MINIMUM_LENGTH = 56;
    private static final long DEFAULT_XID = 0L;
    private static final U64 DEFAULT_COOKIE = U64.ZERO;
    private static final U64 DEFAULT_COOKIE_MASK = U64.ZERO;
    private static final TableId DEFAULT_TABLE_ID = TableId.ZERO;
    private static final int DEFAULT_IDLE_TIMEOUT = 0;
    private static final int DEFAULT_HARD_TIMEOUT = 0;
    private static final int DEFAULT_PRIORITY = 0;
    private static final OFBufferId DEFAULT_BUFFER_ID = OFBufferId.NO_BUFFER;
    private static final OFPort DEFAULT_OUT_PORT = OFPort.ANY;
    private static final OFGroup DEFAULT_OUT_GROUP = OFGroup.ANY;
    private static final Set<OFFlowModFlags> DEFAULT_FLAGS = ImmutableSet.of();
    private static final Match DEFAULT_MATCH = OFFactoryVer13.MATCH_WILDCARD_ALL;
    private static final List<OFInstruction> DEFAULT_INSTRUCTIONS = ImmutableList.of();
    private final long xid;
    private final U64 cookie;
    private final U64 cookieMask;
    private final TableId tableId;
    private final int idleTimeout;
    private final int hardTimeout;
    private final int priority;
    private final OFBufferId bufferId;
    private final OFPort outPort;
    private final OFGroup outGroup;
    private final Set<OFFlowModFlags> flags;
    private final Match match;
    private final List<OFInstruction> instructions;
    static final OFFlowModifyVer13 DEFAULT = new OFFlowModifyVer13(0L, DEFAULT_COOKIE, DEFAULT_COOKIE_MASK, DEFAULT_TABLE_ID, 0, 0, 0, DEFAULT_BUFFER_ID, DEFAULT_OUT_PORT, DEFAULT_OUT_GROUP, DEFAULT_FLAGS, DEFAULT_MATCH, DEFAULT_INSTRUCTIONS);
    static final Reader READER = new Reader();
    static final OFFlowModifyVer13Funnel FUNNEL = new OFFlowModifyVer13Funnel();
    static final Writer WRITER = new Writer();

    OFFlowModifyVer13(long xid, U64 cookie, U64 cookieMask, TableId tableId, int idleTimeout, int hardTimeout, int priority, OFBufferId bufferId, OFPort outPort, OFGroup outGroup, Set<OFFlowModFlags> flags, Match match, List<OFInstruction> instructions) {
        if (cookie == null) {
            throw new NullPointerException("OFFlowModifyVer13: property cookie cannot be null");
        }
        if (cookieMask == null) {
            throw new NullPointerException("OFFlowModifyVer13: property cookieMask cannot be null");
        }
        if (tableId == null) {
            throw new NullPointerException("OFFlowModifyVer13: property tableId cannot be null");
        }
        if (bufferId == null) {
            throw new NullPointerException("OFFlowModifyVer13: property bufferId cannot be null");
        }
        if (outPort == null) {
            throw new NullPointerException("OFFlowModifyVer13: property outPort cannot be null");
        }
        if (outGroup == null) {
            throw new NullPointerException("OFFlowModifyVer13: property outGroup cannot be null");
        }
        if (flags == null) {
            throw new NullPointerException("OFFlowModifyVer13: property flags cannot be null");
        }
        if (match == null) {
            throw new NullPointerException("OFFlowModifyVer13: property match cannot be null");
        }
        if (instructions == null) {
            throw new NullPointerException("OFFlowModifyVer13: property instructions cannot be null");
        }
        this.xid = xid;
        this.cookie = cookie;
        this.cookieMask = cookieMask;
        this.tableId = tableId;
        this.idleTimeout = idleTimeout;
        this.hardTimeout = hardTimeout;
        this.priority = priority;
        this.bufferId = bufferId;
        this.outPort = outPort;
        this.outGroup = outGroup;
        this.flags = flags;
        this.match = match;
        this.instructions = instructions;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFType getType() {
        return OFType.FLOW_MOD;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public U64 getCookie() {
        return this.cookie;
    }

    @Override
    public U64 getCookieMask() {
        return this.cookieMask;
    }

    @Override
    public TableId getTableId() {
        return this.tableId;
    }

    @Override
    public OFFlowModCommand getCommand() {
        return OFFlowModCommand.MODIFY;
    }

    @Override
    public int getIdleTimeout() {
        return this.idleTimeout;
    }

    @Override
    public int getHardTimeout() {
        return this.hardTimeout;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public OFBufferId getBufferId() {
        return this.bufferId;
    }

    @Override
    public OFPort getOutPort() {
        return this.outPort;
    }

    @Override
    public OFGroup getOutGroup() {
        return this.outGroup;
    }

    @Override
    public Set<OFFlowModFlags> getFlags() {
        return this.flags;
    }

    @Override
    public Match getMatch() {
        return this.match;
    }

    @Override
    public List<OFInstruction> getInstructions() {
        return this.instructions;
    }

    @Override
    public List<OFAction> getActions() throws UnsupportedOperationException {
        for (OFInstruction inst : this.instructions) {
            if (!(inst instanceof OFInstructionApplyActions)) continue;
            OFInstructionApplyActions iap = (OFInstructionApplyActions)inst;
            return iap.getActions();
        }
        return Collections.emptyList();
    }

    @Override
    public int getImportance() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property importance not supported in version 1.3");
    }

    @Override
    public OFFlowModify.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFFlowModifyVer13(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("cookie=").append(this.cookie);
        b.append(", ");
        b.append("cookieMask=").append(this.cookieMask);
        b.append(", ");
        b.append("tableId=").append(this.tableId);
        b.append(", ");
        b.append("idleTimeout=").append(this.idleTimeout);
        b.append(", ");
        b.append("hardTimeout=").append(this.hardTimeout);
        b.append(", ");
        b.append("priority=").append(this.priority);
        b.append(", ");
        b.append("bufferId=").append(this.bufferId);
        b.append(", ");
        b.append("outPort=").append(this.outPort);
        b.append(", ");
        b.append("outGroup=").append(this.outGroup);
        b.append(", ");
        b.append("flags=").append(this.flags);
        b.append(", ");
        b.append("match=").append(this.match);
        b.append(", ");
        b.append("instructions=").append(this.instructions);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFFlowModifyVer13 other = (OFFlowModifyVer13)obj;
        if (this.xid != other.xid) {
            return false;
        }
        if (this.cookie == null ? other.cookie != null : !this.cookie.equals(other.cookie)) {
            return false;
        }
        if (this.cookieMask == null ? other.cookieMask != null : !this.cookieMask.equals(other.cookieMask)) {
            return false;
        }
        if (this.tableId == null ? other.tableId != null : !this.tableId.equals(other.tableId)) {
            return false;
        }
        if (this.idleTimeout != other.idleTimeout) {
            return false;
        }
        if (this.hardTimeout != other.hardTimeout) {
            return false;
        }
        if (this.priority != other.priority) {
            return false;
        }
        if (this.bufferId == null ? other.bufferId != null : !this.bufferId.equals(other.bufferId)) {
            return false;
        }
        if (this.outPort == null ? other.outPort != null : !this.outPort.equals(other.outPort)) {
            return false;
        }
        if (this.outGroup == null ? other.outGroup != null : !this.outGroup.equals(other.outGroup)) {
            return false;
        }
        if (this.flags == null ? other.flags != null : !this.flags.equals(other.flags)) {
            return false;
        }
        if (this.match == null ? other.match != null : !this.match.equals(other.match)) {
            return false;
        }
        return !(this.instructions == null ? other.instructions != null : !this.instructions.equals(other.instructions));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + (this.cookie == null ? 0 : this.cookie.hashCode());
        result = 31 * result + (this.cookieMask == null ? 0 : this.cookieMask.hashCode());
        result = 31 * result + (this.tableId == null ? 0 : this.tableId.hashCode());
        result = 31 * result + this.idleTimeout;
        result = 31 * result + this.hardTimeout;
        result = 31 * result + this.priority;
        result = 31 * result + (this.bufferId == null ? 0 : this.bufferId.hashCode());
        result = 31 * result + (this.outPort == null ? 0 : this.outPort.hashCode());
        result = 31 * result + (this.outGroup == null ? 0 : this.outGroup.hashCode());
        result = 31 * result + (this.flags == null ? 0 : this.flags.hashCode());
        result = 31 * result + (this.match == null ? 0 : this.match.hashCode());
        result = 31 * result + (this.instructions == null ? 0 : this.instructions.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFFlowModifyVer13> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFFlowModifyVer13 message) {
            int startIndex = bb.writerIndex();
            bb.writeByte(4);
            bb.writeByte(14);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            bb.writeInt(U32.t(message.xid));
            bb.writeLong(message.cookie.getValue());
            bb.writeLong(message.cookieMask.getValue());
            message.tableId.writeByte(bb);
            bb.writeByte(1);
            bb.writeShort((int)U16.t(message.idleTimeout));
            bb.writeShort((int)U16.t(message.hardTimeout));
            bb.writeShort((int)U16.t(message.priority));
            bb.writeInt(message.bufferId.getInt());
            message.outPort.write4Bytes(bb);
            message.outGroup.write4Bytes(bb);
            OFFlowModFlagsSerializerVer13.writeTo(bb, message.flags);
            bb.writeZero(2);
            message.match.writeTo(bb);
            ChannelUtils.writeList(bb, message.instructions);
            int length = bb.writerIndex() - startIndex;
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFFlowModifyVer13Funnel
    implements Funnel<OFFlowModifyVer13> {
        private static final long serialVersionUID = 1L;

        OFFlowModifyVer13Funnel() {
        }

        public void funnel(OFFlowModifyVer13 message, PrimitiveSink sink) {
            sink.putByte((byte)4);
            sink.putByte((byte)14);
            sink.putLong(message.xid);
            message.cookie.putTo(sink);
            message.cookieMask.putTo(sink);
            message.tableId.putTo(sink);
            sink.putShort((short)1);
            sink.putInt(message.idleTimeout);
            sink.putInt(message.hardTimeout);
            sink.putInt(message.priority);
            message.bufferId.putTo(sink);
            message.outPort.putTo(sink);
            message.outGroup.putTo(sink);
            OFFlowModFlagsSerializerVer13.putTo(message.flags, sink);
            message.match.putTo(sink);
            FunnelUtils.putList(message.instructions, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFFlowModify> {
        Reader() {
        }

        @Override
        public OFFlowModify readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 4) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_13(4), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 14) {
                throw new OFParseError("Wrong type: Expected=OFType.FLOW_MOD(14), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 56) {
                throw new OFParseError("Wrong length: Expected to be >= 56, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            U64 cookie = U64.ofRaw(bb.readLong());
            U64 cookieMask = U64.ofRaw(bb.readLong());
            TableId tableId = TableId.readByte(bb);
            short command = bb.readByte();
            if (command != 1) {
                throw new OFParseError("Wrong command: Expected=OFFlowModCommand.MODIFY(1), got=" + command);
            }
            int idleTimeout = U16.f(bb.readShort());
            int hardTimeout = U16.f(bb.readShort());
            int priority = U16.f(bb.readShort());
            OFBufferId bufferId = OFBufferId.of(bb.readInt());
            OFPort outPort = OFPort.read4Bytes(bb);
            OFGroup outGroup = OFGroup.read4Bytes(bb);
            Set<OFFlowModFlags> flags = OFFlowModFlagsSerializerVer13.readFrom(bb);
            bb.skipBytes(2);
            Match match = ChannelUtilsVer13.readOFMatch(bb);
            List<OFInstruction> instructions = ChannelUtils.readList(bb, length - (bb.readerIndex() - start), OFInstructionVer13.READER);
            OFFlowModifyVer13 flowModifyVer13 = new OFFlowModifyVer13(xid, cookie, cookieMask, tableId, idleTimeout, hardTimeout, priority, bufferId, outPort, outGroup, flags, match, instructions);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)flowModifyVer13);
            }
            return flowModifyVer13;
        }
    }

    static class Builder
    implements OFFlowModify.Builder {
        private boolean xidSet;
        private long xid;
        private boolean cookieSet;
        private U64 cookie;
        private boolean cookieMaskSet;
        private U64 cookieMask;
        private boolean tableIdSet;
        private TableId tableId;
        private boolean idleTimeoutSet;
        private int idleTimeout;
        private boolean hardTimeoutSet;
        private int hardTimeout;
        private boolean prioritySet;
        private int priority;
        private boolean bufferIdSet;
        private OFBufferId bufferId;
        private boolean outPortSet;
        private OFPort outPort;
        private boolean outGroupSet;
        private OFGroup outGroup;
        private boolean flagsSet;
        private Set<OFFlowModFlags> flags;
        private boolean matchSet;
        private Match match;
        private boolean instructionsSet;
        private List<OFInstruction> instructions;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFType getType() {
            return OFType.FLOW_MOD;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFFlowModify.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public U64 getCookie() {
            return this.cookie;
        }

        @Override
        public OFFlowModify.Builder setCookie(U64 cookie) {
            this.cookie = cookie;
            this.cookieSet = true;
            return this;
        }

        @Override
        public U64 getCookieMask() {
            return this.cookieMask;
        }

        @Override
        public OFFlowModify.Builder setCookieMask(U64 cookieMask) {
            this.cookieMask = cookieMask;
            this.cookieMaskSet = true;
            return this;
        }

        @Override
        public TableId getTableId() {
            return this.tableId;
        }

        @Override
        public OFFlowModify.Builder setTableId(TableId tableId) {
            this.tableId = tableId;
            this.tableIdSet = true;
            return this;
        }

        @Override
        public OFFlowModCommand getCommand() {
            return OFFlowModCommand.MODIFY;
        }

        @Override
        public int getIdleTimeout() {
            return this.idleTimeout;
        }

        @Override
        public OFFlowModify.Builder setIdleTimeout(int idleTimeout) {
            this.idleTimeout = idleTimeout;
            this.idleTimeoutSet = true;
            return this;
        }

        @Override
        public int getHardTimeout() {
            return this.hardTimeout;
        }

        @Override
        public OFFlowModify.Builder setHardTimeout(int hardTimeout) {
            this.hardTimeout = hardTimeout;
            this.hardTimeoutSet = true;
            return this;
        }

        @Override
        public int getPriority() {
            return this.priority;
        }

        @Override
        public OFFlowModify.Builder setPriority(int priority) {
            this.priority = priority;
            this.prioritySet = true;
            return this;
        }

        @Override
        public OFBufferId getBufferId() {
            return this.bufferId;
        }

        @Override
        public OFFlowModify.Builder setBufferId(OFBufferId bufferId) {
            this.bufferId = bufferId;
            this.bufferIdSet = true;
            return this;
        }

        @Override
        public OFPort getOutPort() {
            return this.outPort;
        }

        @Override
        public OFFlowModify.Builder setOutPort(OFPort outPort) {
            this.outPort = outPort;
            this.outPortSet = true;
            return this;
        }

        @Override
        public OFGroup getOutGroup() {
            return this.outGroup;
        }

        @Override
        public OFFlowModify.Builder setOutGroup(OFGroup outGroup) {
            this.outGroup = outGroup;
            this.outGroupSet = true;
            return this;
        }

        @Override
        public Set<OFFlowModFlags> getFlags() {
            return this.flags;
        }

        @Override
        public OFFlowModify.Builder setFlags(Set<OFFlowModFlags> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public Match getMatch() {
            return this.match;
        }

        @Override
        public OFFlowModify.Builder setMatch(Match match) {
            this.match = match;
            this.matchSet = true;
            return this;
        }

        @Override
        public List<OFInstruction> getInstructions() {
            return this.instructions;
        }

        @Override
        public OFFlowModify.Builder setInstructions(List<OFInstruction> instructions) {
            this.instructions = instructions;
            this.instructionsSet = true;
            return this;
        }

        @Override
        public List<OFAction> getActions() throws UnsupportedOperationException {
            if (!this.instructionsSet) {
                return Collections.emptyList();
            }
            for (OFInstruction inst : this.instructions) {
                if (!(inst instanceof OFInstructionApplyActions)) continue;
                OFInstructionApplyActions iap = (OFInstructionApplyActions)inst;
                return iap.getActions();
            }
            return Collections.emptyList();
        }

        @Override
        public OFFlowModify.Builder setActions(List<OFAction> actions) throws UnsupportedOperationException {
            OFInstructionApplyActionsVer13.Builder builder = new OFInstructionApplyActionsVer13.Builder();
            builder.setActions(actions);
            this.instructions = Collections.singletonList(builder.build());
            this.instructionsSet = true;
            return this;
        }

        @Override
        public int getImportance() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property importance not supported in version 1.3");
        }

        @Override
        public OFFlowModify.Builder setImportance(int importance) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property importance not supported in version 1.3");
        }

        @Override
        public OFFlowModify build() {
            List<OFInstruction> instructions;
            Match match;
            Set<OFFlowModFlags> flags;
            OFGroup outGroup;
            OFPort outPort;
            OFBufferId bufferId;
            TableId tableId;
            U64 cookieMask;
            U64 cookie;
            long xid = this.xidSet ? this.xid : 0L;
            U64 u64 = cookie = this.cookieSet ? this.cookie : DEFAULT_COOKIE;
            if (cookie == null) {
                throw new NullPointerException("Property cookie must not be null");
            }
            U64 u642 = cookieMask = this.cookieMaskSet ? this.cookieMask : DEFAULT_COOKIE_MASK;
            if (cookieMask == null) {
                throw new NullPointerException("Property cookieMask must not be null");
            }
            TableId tableId2 = tableId = this.tableIdSet ? this.tableId : DEFAULT_TABLE_ID;
            if (tableId == null) {
                throw new NullPointerException("Property tableId must not be null");
            }
            int idleTimeout = this.idleTimeoutSet ? this.idleTimeout : 0;
            int hardTimeout = this.hardTimeoutSet ? this.hardTimeout : 0;
            int priority = this.prioritySet ? this.priority : 0;
            OFBufferId oFBufferId = bufferId = this.bufferIdSet ? this.bufferId : DEFAULT_BUFFER_ID;
            if (bufferId == null) {
                throw new NullPointerException("Property bufferId must not be null");
            }
            OFPort oFPort = outPort = this.outPortSet ? this.outPort : DEFAULT_OUT_PORT;
            if (outPort == null) {
                throw new NullPointerException("Property outPort must not be null");
            }
            OFGroup oFGroup = outGroup = this.outGroupSet ? this.outGroup : DEFAULT_OUT_GROUP;
            if (outGroup == null) {
                throw new NullPointerException("Property outGroup must not be null");
            }
            Set<OFFlowModFlags> set = flags = this.flagsSet ? this.flags : DEFAULT_FLAGS;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            Match match2 = match = this.matchSet ? this.match : DEFAULT_MATCH;
            if (match == null) {
                throw new NullPointerException("Property match must not be null");
            }
            List<OFInstruction> list = instructions = this.instructionsSet ? this.instructions : DEFAULT_INSTRUCTIONS;
            if (instructions == null) {
                throw new NullPointerException("Property instructions must not be null");
            }
            return new OFFlowModifyVer13(xid, cookie, cookieMask, tableId, idleTimeout, hardTimeout, priority, bufferId, outPort, outGroup, flags, match, instructions);
        }
    }

    static class BuilderWithParent
    implements OFFlowModify.Builder {
        final OFFlowModifyVer13 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean cookieSet;
        private U64 cookie;
        private boolean cookieMaskSet;
        private U64 cookieMask;
        private boolean tableIdSet;
        private TableId tableId;
        private boolean idleTimeoutSet;
        private int idleTimeout;
        private boolean hardTimeoutSet;
        private int hardTimeout;
        private boolean prioritySet;
        private int priority;
        private boolean bufferIdSet;
        private OFBufferId bufferId;
        private boolean outPortSet;
        private OFPort outPort;
        private boolean outGroupSet;
        private OFGroup outGroup;
        private boolean flagsSet;
        private Set<OFFlowModFlags> flags;
        private boolean matchSet;
        private Match match;
        private boolean instructionsSet;
        private List<OFInstruction> instructions;

        BuilderWithParent(OFFlowModifyVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFType getType() {
            return OFType.FLOW_MOD;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFFlowModify.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public U64 getCookie() {
            return this.cookie;
        }

        @Override
        public OFFlowModify.Builder setCookie(U64 cookie) {
            this.cookie = cookie;
            this.cookieSet = true;
            return this;
        }

        @Override
        public U64 getCookieMask() {
            return this.cookieMask;
        }

        @Override
        public OFFlowModify.Builder setCookieMask(U64 cookieMask) {
            this.cookieMask = cookieMask;
            this.cookieMaskSet = true;
            return this;
        }

        @Override
        public TableId getTableId() {
            return this.tableId;
        }

        @Override
        public OFFlowModify.Builder setTableId(TableId tableId) {
            this.tableId = tableId;
            this.tableIdSet = true;
            return this;
        }

        @Override
        public OFFlowModCommand getCommand() {
            return OFFlowModCommand.MODIFY;
        }

        @Override
        public int getIdleTimeout() {
            return this.idleTimeout;
        }

        @Override
        public OFFlowModify.Builder setIdleTimeout(int idleTimeout) {
            this.idleTimeout = idleTimeout;
            this.idleTimeoutSet = true;
            return this;
        }

        @Override
        public int getHardTimeout() {
            return this.hardTimeout;
        }

        @Override
        public OFFlowModify.Builder setHardTimeout(int hardTimeout) {
            this.hardTimeout = hardTimeout;
            this.hardTimeoutSet = true;
            return this;
        }

        @Override
        public int getPriority() {
            return this.priority;
        }

        @Override
        public OFFlowModify.Builder setPriority(int priority) {
            this.priority = priority;
            this.prioritySet = true;
            return this;
        }

        @Override
        public OFBufferId getBufferId() {
            return this.bufferId;
        }

        @Override
        public OFFlowModify.Builder setBufferId(OFBufferId bufferId) {
            this.bufferId = bufferId;
            this.bufferIdSet = true;
            return this;
        }

        @Override
        public OFPort getOutPort() {
            return this.outPort;
        }

        @Override
        public OFFlowModify.Builder setOutPort(OFPort outPort) {
            this.outPort = outPort;
            this.outPortSet = true;
            return this;
        }

        @Override
        public OFGroup getOutGroup() {
            return this.outGroup;
        }

        @Override
        public OFFlowModify.Builder setOutGroup(OFGroup outGroup) {
            this.outGroup = outGroup;
            this.outGroupSet = true;
            return this;
        }

        @Override
        public Set<OFFlowModFlags> getFlags() {
            return this.flags;
        }

        @Override
        public OFFlowModify.Builder setFlags(Set<OFFlowModFlags> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public Match getMatch() {
            return this.match;
        }

        @Override
        public OFFlowModify.Builder setMatch(Match match) {
            this.match = match;
            this.matchSet = true;
            return this;
        }

        @Override
        public List<OFInstruction> getInstructions() {
            return this.instructions;
        }

        @Override
        public OFFlowModify.Builder setInstructions(List<OFInstruction> instructions) {
            this.instructions = instructions;
            this.instructionsSet = true;
            return this;
        }

        @Override
        public List<OFAction> getActions() throws UnsupportedOperationException {
            if (!this.instructionsSet) {
                return this.parentMessage.getActions();
            }
            for (OFInstruction inst : this.instructions) {
                if (!(inst instanceof OFInstructionApplyActions)) continue;
                OFInstructionApplyActions iap = (OFInstructionApplyActions)inst;
                return iap.getActions();
            }
            return Collections.emptyList();
        }

        @Override
        public OFFlowModify.Builder setActions(List<OFAction> actions) throws UnsupportedOperationException {
            OFInstructionApplyActionsVer13.Builder builder = new OFInstructionApplyActionsVer13.Builder();
            builder.setActions(actions);
            this.instructions = Collections.singletonList(builder.build());
            this.instructionsSet = true;
            return this;
        }

        @Override
        public int getImportance() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property importance not supported in version 1.3");
        }

        @Override
        public OFFlowModify.Builder setImportance(int importance) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property importance not supported in version 1.3");
        }

        @Override
        public OFFlowModify build() {
            List instructions;
            Match match;
            Set flags;
            OFGroup outGroup;
            OFPort outPort;
            OFBufferId bufferId;
            TableId tableId;
            U64 cookieMask;
            U64 cookie;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            U64 u64 = cookie = this.cookieSet ? this.cookie : this.parentMessage.cookie;
            if (cookie == null) {
                throw new NullPointerException("Property cookie must not be null");
            }
            U64 u642 = cookieMask = this.cookieMaskSet ? this.cookieMask : this.parentMessage.cookieMask;
            if (cookieMask == null) {
                throw new NullPointerException("Property cookieMask must not be null");
            }
            TableId tableId2 = tableId = this.tableIdSet ? this.tableId : this.parentMessage.tableId;
            if (tableId == null) {
                throw new NullPointerException("Property tableId must not be null");
            }
            int idleTimeout = this.idleTimeoutSet ? this.idleTimeout : this.parentMessage.idleTimeout;
            int hardTimeout = this.hardTimeoutSet ? this.hardTimeout : this.parentMessage.hardTimeout;
            int priority = this.prioritySet ? this.priority : this.parentMessage.priority;
            OFBufferId oFBufferId = bufferId = this.bufferIdSet ? this.bufferId : this.parentMessage.bufferId;
            if (bufferId == null) {
                throw new NullPointerException("Property bufferId must not be null");
            }
            OFPort oFPort = outPort = this.outPortSet ? this.outPort : this.parentMessage.outPort;
            if (outPort == null) {
                throw new NullPointerException("Property outPort must not be null");
            }
            OFGroup oFGroup = outGroup = this.outGroupSet ? this.outGroup : this.parentMessage.outGroup;
            if (outGroup == null) {
                throw new NullPointerException("Property outGroup must not be null");
            }
            Set set = flags = this.flagsSet ? this.flags : this.parentMessage.flags;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            Match match2 = match = this.matchSet ? this.match : this.parentMessage.match;
            if (match == null) {
                throw new NullPointerException("Property match must not be null");
            }
            List list = instructions = this.instructionsSet ? this.instructions : this.parentMessage.instructions;
            if (instructions == null) {
                throw new NullPointerException("Property instructions must not be null");
            }
            return new OFFlowModifyVer13(xid, cookie, cookieMask, tableId, idleTimeout, hardTimeout, priority, bufferId, outPort, outGroup, flags, match, instructions);
        }
    }
}

