/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFOchSignalId;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U8;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOchSignalIdVer13
implements OFOchSignalId {
    private static final Logger logger = LoggerFactory.getLogger(OFOchSignalIdVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 6;
    private static final short DEFAULT_GRID = 0;
    private static final short DEFAULT_CS = 0;
    private static final int DEFAULT_N = 0;
    private static final int DEFAULT_M = 0;
    private final short grid;
    private final short cs;
    private final int n;
    private final int m;
    static final OFOchSignalIdVer13 DEFAULT = new OFOchSignalIdVer13(0, 0, 0, 0);
    static final Reader READER = new Reader();
    static final OFOchSignalIdVer13Funnel FUNNEL = new OFOchSignalIdVer13Funnel();
    static final Writer WRITER = new Writer();

    OFOchSignalIdVer13(short grid, short cs, int n, int m) {
        this.grid = grid;
        this.cs = cs;
        this.n = n;
        this.m = m;
    }

    @Override
    public short getGrid() {
        return this.grid;
    }

    @Override
    public short getCs() {
        return this.cs;
    }

    @Override
    public int getN() {
        return this.n;
    }

    @Override
    public int getM() {
        return this.m;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFOchSignalId.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOchSignalIdVer13(");
        b.append("grid=").append(this.grid);
        b.append(", ");
        b.append("cs=").append(this.cs);
        b.append(", ");
        b.append("n=").append(this.n);
        b.append(", ");
        b.append("m=").append(this.m);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOchSignalIdVer13 other = (OFOchSignalIdVer13)obj;
        if (this.grid != other.grid) {
            return false;
        }
        if (this.cs != other.cs) {
            return false;
        }
        if (this.n != other.n) {
            return false;
        }
        return this.m == other.m;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.grid;
        result = 31 * result + this.cs;
        result = 31 * result + this.n;
        result = 31 * result + this.m;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOchSignalIdVer13> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFOchSignalIdVer13 message) {
            bb.writeByte((int)U8.t(message.grid));
            bb.writeByte((int)U8.t(message.cs));
            bb.writeShort((int)U16.t(message.n));
            bb.writeShort((int)U16.t(message.m));
        }
    }

    static class OFOchSignalIdVer13Funnel
    implements Funnel<OFOchSignalIdVer13> {
        private static final long serialVersionUID = 1L;

        OFOchSignalIdVer13Funnel() {
        }

        public void funnel(OFOchSignalIdVer13 message, PrimitiveSink sink) {
            sink.putShort(message.grid);
            sink.putShort(message.cs);
            sink.putInt(message.n);
            sink.putInt(message.m);
        }
    }

    static class Reader
    implements OFMessageReader<OFOchSignalId> {
        Reader() {
        }

        @Override
        public OFOchSignalId readFrom(ChannelBuffer bb) throws OFParseError {
            short grid = U8.f(bb.readByte());
            short cs = U8.f(bb.readByte());
            int n = U16.f(bb.readShort());
            int m = U16.f(bb.readShort());
            OFOchSignalIdVer13 ochSignalIdVer13 = new OFOchSignalIdVer13(grid, cs, n, m);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)ochSignalIdVer13);
            }
            return ochSignalIdVer13;
        }
    }

    static class Builder
    implements OFOchSignalId.Builder {
        private boolean gridSet;
        private short grid;
        private boolean csSet;
        private short cs;
        private boolean nSet;
        private int n;
        private boolean mSet;
        private int m;

        Builder() {
        }

        @Override
        public short getGrid() {
            return this.grid;
        }

        @Override
        public OFOchSignalId.Builder setGrid(short grid) {
            this.grid = grid;
            this.gridSet = true;
            return this;
        }

        @Override
        public short getCs() {
            return this.cs;
        }

        @Override
        public OFOchSignalId.Builder setCs(short cs) {
            this.cs = cs;
            this.csSet = true;
            return this;
        }

        @Override
        public int getN() {
            return this.n;
        }

        @Override
        public OFOchSignalId.Builder setN(int n) {
            this.n = n;
            this.nSet = true;
            return this;
        }

        @Override
        public int getM() {
            return this.m;
        }

        @Override
        public OFOchSignalId.Builder setM(int m) {
            this.m = m;
            this.mSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFOchSignalId build() {
            short grid = this.gridSet ? this.grid : (short)0;
            short cs = this.csSet ? this.cs : (short)0;
            int n = this.nSet ? this.n : 0;
            int m = this.mSet ? this.m : 0;
            return new OFOchSignalIdVer13(grid, cs, n, m);
        }
    }

    static class BuilderWithParent
    implements OFOchSignalId.Builder {
        final OFOchSignalIdVer13 parentMessage;
        private boolean gridSet;
        private short grid;
        private boolean csSet;
        private short cs;
        private boolean nSet;
        private int n;
        private boolean mSet;
        private int m;

        BuilderWithParent(OFOchSignalIdVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public short getGrid() {
            return this.grid;
        }

        @Override
        public OFOchSignalId.Builder setGrid(short grid) {
            this.grid = grid;
            this.gridSet = true;
            return this;
        }

        @Override
        public short getCs() {
            return this.cs;
        }

        @Override
        public OFOchSignalId.Builder setCs(short cs) {
            this.cs = cs;
            this.csSet = true;
            return this;
        }

        @Override
        public int getN() {
            return this.n;
        }

        @Override
        public OFOchSignalId.Builder setN(int n) {
            this.n = n;
            this.nSet = true;
            return this;
        }

        @Override
        public int getM() {
            return this.m;
        }

        @Override
        public OFOchSignalId.Builder setM(int m) {
            this.m = m;
            this.mSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFOchSignalId build() {
            short grid = this.gridSet ? this.grid : this.parentMessage.grid;
            short cs = this.csSet ? this.cs : this.parentMessage.cs;
            int n = this.nSet ? this.n : this.parentMessage.n;
            int m = this.mSet ? this.m : this.parentMessage.m;
            return new OFOchSignalIdVer13(grid, cs, n, m);
        }
    }
}

